/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.database;

import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.SpecialDBOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.database.BaseSpecialDBOperation;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;

public class DBVendorType {
    private static final Object monitor = new Object();
    private static Properties defaultProperties;
    private static HashMap maps;
    private static HashMap opMaps;
    private HashMap dbMap;
    private SpecialDBOperation specialDBOperation;
    private String short_name;
    private String long_name;
    public static final String defaultDB = "SQL92";
    public static final String Mssql = "MSSQL";
    public static final String Oracle = "ORACLE";
    public static final String PointBase = "POINTBASE";
    public static final String Sybase = "SYBASE";
    public static final String Informix = "INFORMIX";
    public static final String Ingres = "INGRES";
    public static final String RDB = "RDB";
    public static final String DB2 = "DB2";
    public static final String ext = ".properties";
    public static final String space = " ";
    private static final String none = "";
    private static final String _true = "true";
    public static final String path = "com/sun/jdo/spi/persistence/support/sqlstore/database/";
    public static final String propertyFile = ".tpersistence.properties";
    private static final String FOR_UPDATE = "FOR_UPDATE";
    private static final String HOLDLOCK = "HOLDLOCK";
    private static final String SUPPORTS_UPDATE_LOCK = "SUPPORTS_UPDATE_LOCK";
    private static final String SUPPORTS_DISTINCT_WITH_UPDATE_LOCK = "SUPPORTS_DISTINCT_WITH_UPDATE_LOCK";
    private static final String LEFT_JOIN = "LEFT_JOIN";
    private static final String LEFT_JOIN_APPEND = "LEFT_JOIN_APPEND";
    private static final String RIGHT_JOIN = "RIGHT_JOIN";
    private static final String RIGHT_JOIN_PRE = "RIGHT_JOIN_PRE";
    private static final String IS_NULL = "IS_NULL";
    private static final String IS_NOT_NULL = "IS_NOT_NULL";
    private static final String RTRIM = "RTRIM";
    private static final String RTRIM_POST = "RTRIM_POST";
    private static final String TABLE_LIST_START = "TABLE_LIST_START";
    private static final String TABLE_LIST_END = "TABLE_LIST_END";
    private static final String OPT_NO_COLLECTIVE = "OPT_NO_COLLECTIVE";
    private static final String STRING_CONCAT = "STRING_CONCAT";
    private static final String QUOTE_CHAR_START = "QUOTE_CHAR_START";
    private static final String QUOTE_CHAR_END = "QUOTE_CHAR_END";
    private static final String QUOTE_SPECIAL_ONLY = "QUOTE_SPECIAL_ONLY";
    private static final String CHAR_LENGTH = "CHAR_LENGTH";
    private static final String SQRT = "SQRT";
    private static final String ABS = "ABS";
    private static final String SUBSTRING = "SUBSTRING";
    private static final String SUBSTRING_FROM = "SUBSTRING_FROM";
    private static final String SUBSTRING_FOR = "SUBSTRING_FOR";
    private static final String POSITION = "POSITION";
    private static final String POSITION_SEP = "POSITION_SEP";
    private static final String POSITION_SEARCH_SOURCE = "POSITION_SEARCH_SOURCE";
    private static final String POSITION_THREE_ARGS = "POSITION_THREE_ARGS";
    private static final String MAP_EMPTY_STRING_TO_NULL = "MAP_EMPTY_STRING_TO_NULL";
    private static final String SPECIAL_DB_OPERATION = "SPECIAL_DB_OPERATION";
    private static final String SUPPORTS_LIKE_ESCAPE = "SUPPORTS_LIKE_ESCAPE";
    private static final String LEFT_LIKE_ESCAPE = "LEFT_LIKE_ESCAPE";
    private static final String RIGHT_LIKE_ESCAPE = "RIGHT_LIKE_ESCAPE";
    private static final String NULL_COMPARISON_FUNCTION_NAME = "NULL_COMPARISON_FUNCTION_NAME";
    private static final String[] props;
    private static Logger logger;
    private static final ResourceBundle messages;
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$database$DBVendorType;

    public DBVendorType() throws IOException {
        this.short_name = defaultDB;
        this.initialize();
    }

    public DBVendorType(String string) throws IOException {
        this.long_name = string.toLowerCase().replace(' ', '_');
        this.long_name = this.long_name.replace('/', '_');
        if (string.compareTo("Microsoft SQL Server") == 0) {
            this.short_name = Mssql;
        } else if (this.long_name.startsWith("oracle")) {
            this.short_name = Oracle;
        } else if (this.long_name.startsWith("sybase") || this.long_name.startsWith("adaptive_server")) {
            this.short_name = Sybase;
        } else {
            this.short_name = string.toUpperCase();
            int n = this.short_name.indexOf(47);
            if (n > -1) {
                this.short_name = this.short_name.substring(0, n);
            }
        }
        if (logger.isLoggable()) {
            Object[] objectArray = new Object[]{string, this.long_name, this.short_name};
            logger.fine("sqlstore.database.dbvendor.vendorname", objectArray);
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws IOException {
        Object object;
        Properties properties;
        boolean bl;
        block14: {
            bl = logger.isLoggable();
            if (bl) {
                logger.fine("sqlstore.database.dbvendor.init");
            }
            if (defaultProperties == null) {
                defaultProperties = new Properties();
                this.load("com/sun/jdo/spi/persistence/support/sqlstore/database/SQL92.properties", defaultProperties, false);
                maps = new HashMap();
            }
            this.dbMap = (HashMap)maps.get(this.short_name);
            this.specialDBOperation = (SpecialDBOperation)opMaps.get(this.short_name);
            if (this.dbMap != null && this.specialDBOperation != null) {
                return;
            }
            properties = new Properties();
            if (!this.short_name.equals(defaultDB)) {
                try {
                    this.load(path + this.short_name + ext, properties, false);
                }
                catch (IOException iOException) {
                    if (!bl) break block14;
                    logger.fine("sqlstore.database.dbvendor.init.default");
                }
            }
        }
        this.overrideProperties(properties);
        this.dbMap = new HashMap<Object, Object>(defaultProperties);
        this.dbMap.putAll(properties);
        String string = (String)this.dbMap.get(SPECIAL_DB_OPERATION);
        if (string == null) {
            this.specialDBOperation = new BaseSpecialDBOperation();
        } else {
            object = (class$com$sun$jdo$spi$persistence$support$sqlstore$database$DBVendorType == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$database$DBVendorType = DBVendorType.class$("com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType")) : class$com$sun$jdo$spi$persistence$support$sqlstore$database$DBVendorType).getClassLoader();
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction((ClassLoader)object, string){
                private final /* synthetic */ ClassLoader val$loader;
                private final /* synthetic */ String val$specialDBOpClassStr;
                {
                    this.val$loader = classLoader;
                    this.val$specialDBOpClassStr = string;
                }

                public Object run() {
                    try {
                        if (this.val$loader != null) {
                            return Class.forName(this.val$specialDBOpClassStr, true, this.val$loader);
                        }
                        return Class.forName(this.val$specialDBOpClassStr);
                    }
                    catch (Exception exception) {
                        throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.cantloadclass", this.val$specialDBOpClassStr), exception);
                    }
                }
            });
            try {
                this.specialDBOperation = (SpecialDBOperation)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.cantinstantiateclass", string), exception);
            }
        }
        object = monitor;
        synchronized (object) {
            maps.put(this.short_name, this.dbMap);
            opMaps.put(this.short_name, this.specialDBOperation);
        }
        if (bl) {
            logger.fine("sqlstore.database.dbvendor.init.exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load(String string, Properties properties, boolean bl) throws IOException {
        Object[] objectArray;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        boolean bl2 = logger.isLoggable();
        if (bl2) {
            objectArray = new Object[]{string, new Boolean(bl)};
            logger.fine("sqlstore.database.dbvendor.load", objectArray);
        }
        try {
            if (bl) {
                inputStream2 = new FileInputStream(string);
            } else {
                objectArray = (class$com$sun$jdo$spi$persistence$support$sqlstore$database$DBVendorType == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$database$DBVendorType = DBVendorType.class$("com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType")) : class$com$sun$jdo$spi$persistence$support$sqlstore$database$DBVendorType).getClassLoader();
                inputStream2 = (InputStream)AccessController.doPrivileged(new PrivilegedAction((ClassLoader)objectArray, string){
                    private final /* synthetic */ ClassLoader val$loader;
                    private final /* synthetic */ String val$resourceName;
                    {
                        this.val$loader = classLoader;
                        this.val$resourceName = string;
                    }

                    public Object run() {
                        if (this.val$loader != null) {
                            return this.val$loader.getResourceAsStream(this.val$resourceName);
                        }
                        return ClassLoader.getSystemResourceAsStream(this.val$resourceName);
                    }
                });
            }
            if (inputStream2 == null) {
                throw new IOException(I18NHelper.getMessage(messages, "database.dbvendortype.resourcenotfound", string));
            }
            inputStream = new BufferedInputStream(inputStream2);
            properties.load(inputStream);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
    }

    public void overrideProperties(Properties properties) {
        boolean bl = logger.isLoggable();
        Properties properties2 = new Properties();
        try {
            this.load(propertyFile, properties2, true);
        }
        catch (Exception exception) {
            if (bl) {
                logger.fine("sqlstore.database.dbvendor.overrideproperties");
            }
            return;
        }
        String string = "database." + this.long_name + ".";
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = properties2.getProperty(string + props[n2]);
            if (string2 != null) {
                if (bl) {
                    Object[] objectArray = new Object[]{props[n2], string2};
                    logger.fine("sqlstore.database.dbvendor.overrideproperties.with", objectArray);
                }
                properties.setProperty(props[n2], string2);
            }
            ++n2;
        }
    }

    public String getLeftJoin() {
        String string = (String)this.dbMap.get(LEFT_JOIN);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getleftjoin", string);
        }
        return space + string;
    }

    public boolean isUpdateLockSupported() {
        boolean bl;
        String string = (String)this.dbMap.get(SUPPORTS_UPDATE_LOCK);
        boolean bl2 = bl = string != null && string.equals(_true);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.isupdatelocksupported", new Boolean(bl));
        }
        return bl;
    }

    public boolean isDistinctSupportedWithUpdateLock() {
        boolean bl;
        String string = (String)this.dbMap.get(SUPPORTS_DISTINCT_WITH_UPDATE_LOCK);
        boolean bl2 = bl = string != null && string.equals(_true);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.isdistinctupdatelocksupported", new Boolean(bl));
        }
        return bl;
    }

    public String getHoldlock() {
        String string = (String)this.dbMap.get(HOLDLOCK);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getholdlock", string);
        }
        return space + string;
    }

    public String getLeftJoinPost() {
        String string = (String)this.dbMap.get(LEFT_JOIN_APPEND);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getleftjoinpost", string);
        }
        return space + string;
    }

    public String getRightJoin() {
        String string = (String)this.dbMap.get(RIGHT_JOIN);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getrightjoin", string);
        }
        return space + string;
    }

    public String getRightJoinPre() {
        String string = (String)this.dbMap.get(RIGHT_JOIN_PRE);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getrightjoinipre", string);
        }
        return space + string;
    }

    public String getIsNull() {
        String string = (String)this.dbMap.get(IS_NULL);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getisnull", string);
        }
        return space + string;
    }

    public String getIsNotNull() {
        String string = (String)this.dbMap.get(IS_NOT_NULL);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getisnotnull", string);
        }
        return space + string;
    }

    public String getRtrim() {
        String string = (String)this.dbMap.get(RTRIM);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getrtrim");
        }
        return space + string;
    }

    public String getRtrimPost() {
        String string = (String)this.dbMap.get(RTRIM_POST);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getrtrimpost", string);
        }
        return space + string;
    }

    public String getCharLength() {
        String string = (String)this.dbMap.get(CHAR_LENGTH);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getcharlength", string);
        }
        return space + string;
    }

    public String getSqrt() {
        String string = (String)this.dbMap.get(SQRT);
        if (string == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "Sqrt"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getsqrt", string);
        }
        return space + string;
    }

    public String getAbs() {
        String string = (String)this.dbMap.get(ABS);
        if (string == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "Abs"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getabs", string);
        }
        return space + string;
    }

    public String getForUpdate() {
        String string = (String)this.dbMap.get(FOR_UPDATE);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getforupdate", string);
        }
        return space + string;
    }

    public String getTableListStart() {
        String string = (String)this.dbMap.get(TABLE_LIST_START);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.gettableliststart", string);
        }
        return space + string;
    }

    public String getTableListEnd() {
        String string = (String)this.dbMap.get(TABLE_LIST_END);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.gettablelistend", string);
        }
        return space + string;
    }

    public int getOptNoCollective() {
        String string = (String)this.dbMap.get(OPT_NO_COLLECTIVE);
        int n = string == null || string.equals(none) ? 0 : 1;
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getoptnocollective", new Integer(n));
        }
        return n;
    }

    public String getStringConcat() {
        String string = (String)this.dbMap.get(STRING_CONCAT);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getstringconcat", string);
        }
        return space + string + space;
    }

    public String getQuoteCharStart() {
        String string = (String)this.dbMap.get(QUOTE_CHAR_START);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getquotecharstart", string);
        }
        return string;
    }

    public String getQuoteCharEnd() {
        String string = (String)this.dbMap.get(QUOTE_CHAR_END);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getquotecharend", string);
        }
        return string;
    }

    public boolean getQuoteSpecialOnly() {
        String string = (String)this.dbMap.get(QUOTE_SPECIAL_ONLY);
        boolean bl = string != null && string.equals(_true);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getquotespecialonly", new Boolean(bl));
        }
        return bl;
    }

    public String getSubstring() {
        String string = (String)this.dbMap.get(SUBSTRING);
        if (string == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "substring"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getsubstring", string);
        }
        return space + string;
    }

    public String getSubstringFrom() {
        String string = (String)this.dbMap.get(SUBSTRING_FROM);
        if (string == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "from part of substring"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getsubstringfrom", string);
        }
        return space + string;
    }

    public String getSubstringFor() {
        String string = (String)this.dbMap.get(SUBSTRING_FOR);
        if (string == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "for part of substring"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getsubstringfor", string);
        }
        return space + string;
    }

    public String getPosition() {
        String string = (String)this.dbMap.get(POSITION);
        if (string == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "position"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getposition", string);
        }
        return space + string;
    }

    public String getPositionSep() {
        String string = (String)this.dbMap.get(POSITION_SEP);
        if (string == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "in part of position"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getpositionin", string);
        }
        return space + string;
    }

    public boolean isPositionSearchSource() {
        boolean bl;
        String string = (String)this.dbMap.get(POSITION_SEARCH_SOURCE);
        boolean bl2 = bl = string != null && string.equals(_true);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getpositionsrchsrc", new Boolean(bl));
        }
        return bl;
    }

    public boolean isPositionThreeArgs() {
        boolean bl;
        String string = (String)this.dbMap.get(POSITION_THREE_ARGS);
        boolean bl2 = bl = string != null && string.equals(_true);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getposition3args", new Boolean(bl));
        }
        return bl;
    }

    public boolean mapEmptyStringToNull() {
        boolean bl;
        String string = (String)this.dbMap.get(MAP_EMPTY_STRING_TO_NULL);
        boolean bl2 = bl = string != null && string.equals(_true);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.mapemptystrtonull", new Boolean(bl));
        }
        return bl;
    }

    public boolean supportsLikeEscape() {
        boolean bl;
        String string = (String)this.dbMap.get(SUPPORTS_LIKE_ESCAPE);
        boolean bl2 = bl = string != null && string.equals(_true);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.supportslikeescape", new Boolean(bl));
        }
        return bl;
    }

    public String getLeftLikeEscape() {
        String string = (String)this.dbMap.get(LEFT_LIKE_ESCAPE);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getleftlikeescape", string);
        }
        return space + string;
    }

    public String getRightLikeEscape() {
        String string = (String)this.dbMap.get(RIGHT_LIKE_ESCAPE);
        if (string == null) {
            string = none;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getrightlikeescape", string);
        }
        return space + string;
    }

    public String getNullComparisonFunctionName() {
        String string = (String)this.dbMap.get(NULL_COMPARISON_FUNCTION_NAME);
        string = string == null ? none : string.trim();
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getNullComparisonFunctionName", string);
        }
        return string;
    }

    public String getName() {
        return this.short_name;
    }

    public SpecialDBOperation getSpecialDBOperation() {
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getSpecialDBOperation", this.specialDBOperation);
        }
        return this.specialDBOperation;
    }

    public String getParameterMarker(int n) {
        String string;
        String string2 = "?";
        if (DB2.equals(this.getName()) && (string = DBVendorType.getCastTypeforDB2(n)) != null) {
            string2 = "CAST (? AS " + string + ")";
        }
        return string2;
    }

    private static String getCastTypeforDB2(int n) {
        String string = null;
        switch (n) {
            case 1: 
            case 11: {
                string = "SMALLINT";
                break;
            }
            case 2: 
            case 12: {
                string = "INTEGER";
                break;
            }
            case 3: 
            case 13: {
                string = "SMALLINT";
                break;
            }
            case 4: 
            case 14: {
                string = "SMALLINT";
                break;
            }
            case 5: 
            case 15: {
                string = "INTEGER";
                break;
            }
            case 6: 
            case 16: {
                string = "BIGINT";
                break;
            }
            case 7: 
            case 17: {
                string = "REAL";
                break;
            }
            case 8: 
            case 18: {
                string = "DOUBLE";
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        opMaps = new HashMap();
        props = new String[]{FOR_UPDATE, HOLDLOCK, SUPPORTS_UPDATE_LOCK, SUPPORTS_DISTINCT_WITH_UPDATE_LOCK, QUOTE_CHAR_START, QUOTE_CHAR_END, QUOTE_SPECIAL_ONLY, STRING_CONCAT, CHAR_LENGTH, SQRT, ABS, SUBSTRING, SUBSTRING_FROM, SUBSTRING_FOR, POSITION, POSITION_SEP, POSITION_SEARCH_SOURCE, POSITION_THREE_ARGS, MAP_EMPTY_STRING_TO_NULL, SPECIAL_DB_OPERATION, SUPPORTS_LIKE_ESCAPE, LEFT_LIKE_ESCAPE, RIGHT_LIKE_ESCAPE, NULL_COMPARISON_FUNCTION_NAME};
        logger = LogHelperSQLStore.getLogger();
        messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (class$com$sun$jdo$spi$persistence$support$sqlstore$database$DBVendorType == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$database$DBVendorType = DBVendorType.class$("com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType")) : class$com$sun$jdo$spi$persistence$support$sqlstore$database$DBVendorType).getClassLoader());
    }
}

