/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.ResultDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.UpdateDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.UpdateObjectDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.ValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.SqlID;
import com.sun.jdo.spi.persistence.support.sqlstore.model.SqlIDDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.RetrieveDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateObjectDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.Concurrency;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.Constraint;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.DBStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputParamValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectQueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateQueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateStatement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;

public class SQLStoreManager
implements PersistenceStore {
    private Map classConfigs = new HashMap();
    private Map classByOidTable = new Hashtable();
    private DBVendorType vendorType;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(class$com$sun$jdo$spi$persistence$support$sqlstore$SQLStoreManager == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$SQLStoreManager = SQLStoreManager.class$("com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager")) : class$com$sun$jdo$spi$persistence$support$sqlstore$SQLStoreManager);
    private static int fetchSize = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager.fetchSize", -1);
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$SQLStoreManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceConfig getPersistenceConfig(Class clazz) {
        PersistenceConfig persistenceConfig = null;
        if (logger.isLoggable(400)) {
            logger.finer("sqlstore.sqlstoremanager.getpersistenceconfig", clazz.getName());
        }
        Map map = this.classConfigs;
        synchronized (map) {
            persistenceConfig = (PersistenceConfig)this.classConfigs.get(clazz);
            if (persistenceConfig != null) {
                return persistenceConfig;
            }
            try {
                Model model = Model.RUNTIME;
                String string = clazz.getName();
                ClassLoader classLoader = clazz.getClassLoader();
                MappingClassElement mappingClassElement = model.getMappingClass(string, classLoader);
                Collection collection = null;
                collection = model.validate(string, classLoader, null);
                if (!collection.isEmpty()) {
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        logger.severe(I18NHelper.getMessage(messages, "core.configuration.validationproblem", string, iterator.next().toString()));
                    }
                    throw new JDOUserException(I18NHelper.getMessage(messages, "core.configuration.validationfailed", string));
                }
                ClassDesc classDesc = new ClassDesc(mappingClassElement, clazz);
                this.classConfigs.put(clazz, classDesc);
                classDesc.initialize(this);
                this.classByOidTable.put(classDesc.getOidClass(), clazz);
                persistenceConfig = classDesc;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.loadfailed", clazz.getName()), illegalArgumentException);
            }
            catch (Exception exception) {
                logger.log(500, "sqlstore.exception.log", exception);
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.loadfailed", clazz.getName()), exception);
            }
        }
        return persistenceConfig;
    }

    public void execute(PersistenceManager persistenceManager, Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ActionDesc actionDesc = (ActionDesc)iterator.next();
            if (actionDesc instanceof UpdateObjectDescImpl) {
                UpdateObjectDescImpl updateObjectDescImpl = (UpdateObjectDescImpl)actionDesc;
                ClassDesc classDesc = this.validateAction(actionDesc);
                UpdateQueryPlan updateQueryPlan = new UpdateQueryPlan(updateObjectDescImpl, this);
                updateQueryPlan.build();
                int n = 0;
                int n2 = updateQueryPlan.statements.size();
                while (n < n2) {
                    Statement statement = (Statement)updateQueryPlan.statements.get(n);
                    if (statement != null) {
                        this.executeUpdate(persistenceManager, statement);
                    }
                    ++n;
                }
                continue;
            }
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", actionDesc.getClass().getName(), "UpdateObjectDescImpl"));
        }
    }

    private void rollbackXact(Transaction transaction) {
        try {
            transaction.setRollbackOnly();
        }
        catch (Exception exception) {}
    }

    private void bindInputColumn(DBStatement dBStatement, int n, InputValue inputValue, int n2) throws SQLException {
        dBStatement.bindInputColumn(n, inputValue.value, n2, this.vendorType);
    }

    private void bindInputColumn(DBStatement dBStatement, int n, InputValue inputValue, int n2, ValueFetcher valueFetcher) throws SQLException {
        Object object;
        if (inputValue instanceof InputParamValue) {
            int n3 = (Integer)inputValue.value;
            object = valueFetcher.getValue(n3);
        } else {
            object = inputValue.value;
        }
        dBStatement.bindInputColumn(n, object, n2, this.vendorType);
    }

    private void bindInputColumn(DBStatement dBStatement, ColumnRef columnRef, UpdateObjectDescImpl updateObjectDescImpl, boolean bl) throws SQLException {
        LocalFieldDesc localFieldDesc = (LocalFieldDesc)columnRef.getValue();
        Object object = localFieldDesc.isHorizontalDiscriminator() ? localFieldDesc.getDiscriminatorValue() : (bl ? updateObjectDescImpl.getAfterValue(localFieldDesc) : updateObjectDescImpl.getBeforeValue(localFieldDesc));
        dBStatement.bindInputColumn(columnRef.getIndex(), object, columnRef.getColumnElement().getType(), this.vendorType);
    }

    private void executeUpdate(PersistenceManager persistenceManager, Statement statement) {
        int n = 0;
        DBStatement dBStatement = null;
        Connection connection = null;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.executeupdate");
        }
        Transaction transaction = (Transaction)persistenceManager.currentTransaction();
        try {
            try {
                connection = transaction.getConnection();
                String string = statement.getText();
                if (string.length() > 0) {
                    if (bl) {
                        if (logger.isLoggable(400)) {
                            logger.finer(SQLStoreManager.formatSqlText(string, statement.inputDesc));
                        } else {
                            logger.fine(SQLStoreManager.formatSqlText(string, null));
                        }
                    }
                    dBStatement = new DBStatement(connection, string, transaction.getUpdateTimeout());
                    int n2 = 0;
                    int n3 = statement.inputDesc.values.size();
                    while (n2 < n3) {
                        InputValue inputValue = (InputValue)statement.inputDesc.values.get(n2);
                        this.bindInputColumn(dBStatement, n2 + 1, inputValue, inputValue.sqlType);
                        ++n2;
                    }
                    n = dBStatement.executeUpdate();
                    if (n < statement.minAffectedRows) {
                        this.rollbackXact(transaction);
                        int n4 = string.indexOf(32);
                        throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.store.operationfailed", string.substring(0, n4)));
                    }
                }
                Object var13_14 = null;
            }
            catch (SQLException sQLException) {
                this.rollbackXact(transaction);
                throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.persistencestore.jdbcerror"), sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            SQLStoreManager.close(dBStatement);
            SQLStoreManager.closeConnection(transaction, connection);
            throw throwable;
        }
        SQLStoreManager.close(dBStatement);
        SQLStoreManager.closeConnection(transaction, connection);
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.executeupdate.exit", new Integer(n));
        }
    }

    public Class getClassByOidClass(Class clazz) {
        return (Class)this.classByOidTable.get(clazz);
    }

    public StateManager getStateManager(Class clazz) {
        ClassDesc classDesc = (ClassDesc)this.getPersistenceConfig(clazz);
        if (classDesc != null) {
            return classDesc.newStateManagerInstance(this);
        }
        return null;
    }

    public RetrieveDesc getRetrieveDesc(Class clazz) {
        RetrieveDescImpl retrieveDescImpl = new RetrieveDescImpl(clazz);
        retrieveDescImpl.options |= this.getVendorType().getOptNoCollective();
        return retrieveDescImpl;
    }

    public RetrieveDesc getRetrieveDesc(String string, Class clazz) {
        FieldDesc fieldDesc;
        ClassDesc classDesc = (ClassDesc)this.getPersistenceConfig(clazz);
        if (classDesc != null && (fieldDesc = classDesc.getField(string)) instanceof ForeignFieldDesc) {
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)fieldDesc;
            return this.getRetrieveDesc(foreignFieldDesc.foreignConfig.getPersistenceCapableClass());
        }
        return null;
    }

    public UpdateObjectDesc getUpdateDesc(Class clazz) {
        return new UpdateObjectDescImpl(clazz);
    }

    public SQLStoreManager(String string) {
        this.setVendorType(string);
    }

    private void setVendorType(String string) {
        try {
            this.vendorType = new DBVendorType(string);
            if (logger.isLoggable()) {
                logger.fine("sqlstore.sqlstoremanager.vendortype", this.vendorType.getName());
            }
        }
        catch (Exception exception) {
            if (exception instanceof JDOException) {
                throw (JDOException)exception;
            }
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.getvendortypefailed"), exception);
        }
    }

    public DBVendorType getVendorType() {
        return this.vendorType;
    }

    public Collection retrieve(PersistenceManager persistenceManager, RetrieveDesc retrieveDesc) {
        return this.retrieve(persistenceManager, retrieveDesc, null);
    }

    public Collection retrieve(PersistenceManager persistenceManager, RetrieveDesc retrieveDesc, ValueFetcher valueFetcher) {
        Cloneable cloneable;
        if (retrieveDesc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.nullparam", "action"));
        }
        ClassDesc classDesc = this.validateAction(retrieveDesc);
        if (!(retrieveDesc instanceof RetrieveDescImpl)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", retrieveDesc.getClass().getName(), "RetrieveDescImpl"));
        }
        RetrieveDescImpl retrieveDescImpl = (RetrieveDescImpl)retrieveDesc;
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        SelectQueryPlan selectQueryPlan = null;
        int n = 2;
        Concurrency concurrency = classDesc.getConcurrency(persistenceManager.isOptimisticTransaction());
        selectQueryPlan = retrieveDescImpl.build(this, concurrency, n);
        arrayList2 = selectQueryPlan.getStatements();
        int n2 = 0;
        int n3 = arrayList2.size();
        while (n2 < n3) {
            cloneable = (SelectStatement)arrayList2.get(n2);
            arrayList = this.executeQuery(persistenceManager, (SelectStatement)cloneable, arrayList, concurrency, valueFetcher);
            ++n2;
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (arrayList.size() > 0 && selectQueryPlan.foreignPlans != null) {
            this.selectForeign(persistenceManager, selectQueryPlan, arrayList, concurrency);
        }
        if (retrieveDescImpl.hasDistinct() && (retrieveDescImpl.hasProjection() || (selectQueryPlan.options & 0x80) > 0 && !this.vendorType.isDistinctSupportedWithUpdateLock())) {
            cloneable = new HashSet();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!((HashSet)cloneable).contains(e)) {
                    ((HashSet)cloneable).add(e);
                    continue;
                }
                iterator.remove();
            }
        }
        return arrayList;
    }

    private ArrayList executeQuery(PersistenceManager persistenceManager, SelectStatement selectStatement, ArrayList arrayList, Concurrency concurrency, ValueFetcher valueFetcher) {
        ResultSet resultSet = null;
        DBStatement dBStatement = null;
        SelectQueryPlan selectQueryPlan = (SelectQueryPlan)selectStatement.getQueryPlan();
        Connection connection = null;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.executeQuery");
        }
        Transaction transaction = null;
        try {
            block16: {
                try {
                    String string;
                    if (concurrency != null) {
                        transaction = concurrency.suspend();
                    }
                    if (transaction == null) {
                        transaction = (Transaction)persistenceManager.currentTransaction();
                    }
                    connection = transaction.getConnection();
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    if ((string = selectStatement.getText()).length() > 0) {
                        Object object;
                        if (bl) {
                            if (logger.isLoggable(400)) {
                                logger.finer(SQLStoreManager.formatSqlText(string, selectStatement.inputDesc));
                            } else {
                                logger.fine(SQLStoreManager.formatSqlText(string, null));
                            }
                        }
                        dBStatement = new DBStatement(connection, string, transaction.getQueryTimeout());
                        int n = selectQueryPlan.getMaxRows();
                        if (n == 0) {
                            n = Integer.MAX_VALUE;
                        }
                        int n2 = 0;
                        int n3 = selectStatement.inputDesc.values.size();
                        while (n2 < n3) {
                            object = (InputValue)selectStatement.inputDesc.values.get(n2);
                            this.bindInputColumn(dBStatement, n2 + 1, (InputValue)object, ((InputValue)object).sqlType, valueFetcher);
                            ++n2;
                        }
                        if (fetchSize > -1) {
                            dBStatement.getPreparedStatement().setFetchSize(fetchSize);
                        }
                        this.vendorType.getSpecialDBOperation().defineColumnTypeForResult(dBStatement.getPreparedStatement(), selectStatement.getColumnRefs());
                        resultSet = dBStatement.executeQuery();
                        if (concurrency != null) {
                            concurrency.resume(transaction);
                        }
                        object = selectQueryPlan.getResultDesc();
                        ((ResultDesc)object).getResult(persistenceManager, arrayList, resultSet, n);
                    }
                    if (!bl) break block16;
                    logger.fine("sqlstore.sqlstoremanager.executeQuery.exit");
                }
                catch (SQLException sQLException) {
                    throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.persistencestore.jdbcerror"), sQLException);
                }
            }
            Object var18_18 = null;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            SQLStoreManager.close(resultSet);
            SQLStoreManager.close(dBStatement);
            SQLStoreManager.closeConnection(transaction, connection);
            throw throwable;
        }
        SQLStoreManager.close(resultSet);
        SQLStoreManager.close(dBStatement);
        SQLStoreManager.closeConnection(transaction, connection);
        return arrayList;
    }

    private void selectForeign(PersistenceManager persistenceManager, SelectQueryPlan selectQueryPlan, ArrayList arrayList, Concurrency concurrency) {
        if (selectQueryPlan.foreignPlans == null) {
            return;
        }
        ArrayList<SelectQueryPlan> arrayList2 = new ArrayList<SelectQueryPlan>();
        arrayList2.add(selectQueryPlan);
        int n = 0;
        int n2 = selectQueryPlan.foreignPlans.size();
        while (n < n2) {
            SelectQueryPlan selectQueryPlan2 = (SelectQueryPlan)selectQueryPlan.foreignPlans.get(n);
            arrayList2.add(selectQueryPlan2);
            this.selectForeign(persistenceManager, arrayList2, arrayList, concurrency);
            arrayList2.remove(arrayList2.size() - 1);
            ++n;
        }
    }

    private void selectForeign(PersistenceManager persistenceManager, ArrayList arrayList, ArrayList arrayList2, Concurrency concurrency) {
        SelectQueryPlan selectQueryPlan = (SelectQueryPlan)arrayList.get(arrayList.size() - 1);
        if ((selectQueryPlan.status & 4) == 0) {
            this.selectNonCorrelated(persistenceManager, arrayList, arrayList2, concurrency, selectQueryPlan);
        } else {
            if (selectQueryPlan.foreignPlans == null) {
                return;
            }
            int n = 0;
            int n2 = selectQueryPlan.foreignPlans.size();
            while (n < n2) {
                SelectQueryPlan selectQueryPlan2 = (SelectQueryPlan)selectQueryPlan.foreignPlans.get(n);
                arrayList.add(selectQueryPlan2);
                this.selectForeign(persistenceManager, arrayList, arrayList2, concurrency);
                arrayList.remove(arrayList.size() - 1);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectCollection(PersistenceManager persistenceManager, ArrayList arrayList, ArrayList arrayList2, Concurrency concurrency) {
        SelectQueryPlan selectQueryPlan;
        Object[] objectArray;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.selectcollection");
        }
        SelectQueryPlan selectQueryPlan2 = (SelectQueryPlan)arrayList.get(arrayList.size() - 2);
        SelectQueryPlan selectQueryPlan3 = (SelectQueryPlan)arrayList.get(arrayList.size() - 1);
        if (logger.isLoggable(300)) {
            objectArray = new Object[]{new Integer(arrayList.size()), new Integer(arrayList2.size())};
            logger.finest("sqlstore.sqlstoremanager.plans", objectArray);
        }
        objectArray = selectQueryPlan3.parentField;
        boolean bl2 = false;
        if ((selectQueryPlan3.status & 2) > 0) {
            bl2 = (selectQueryPlan3.status & 8) > 0;
        } else if (arrayList.size() == 2 && arrayList2.size() > 1) {
            selectQueryPlan = selectQueryPlan2;
            synchronized (selectQueryPlan) {
                bl2 = this.checkCorrelatedSelect(selectQueryPlan2, selectQueryPlan3, (ForeignFieldDesc)objectArray);
            }
        }
        if (!bl2) {
            this.selectNonCorrelated(persistenceManager, arrayList, arrayList2, concurrency, selectQueryPlan3);
        } else {
            selectQueryPlan = selectQueryPlan2;
            synchronized (selectQueryPlan) {
                this.selectCorrelated(persistenceManager, arrayList2, concurrency, selectQueryPlan2, selectQueryPlan3, (ForeignFieldDesc)objectArray);
            }
        }
        if (bl) {
            logger.fine("<-- SQLStoreManager.selectCollection()");
        }
    }

    private boolean checkCorrelatedSelect(SelectQueryPlan selectQueryPlan, SelectQueryPlan selectQueryPlan2, ForeignFieldDesc foreignFieldDesc) {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.checkcorrelatedselect");
        }
        boolean bl2 = false;
        selectQueryPlan.processOrderConstraints();
        if (logger.isLoggable(300)) {
            Object[] objectArray = new Object[]{new Boolean(selectQueryPlan.correlated), new Integer(foreignFieldDesc.localFields.size()), new Integer(selectQueryPlan.orderBy.size()), new Integer(selectQueryPlan.options)};
            logger.finest("sqlstore.sqlstoremanager.plancorrelated", objectArray);
        }
        if (!(selectQueryPlan.correlated || foreignFieldDesc.localFields.size() > selectQueryPlan.orderBy.size() || (selectQueryPlan.options & 1) != 0 || foreignFieldDesc.localFields.size() > 1 && (selectQueryPlan.options & 2) != 0)) {
            bl2 = true;
        }
        if (bl2) {
            int n = 0;
            int n2 = foreignFieldDesc.localFields.size();
            while (n < n2) {
                if (foreignFieldDesc.localFields.get(n) != ((ConstraintFieldDesc)selectQueryPlan.orderBy.get((int)n)).desc) {
                    bl2 = false;
                    break;
                }
                ++n;
            }
            if (bl2) {
                int n3;
                int n4;
                ArrayList arrayList = selectQueryPlan2.processOrderConstraints();
                if (arrayList.size() > 0) {
                    n4 = foreignFieldDesc.localFields.size();
                    if (n4 > arrayList.size()) {
                        n4 = arrayList.size();
                    }
                    n3 = 0;
                    while (n3 < n4) {
                        if (foreignFieldDesc.foreignFields.get(n3) != ((ConstraintFieldDesc)arrayList.get((int)n3)).desc) {
                            bl2 = false;
                            break;
                        }
                        ++n3;
                    }
                }
                if (bl2) {
                    if (foreignFieldDesc.foreignFields.size() > arrayList.size()) {
                        n4 = arrayList.size();
                        while (n4 < foreignFieldDesc.foreignFields.size()) {
                            selectQueryPlan2.constraint.addField((ConstraintFieldDesc)foreignFieldDesc.foreignFields.get(n4));
                            selectQueryPlan2.constraint.addOperation(30);
                            ++n4;
                        }
                        selectQueryPlan2.orderBy = null;
                    }
                } else {
                    bl2 = true;
                    n4 = 0;
                    n3 = foreignFieldDesc.foreignFields.size();
                    while (n4 < n3) {
                        LocalFieldDesc localFieldDesc = (LocalFieldDesc)foreignFieldDesc.foreignFields.get(n4);
                        int n5 = 0;
                        int n6 = arrayList.size();
                        while (n5 < n6) {
                            ConstraintFieldDesc constraintFieldDesc = (ConstraintFieldDesc)arrayList.get(n5);
                            if (localFieldDesc == constraintFieldDesc.desc) {
                                bl2 = false;
                                break;
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    if (bl2) {
                        int n7 = foreignFieldDesc.foreignFields.size() - 1;
                        while (n7 >= 0) {
                            selectQueryPlan2.constraint.stack.add(0, new ConstraintOperation(30));
                            selectQueryPlan2.constraint.stack.add(0, new ConstraintFieldDesc((LocalFieldDesc)foreignFieldDesc.foreignFields.get(n7)));
                            --n7;
                        }
                        selectQueryPlan2.orderBy = null;
                    }
                }
            }
        }
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.checkcorrelatedselect.exit");
        }
        return bl2;
    }

    private void selectNonCorrelated(PersistenceManager persistenceManager, ArrayList arrayList, ArrayList arrayList2, Concurrency concurrency, SelectQueryPlan selectQueryPlan) {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.selectnoncorrelated");
        }
        ArrayList arrayList3 = new ArrayList();
        int n = 0;
        int n2 = arrayList2.size();
        while (n < n2) {
            Object object;
            Object object2 = arrayList2.get(n);
            SQLStateManager sQLStateManager = (SQLStateManager)persistenceManager.getStateManager(object2);
            int n3 = 1;
            int n4 = arrayList.size() - 1;
            while (n3 < n4) {
                object = (SelectQueryPlan)arrayList.get(n3);
                Class<?> clazz = ((SelectQueryPlan)object).parentField.getClass();
                if (object2 != null && clazz.equals(object2.getClass())) {
                    object2 = ((SelectQueryPlan)object).parentField.getValue(sQLStateManager);
                    sQLStateManager = (SQLStateManager)persistenceManager.getStateManager(object2);
                }
                ++n3;
            }
            object = null;
            if (object2 != null) {
                int n5;
                int n6;
                Object object3;
                int n7 = 0;
                int n8 = selectQueryPlan.statements.size();
                while (n7 < n8) {
                    object3 = (Statement)selectQueryPlan.statements.get(n7);
                    ((Statement)object3).getText();
                    n6 = 0;
                    n5 = ((Statement)object3).inputDesc.values.size();
                    while (n6 < n5) {
                        InputValue inputValue = (InputValue)((Statement)object3).inputDesc.values.get(n6);
                        if (inputValue.field != null) {
                            inputValue.value = inputValue.field.getValue(sQLStateManager);
                        }
                        ++n6;
                    }
                    if (((ArrayList)(object = this.executeQuery(persistenceManager, (SelectStatement)object3, (ArrayList)object, concurrency, null))).size() > 0 && selectQueryPlan.foreignPlans != null) {
                        this.selectForeign(persistenceManager, selectQueryPlan, (ArrayList)object, concurrency);
                    }
                    ++n7;
                }
                if (((ArrayList)object).size() > selectQueryPlan.parentField.cardinalityUPB) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.persistencestore.toomanyrows", object2.getClass().getName(), selectQueryPlan.parentField.getName(), "" + selectQueryPlan.parentField.cardinalityUPB));
                }
                if (((ArrayList)object).size() < selectQueryPlan.parentField.cardinalityLWB) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.persistencestore.toofewrows", object2.getClass().getName(), selectQueryPlan.parentField.getName(), "" + selectQueryPlan.parentField.cardinalityLWB));
                }
                if (selectQueryPlan.getResultDesc().isProjection()) {
                    arrayList3.addAll(object);
                } else if (!sQLStateManager.getPresenceMaskBit(selectQueryPlan.parentField.absoluteID)) {
                    if (selectQueryPlan.parentField.getType().isArray()) {
                        object3 = Array.newInstance(selectQueryPlan.parentField.getType().getComponentType(), ((ArrayList)object).size());
                        n6 = 0;
                        n5 = ((ArrayList)object).size();
                        while (n6 < n5) {
                            Array.set(object3, n6, ((ArrayList)object).get(n6));
                            ++n6;
                        }
                        selectQueryPlan.parentField.setValue(sQLStateManager, object3);
                    } else if (selectQueryPlan.parentField.getComponentType() != null) {
                        sQLStateManager.replaceCollection(selectQueryPlan.parentField, (Collection)object);
                    } else if (((ArrayList)object).size() == 1) {
                        object3 = selectQueryPlan.parentField.convertValue(((ArrayList)object).get(0), sQLStateManager);
                        selectQueryPlan.parentField.setValue(sQLStateManager, object3);
                    } else {
                        selectQueryPlan.parentField.setValue(sQLStateManager, null);
                    }
                    sQLStateManager.setPresenceMaskBit(selectQueryPlan.parentField.absoluteID);
                }
            }
            ++n;
        }
        if (selectQueryPlan.getResultDesc().isProjection()) {
            arrayList2.clear();
            arrayList2.addAll(arrayList3);
        }
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.selectnoncorrelated.exit");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void selectCorrelated(PersistenceManager var1_1, ArrayList var2_2, Concurrency var3_3, SelectQueryPlan var4_4, SelectQueryPlan var5_5, ForeignFieldDesc var6_6) {
        block37: {
            block36: {
                var10_7 = (SelectStatement)var4_4.statements.get(0);
                var11_8 = (SelectStatement)var5_5.statements.get(0);
                var12_9 = new StringBuffer();
                var13_10 = (SqlIDDesc)var4_4.config.persistenceIDDesc;
                var14_11 = (SqlIDDesc)var5_5.config.persistenceIDDesc;
                var15_12 = var13_10.getFields();
                var16_13 = var14_11.getFields();
                var17_14 = var2_2.get(var2_2.size() - 1);
                var18_15 = (SQLStateManager)var1_1.getStateManager(var17_14);
                var19_16 = SQLStoreManager.logger.isLoggable();
                if (var19_16) {
                    SQLStoreManager.logger.fine("sqlstore.sqlstoremanager.selectcorrelated");
                }
                var5_5.correlated = true;
                if ((var5_5.status & 2) == 0) break block36;
                var20_17 = null;
                var20_17 = ((ConstraintFieldDesc)var4_4.orderBy.get((int)0)).desc;
                var11_8.inputDesc.values.set(var11_8.inputDesc.values.size() - 1, new InputValue(null, var20_17.getValue(var18_15)));
                break block37;
            }
            var20_18 = 0;
            var21_20 = var6_6.foreignFields.size();
            while (var20_18 < var21_20) {
                var22_22 = (LocalFieldDesc)var6_6.foreignFields.get(var20_18);
                var5_5.addColumn((LocalFieldDesc)var22_22, true);
                ++var20_18;
            }
            var5_5.status |= 8;
            var5_5.status |= 2;
            var10_7 = (SelectStatement)var10_7.clone();
            var22_22 = new InputDesc();
            var23_24 = 0;
            var24_25 = var10_7.inputDesc.values.size();
            while (var23_24 < var24_25) {
                var25_27 = var10_7.inputDesc.values.get(var23_24);
                var22_22.values.add(var25_27);
                ++var23_24;
            }
            var10_7.inputDesc = var22_22;
            var10_7.plan.options &= -129;
            var10_7.plan.setResultDesc(new ResultDesc());
            var25_27 = new Constraint();
            var26_28 = (ConstraintFieldDesc)var4_4.orderBy.get(0);
            var27_29 = var26_28.desc;
            var28_33 = var26_28.ordering;
            var29_36 = 15;
            if (var28_33 < 0) {
                var29_36 = 12;
            }
            var25_27.addValue(var27_29.getValue(var18_15));
            var25_27.addField(var27_29);
            var25_27.addOperation(var29_36);
            var10_7.inputDesc.values.add(new InputValue(null, var27_29.getValue(var18_15)));
            var30_37 = 0;
            var31_38 = var10_7.constraint.stack.size();
            while (var30_37 < var31_38) {
                var32_39 = (ConstraintNode)var10_7.constraint.stack.get(var30_37);
                if (!(var32_39 instanceof ConstraintOperation)) ** GOTO lbl-1000
                var33_42 = (ConstraintOperation)var32_39;
                if (var33_42.operation == 30 || var33_42.operation == 31) {
                    var25_27.stack.remove(var25_27.stack.size() - 1);
                } else lbl-1000:
                // 2 sources

                {
                    var25_27.stack.add(var32_39);
                }
                ++var30_37;
            }
            var10_7.constraint = var25_27;
            var11_8.clear(false);
            var32_40 = 0;
            var33_43 = var10_7.inputDesc.values.size();
            while (var32_40 < var33_43) {
                var11_8.inputDesc.values.add(var10_7.inputDesc.values.get(var32_40));
                ++var32_40;
            }
            var10_7.clear(true);
            var11_8.constraint.addValue(var12_9);
            var34_44 = 0;
            var35_45 = var6_6.foreignFields.size();
            while (var34_44 < var35_45) {
                var10_7.addColumn((LocalFieldDesc)var6_6.localFields.get(var34_44));
                var11_8.constraint.addField((LocalFieldDesc)var6_6.foreignFields.get(var34_44));
                ++var34_44;
            }
            var11_8.constraint.addOperation(14);
            var12_9.append(var10_7.getText());
            var5_5.useInstanceKey = true;
            if (var15_12.size() != var6_6.localFields.size()) {
                var5_5.useInstanceKey = false;
            } else {
                var36_46 = 0;
                var37_47 = var6_6.localFields.size();
                while (var36_46 < var37_47) {
                    if (var6_6.localFields.get(0) != var15_12.get(var36_46)) {
                        var5_5.useInstanceKey = false;
                        break;
                    }
                    ++var36_46;
                }
            }
            var5_5.useDependentKey = true;
            if (var16_13.size() < var15_12.size()) {
                var5_5.useDependentKey = false;
            } else {
                var36_46 = 0;
                var37_47 = var6_6.foreignFields.size();
                while (var36_46 < var37_47) {
                    if (var6_6.foreignFields.get(var36_46) != var16_13.get(var36_46)) {
                        var5_5.useDependentKey = false;
                        break;
                    }
                    ++var36_46;
                }
            }
        }
        var20_19 = null;
        if (!var5_5.useInstanceKey) {
            var20_19 = new SqlID();
        }
        var21_21 = null;
        if (!var5_5.useDependentKey) {
            var21_21 = new SqlID();
        }
        if (SQLStoreManager.logger.isLoggable(400)) {
            var22_22 = new Object[]{new Boolean(var5_5.useInstanceKey), new Boolean(var5_5.useDependentKey)};
            SQLStoreManager.logger.finer("sqlstore.sqlstoremanager.categorization", var22_22);
        }
        if ((var7_48 = this.executeQuery(var1_1, var11_8, null, var3_3, null)).size() > 0 && var5_5.foreignPlans != null) {
            this.selectForeign(var1_1, var5_5, var7_48, var3_3);
        }
        var8_49 = 0;
        var22_23 = 0;
        var23_24 = var2_2.size();
        while (var22_23 < var23_24) {
            var24_26 = var2_2.get(var22_23);
            var25_27 = (SQLStateManager)var1_1.getStateManager(var24_26);
            var26_28 = new ArrayList<E>();
            if (var5_5.useInstanceKey) {
                var20_19 = (SqlID)var13_10.createID((StateManager)var25_27);
            } else {
                var27_30 = var20_19.values.size();
                while (var27_30 < var6_6.localFields.size()) {
                    var20_19.values.add(null);
                    ++var27_30;
                }
                var28_33 = 0;
                var29_36 = var6_6.localFields.size();
                while (var28_33 < var29_36) {
                    var20_19.values.set(var28_33, ((LocalFieldDesc)var6_6.localFields.get(var28_33)).getValue((StateManager)var25_27));
                    ++var28_33;
                }
            }
            var25_27.setPresenceMaskBit(var5_5.parentField.absoluteID);
            while (var8_49 < var7_48.size()) {
                var27_31 = var7_48.get(var8_49);
                var28_34 = (SQLStateManager)var1_1.getStateManager(var27_31);
                if (var5_5.useDependentKey) {
                    var21_21 = (SqlID)var14_11.createID(var28_34);
                } else {
                    var29_36 = var21_21.values.size();
                    while (var29_36 < var6_6.foreignFields.size()) {
                        var21_21.values.add(null);
                        ++var29_36;
                    }
                    var30_37 = 0;
                    var31_38 = var6_6.foreignFields.size();
                    while (var30_37 < var31_38) {
                        var32_41 = (FieldDesc)var6_6.foreignFields.get(var30_37);
                        var21_21.values.set(var30_37, var32_41.getValue(var28_34));
                        ++var30_37;
                    }
                }
                var29_36 = var20_19.compareID(var21_21);
                if (var29_36 != 0 && var29_36 != 1024) break;
                var26_28.add(var27_31);
                ++var8_49;
            }
            if (var6_6.getType().isArray()) {
                var27_32 = Array.newInstance(var6_6.getType().getComponentType(), var26_28.size());
                var28_35 = 0;
                var29_36 = var26_28.size();
                while (var28_35 < var29_36) {
                    Array.set(var27_32, var28_35, var26_28.get(var28_35));
                    ++var28_35;
                }
                var6_6.setValue((StateManager)var25_27, var27_32);
            } else if (var6_6.getComponentType() != null) {
                var25_27.replaceCollection(var6_6, (Collection)var26_28);
            }
            ++var22_23;
        }
        if (var19_16) {
            SQLStoreManager.logger.fine("sqlstore.sqlstoremanager.selectcorrelated.exit");
        }
    }

    private ClassDesc validateAction(ActionDesc actionDesc) {
        if (actionDesc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.nullparam", "action"));
        }
        ClassDesc classDesc = null;
        classDesc = (ClassDesc)this.getPersistenceConfig(actionDesc.getPersistenceCapableClass());
        if (classDesc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.illegalparam", "action.pcClass", actionDesc.getPersistenceCapableClass().toString()));
        }
        return classDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeBatch(PersistenceManager persistenceManager, UpdateDesc updateDesc, boolean bl) {
        Connection connection;
        Transaction transaction;
        block5: {
            boolean bl2 = true;
            UpdateQueryPlan updateQueryPlan = null;
            transaction = null;
            connection = null;
            UpdateObjectDescImpl updateObjectDescImpl = null;
            if (!(updateDesc instanceof UpdateObjectDescImpl)) throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", updateDesc.getClass().getName(), "UpdateObjectDescImpl"));
            updateObjectDescImpl = (UpdateObjectDescImpl)updateDesc;
            ClassDesc classDesc = this.validateAction(updateDesc);
            updateQueryPlan = classDesc.getUpdateQueryPlan(updateObjectDescImpl, this);
            try {
                transaction = (Transaction)persistenceManager.currentTransaction();
                connection = transaction.getConnection();
                boolean bl3 = bl || updateQueryPlan.checkBatchThreshold(transaction);
                int n = 0;
                int n2 = updateQueryPlan.statements.size();
                while (true) {
                    if (n >= n2) {
                        bl2 = bl;
                        Object var15_14 = null;
                        if (!bl2) break block5;
                        break;
                    }
                    UpdateStatement updateStatement = (UpdateStatement)updateQueryPlan.statements.get(n);
                    this.executeUpdateBatch(transaction, connection, updateStatement, updateObjectDescImpl, bl3);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (bl2) {
                    SQLStoreManager.closeDBStatements(updateQueryPlan, transaction);
                }
                SQLStoreManager.closeConnection(transaction, connection);
                throw throwable;
            }
            SQLStoreManager.closeDBStatements(updateQueryPlan, transaction);
        }
        SQLStoreManager.closeConnection(transaction, connection);
    }

    private void executeUpdateBatch(Transaction transaction, Connection connection, UpdateStatement updateStatement, UpdateObjectDescImpl updateObjectDescImpl, boolean bl) {
        int[] nArray = null;
        DBStatement dBStatement = null;
        if (logger.isLoggable(500)) {
            logger.fine("sqlstore.sqlstoremanager.executeupdatebatch");
        }
        try {
            dBStatement = updateStatement.getDBStatement(transaction, connection);
            String string = dBStatement.getStatementText();
            if (string.length() > 0) {
                if (logger.isLoggable(500)) {
                    logger.fine(SQLStoreManager.formatSqlText(string, null));
                }
                Iterator iterator = updateStatement.getColumnRefs().iterator();
                while (iterator.hasNext()) {
                    this.bindInputColumn(dBStatement, (ColumnRef)iterator.next(), updateObjectDescImpl, true);
                }
                Iterator iterator2 = updateStatement.getColumnRefsForWhereClause().iterator();
                while (iterator2.hasNext()) {
                    this.bindInputColumn(dBStatement, (ColumnRef)iterator2.next(), updateObjectDescImpl, !updateObjectDescImpl.isBeforeImageRequired());
                }
                dBStatement.addBatch();
                if (bl) {
                    nArray = dBStatement.executeBatch();
                    int n = 0;
                    while (n < nArray.length) {
                        if (nArray[n] < updateStatement.minAffectedRows && nArray[n] != -2) {
                            this.rollbackXact(transaction);
                            int n2 = string.indexOf(32);
                            throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.store.operationfailed", string.substring(0, n2)));
                        }
                        ++n;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            this.rollbackXact(transaction);
            throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.persistencestore.jdbcerror"), sQLException);
        }
        if (logger.isLoggable(500)) {
            logger.fine("sqlstore.sqlstoremanager.executeupdatebatch.exit", '[' + StringHelper.intArrayToSeparatedList(nArray, ",") + ']');
        }
    }

    public static String formatSqlText(String string, InputDesc inputDesc) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SQL statement<").append(string).append(">");
        if (inputDesc != null) {
            if (inputDesc.values.size() <= 0) {
                stringBuffer.append(" with no input values");
            } else {
                stringBuffer.append(" with input values: ");
                int n = 0;
                int n2 = inputDesc.values.size();
                while (n < n2) {
                    InputValue inputValue = (InputValue)inputDesc.values.get(n);
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    if (inputValue.value == null) {
                        stringBuffer.append("<null>");
                    } else {
                        stringBuffer.append(inputValue.getClass().getName());
                        stringBuffer.append(":");
                        stringBuffer.append(inputValue.value.toString());
                    }
                    ++n;
                }
            }
        }
        return stringBuffer.toString();
    }

    private static void close(ResultSet resultSet) {
        block2: {
            if (resultSet == null) break block2;
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                logger.finest(I18NHelper.getMessage(messages, "sqlstore.sqlstoremanager.errorcloseresultset", sQLException.getLocalizedMessage()));
            }
        }
    }

    private static void close(DBStatement dBStatement) {
        block2: {
            if (dBStatement == null) break block2;
            try {
                dBStatement.close();
            }
            catch (SQLException sQLException) {
                logger.finest(I18NHelper.getMessage(messages, "sqlstore.sqlstoremanager.errorclosestatement", sQLException.getLocalizedMessage()));
            }
        }
    }

    private static void closeConnection(Transaction transaction, Connection connection) {
        if (transaction != null && connection != null) {
            transaction.releaseConnection();
        }
    }

    private static void closeDBStatements(UpdateQueryPlan updateQueryPlan, Transaction transaction) {
        if (updateQueryPlan != null && transaction != null) {
            Iterator iterator = updateQueryPlan.getStatements().iterator();
            while (iterator.hasNext()) {
                UpdateStatement updateStatement = (UpdateStatement)iterator.next();
                DBStatement dBStatement = updateStatement.removeDBStatement(transaction);
                SQLStoreManager.close(dBStatement);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

