/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.meta;

import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataUserException;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class JDOMetaDataProperties {
    private static final char FIELD_DELIMITER = '#';
    private static final String PROPERTY_DELIMITERS = " \t,;";
    private static final char PROPERTY_ASSIGNER = ':';
    private static final String PROPERTY_ACCESS_MODIFIER = "access";
    private static final String PROPERTY_JDO_MODIFIER = "jdo";
    private static final String PROPERTY_SUPER_CLASSNAME = "super";
    private static final String PROPERTY_OID_CLASSNAME = "oid";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_ANNOTATION_TYPE = "annotation";
    private static final String ACCESS_PRIVATE = "private";
    private static final String ACCESS_PACKAGE_LOCAL = "package";
    private static final String ACCESS_PROTECTED = "protected";
    private static final String ACCESS_PUBLIC = "public";
    private static final String JDO_TRANSIENT = "transient";
    private static final String JDO_PERSISTENT = "persistent";
    private static final String JDO_TRANSACTIONAL = "transactional";
    private static final String ANNOTATION_TYPE_PK = "pk";
    private static final String ANNOTATION_TYPE_DFG = "dfg";
    private static final String ANNOTATION_TYPE_MEDIATED = "mediated";
    private Properties properties;
    private final Map cachedJDOClasses = new HashMap();
    private static final JDOClass NULL = new JDOClass(null);
    private final List tmpTokens = new ArrayList();

    public JDOMetaDataProperties(Properties properties) {
        this.properties = properties;
    }

    public final JDOClass getJDOClass(String string) throws JDOMetaDataUserException {
        JDOClass jDOClass = (JDOClass)this.cachedJDOClasses.get(string = JDOMetaDataProperties.toCanonicalClassName(string));
        if (jDOClass == NULL) {
            return null;
        }
        if (jDOClass != null) {
            return jDOClass;
        }
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            this.cachedJDOClasses.put(string, NULL);
            return null;
        }
        jDOClass = this.parseJDOClass(string, string2);
        this.parseJDOFields(jDOClass);
        this.validateDependencies(jDOClass);
        this.cachedJDOClasses.put(jDOClass.getName(), jDOClass);
        return jDOClass;
    }

    public final JDOField getJDOField(String string, String string2) throws JDOMetaDataUserException {
        JDOClass jDOClass = this.getJDOClass(string2);
        return jDOClass != null ? jDOClass.getField(string) : null;
    }

    public final String[] getKnownClassNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf(35) >= 0) continue;
            hashSet.add(JDOMetaDataProperties.fromCanonicalClassName(string));
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private static final String toCanonicalClassName(String string) {
        return string.replace('/', '.');
    }

    private static final String fromCanonicalClassName(String string) {
        return string.replace('.', '/');
    }

    private final JDOClass parseJDOClass(String string, String string2) throws JDOMetaDataUserException {
        Object object;
        List list = this.parseProperties(string2);
        int n = 0;
        while (n < list.size()) {
            object = (Property)list.get(n);
            JDOMetaDataProperties.validateClassProperty((Property)object, string);
            ++n;
        }
        JDOMetaDataProperties.checkForDuplicateProperties(list, string);
        object = new JDOClass(string);
        int n2 = 0;
        while (n2 < list.size()) {
            Property property = (Property)list.get(n2);
            if (property.name.equals(PROPERTY_ACCESS_MODIFIER)) {
                ((JDOClass)object).modifiers = JDOMetaDataProperties.getModifiers(property.value);
            } else if (property.name.equals(PROPERTY_JDO_MODIFIER)) {
                ((JDOClass)object).isPersistent = property.value.equals(JDO_PERSISTENT);
            } else if (property.name.equals(PROPERTY_SUPER_CLASSNAME)) {
                ((JDOClass)object).setSuperClassName(property.value);
            } else if (property.name.equals(PROPERTY_OID_CLASSNAME)) {
                ((JDOClass)object).setOidClassName(property.value);
            }
            ++n2;
        }
        return object;
    }

    private static final void validateClassProperty(Property property, String string) throws JDOMetaDataUserException {
        String string2 = property.value;
        if (property.name == null) {
            property.name = string2.equals(ACCESS_PUBLIC) || string2.equals(ACCESS_PROTECTED) || string2.equals(ACCESS_PACKAGE_LOCAL) || string2.equals(ACCESS_PRIVATE) ? PROPERTY_ACCESS_MODIFIER : (string2.equals(JDO_PERSISTENT) || string2.equals(JDO_TRANSIENT) ? PROPERTY_JDO_MODIFIER : PROPERTY_SUPER_CLASSNAME);
        } else {
            String string3 = property.name;
            JDOMetaDataProperties.checkPropertyName(property.name, new String[]{PROPERTY_OID_CLASSNAME, PROPERTY_ACCESS_MODIFIER, PROPERTY_JDO_MODIFIER, PROPERTY_SUPER_CLASSNAME}, string);
            JDOMetaDataProperties.checkPropertyValue(property, new String[]{ACCESS_PUBLIC, ACCESS_PROTECTED, ACCESS_PACKAGE_LOCAL, ACCESS_PRIVATE}, PROPERTY_ACCESS_MODIFIER, string);
            JDOMetaDataProperties.checkPropertyValue(property, new String[]{JDO_TRANSIENT, JDO_PERSISTENT}, PROPERTY_JDO_MODIFIER, string);
        }
    }

    private final void parseJDOFields(JDOClass jDOClass) throws JDOMetaDataUserException {
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(jDOClass.getName() + '#')) continue;
            String string2 = string.substring(string.indexOf(35) + 1, string.length());
            JDOMetaDataProperties.validateFieldName(string2, jDOClass.getName());
            jDOClass.addField(this.parseJDOField(this.properties.getProperty(string), string2, jDOClass));
        }
        jDOClass.sortFields();
    }

    private final JDOField parseJDOField(String string, String string2, JDOClass jDOClass) throws JDOMetaDataUserException {
        Object object;
        List list = this.parseProperties(string);
        int n = 0;
        while (n < list.size()) {
            object = (Property)list.get(n);
            this.validateFieldProperty((Property)object, string2, jDOClass.getName());
            ++n;
        }
        JDOMetaDataProperties.checkForDuplicateProperties(list, jDOClass.getName() + '#' + string2);
        object = new JDOField(string2);
        int n2 = 0;
        while (n2 < list.size()) {
            Property property = (Property)list.get(n2);
            if (property.name.equals(PROPERTY_ACCESS_MODIFIER)) {
                ((JDOField)object).modifiers = JDOMetaDataProperties.getModifiers(property.value);
            } else if (property.name.equals(PROPERTY_JDO_MODIFIER)) {
                ((JDOField)object).jdoModifier = property.value;
            } else if (property.name.equals(PROPERTY_TYPE)) {
                ((JDOField)object).setType(property.value);
            } else if (property.name.equals(PROPERTY_ANNOTATION_TYPE)) {
                ((JDOField)object).annotationType = property.value;
            }
            ++n2;
        }
        return object;
    }

    private final void validateFieldProperty(Property property, String string, String string2) throws JDOMetaDataUserException {
        String string3 = property.value;
        if (property.name == null) {
            property.name = string3.equals(ACCESS_PUBLIC) || string3.equals(ACCESS_PROTECTED) || string3.equals(ACCESS_PACKAGE_LOCAL) || string3.equals(ACCESS_PRIVATE) ? PROPERTY_ACCESS_MODIFIER : (string3.equals(JDO_PERSISTENT) || string3.equals(JDO_TRANSIENT) || string3.equals(JDO_TRANSACTIONAL) ? PROPERTY_JDO_MODIFIER : (string3.equals(ANNOTATION_TYPE_PK) || string3.equals(ANNOTATION_TYPE_DFG) || string3.equals(ANNOTATION_TYPE_MEDIATED) ? PROPERTY_ANNOTATION_TYPE : PROPERTY_TYPE));
        } else {
            String string4 = string2 + '#' + string;
            JDOMetaDataProperties.checkPropertyName(property.name, new String[]{PROPERTY_ACCESS_MODIFIER, PROPERTY_JDO_MODIFIER, PROPERTY_TYPE, PROPERTY_ANNOTATION_TYPE}, string4);
            JDOMetaDataProperties.checkPropertyValue(property, new String[]{ACCESS_PUBLIC, ACCESS_PROTECTED, ACCESS_PACKAGE_LOCAL, ACCESS_PRIVATE}, PROPERTY_ACCESS_MODIFIER, string4);
            JDOMetaDataProperties.checkPropertyValue(property, new String[]{JDO_PERSISTENT, JDO_TRANSIENT, JDO_TRANSACTIONAL}, PROPERTY_JDO_MODIFIER, string4);
            JDOMetaDataProperties.checkPropertyValue(property, new String[]{ANNOTATION_TYPE_PK, ANNOTATION_TYPE_DFG, ANNOTATION_TYPE_MEDIATED}, PROPERTY_ANNOTATION_TYPE, string4);
        }
    }

    private final void validateDependencies(JDOClass jDOClass) throws JDOMetaDataUserException {
        int n = jDOClass.fields.size() - 1;
        while (n >= 0) {
            JDOField jDOField = (JDOField)jDOClass.fields.get(n);
            if (jDOField.jdoModifier == null) {
                jDOField.jdoModifier = jDOClass.isPersistent() ? JDO_PERSISTENT : JDO_TRANSIENT;
            } else if (jDOClass.isTransient()) {
                if (jDOField.isPersistent()) {
                    throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: A non-persistent class cannot have a persistent field (class ''{0}'' with field ''{1})''.", new String[]{jDOClass.getName(), jDOField.getName()}));
                }
                if (jDOField.isTransactional()) {
                    throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: A non-persistent class cannot have a transactional field (class ''{0}'' with field ''{1})''.", new String[]{jDOClass.getName(), jDOField.getName()}));
                }
            }
            if (jDOField.isAnnotated() && jDOClass.isTransient()) {
                throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: A non-persistent class cannot have an annotated field (''{1}'' of class ''{0}'') can''t have a fetch group.", new String[]{jDOClass.getName(), jDOField.getName()}));
            }
            if (!jDOField.isPersistent() && jDOField.isAnnotated()) {
                jDOField.annotationType = ANNOTATION_TYPE_MEDIATED;
            }
            if (!jDOField.isAnnotated() && jDOClass.isPersistent()) {
                jDOField.annotationType = ANNOTATION_TYPE_MEDIATED;
            }
            --n;
        }
    }

    private static final void validateFieldName(String string, String string2) throws JDOMetaDataUserException {
        if (string.length() == 0) {
            throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: The class ''{0}'' may not have an empty fieldname.", new String[]{string2}));
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: The field name ''{1}'' of class ''{0}'' is not valid.", new String[]{string2, string}));
        }
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (!Character.isJavaIdentifierPart(c)) {
                throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: The field name ''{1}'' of class ''{0}'' is not valid.", new String[]{string2, string}));
            }
            --n;
        }
    }

    private static final void checkForDuplicateProperties(List list, String string) throws JDOMetaDataUserException {
        int n = 0;
        while (n < list.size()) {
            int n2 = n + 1;
            while (n2 < list.size()) {
                Property property = (Property)list.get(n);
                Property property2 = (Property)list.get(n2);
                if (property.name.equals(property2.name) && !property.value.equals(property2.value)) {
                    throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: The property ''{1}'' for the entry ''{0}'' entered twice with values: ''{2}'' and ''{3}''.", new String[]{string, property.name, property.value, property2.value}));
                }
                ++n2;
            }
            ++n;
        }
    }

    private static final void checkPropertyName(String string, String[] stringArray, String string2) throws JDOMetaDataUserException {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return;
            }
            ++n;
        }
        throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: Invalid property name for entry ''{0}'': ''{1}''.", new String[]{string2, string}));
    }

    private static final void checkPropertyValue(Property property, String[] stringArray, String string, String string2) throws JDOMetaDataUserException {
        if (!property.name.equals(string)) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (property.value.equals(stringArray[n])) {
                return;
            }
            ++n;
        }
        throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: Invalid value for property ''{1}'' of entry ''{0}'': ''{2}''.", new String[]{string2, string, property.value}));
    }

    static final String getErrorMsg(String string, String[] stringArray) {
        return MessageFormat.format(string, stringArray);
    }

    final List parseProperties(String string) throws JDOMetaDataUserException {
        this.tmpTokens.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, PROPERTY_DELIMITERS);
        while (stringTokenizer.hasMoreTokens()) {
            this.tmpTokens.add(this.parseProperty(stringTokenizer.nextToken()));
        }
        return this.tmpTokens;
    }

    private final Property parseProperty(String string) throws JDOMetaDataUserException {
        Property property = new Property();
        int n = string.indexOf(58);
        if (n < 0) {
            property.value = string;
        } else {
            property.name = string.substring(0, n);
            property.value = string.substring(n + 1, string.length());
            if (property.name.length() == 0 || property.value.length() == 0) {
                throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: The property name and value may not be empty if a '':'' is specified: ''{0}''.", new String[]{string}));
            }
        }
        return property;
    }

    private static final int getModifiers(String string) {
        if (string.equals(ACCESS_PUBLIC)) {
            return 1;
        }
        if (string.equals(ACCESS_PRIVATE)) {
            return 2;
        }
        if (string.equals(ACCESS_PROTECTED)) {
            return 4;
        }
        return 0;
    }

    static final class JDOField {
        private String name;
        private String type = null;
        private int modifiers = 2;
        private String jdoModifier = null;
        private String annotationType = null;

        JDOField(String string) {
            this.name = string;
        }

        public final String getName() {
            return this.name;
        }

        public final void setType(String string) {
            this.type = JDOMetaDataProperties.fromCanonicalClassName(string);
        }

        public final String getType() {
            return this.type;
        }

        public final int getModifiers() {
            return this.modifiers;
        }

        public final boolean isAnnotated() {
            return this.annotationType != null;
        }

        public final boolean isPk() {
            return this.annotationType != null && this.annotationType.equals(JDOMetaDataProperties.ANNOTATION_TYPE_PK);
        }

        public final boolean isInDefaultFetchGroup() {
            return this.annotationType != null && this.annotationType.equals(JDOMetaDataProperties.ANNOTATION_TYPE_DFG);
        }

        public boolean isKnownTransient() {
            return this.jdoModifier != null && this.jdoModifier.equals(JDOMetaDataProperties.JDO_TRANSIENT);
        }

        public final boolean isPersistent() {
            return this.jdoModifier != null && this.jdoModifier.equals(JDOMetaDataProperties.JDO_PERSISTENT);
        }

        public final boolean isTransactional() {
            return this.jdoModifier != null && this.jdoModifier.equals(JDOMetaDataProperties.JDO_TRANSACTIONAL);
        }

        public final boolean isManaged() {
            return this.isPersistent() || this.isTransactional();
        }

        public final String toString() {
            return "<name:" + this.name + ',' + JDOMetaDataProperties.PROPERTY_TYPE + ':' + this.type + ',' + JDOMetaDataProperties.PROPERTY_ACCESS_MODIFIER + ':' + Modifier.toString(this.modifiers) + ',' + JDOMetaDataProperties.PROPERTY_JDO_MODIFIER + ':' + this.jdoModifier + ',' + JDOMetaDataProperties.PROPERTY_ANNOTATION_TYPE + ':' + this.annotationType + '>';
        }
    }

    static final class JDOClass {
        private String name;
        private String superClassName = null;
        private String oidClassName = null;
        private int modifiers = 1;
        private boolean isPersistent = true;
        private final List fields = new ArrayList();
        private String[] managedFieldNames = null;
        private String[] fieldNames = null;

        JDOClass(String string) {
            this.name = string;
        }

        public final String getName() {
            return this.name;
        }

        public final int getModifiers() {
            return this.modifiers;
        }

        private final void setSuperClassName(String string) {
            this.superClassName = JDOMetaDataProperties.fromCanonicalClassName(string);
        }

        public final String getSuperClassName() {
            return this.superClassName;
        }

        public void setOidClassName(String string) {
            this.oidClassName = JDOMetaDataProperties.fromCanonicalClassName(string);
        }

        public String getOidClassName() {
            return this.oidClassName;
        }

        public final boolean isPersistent() {
            return this.isPersistent;
        }

        public final boolean isTransient() {
            return !this.isPersistent();
        }

        private final void addField(JDOField jDOField) {
            this.fields.add(jDOField);
        }

        public final JDOField getField(String string) {
            int n = this.getIndexOfField(string);
            return n > -1 ? (JDOField)this.fields.get(n) : null;
        }

        public final int getIndexOfField(String string) {
            int n = 0;
            while (n < this.fields.size()) {
                JDOField jDOField = (JDOField)this.fields.get(n);
                if (jDOField.getName().equals(string)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public final String[] getFields() {
            if (this.fieldNames == null) {
                int n = this.fields.size();
                String[] stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = ((JDOField)this.fields.get(n2)).getName();
                    ++n2;
                }
                this.fieldNames = stringArray;
            }
            return this.fieldNames;
        }

        private final void sortFields() {
            Collections.sort(this.fields, new Comparator(){

                public final int compare(Object object, Object object2) {
                    JDOField jDOField = (JDOField)object;
                    JDOField jDOField2 = (JDOField)object2;
                    if (!jDOField.isManaged() || !jDOField2.isManaged()) {
                        return jDOField.isManaged() ? -1 : 1;
                    }
                    return jDOField.getName().compareTo(jDOField2.getName());
                }
            });
        }

        public final String[] getManagedFieldNames() {
            if (this.managedFieldNames == null) {
                int n = this.fields.size();
                ArrayList<String> arrayList = new ArrayList<String>(n);
                int n2 = 0;
                while (n2 < n) {
                    JDOField jDOField = (JDOField)this.fields.get(n2);
                    if (jDOField.isManaged()) {
                        arrayList.add(jDOField.getName());
                    }
                    ++n2;
                }
                this.managedFieldNames = arrayList.toArray(new String[arrayList.size()]);
            }
            return this.managedFieldNames;
        }

        public final String toString() {
            return "<super:" + this.superClassName + ',' + JDOMetaDataProperties.PROPERTY_ACCESS_MODIFIER + ':' + Modifier.toString(this.modifiers) + ',' + JDOMetaDataProperties.PROPERTY_JDO_MODIFIER + ':' + this.isPersistent + ',' + "fields:" + this.fields + '>';
        }
    }

    private static interface IErrorMessages {
        public static final String PREFIX = "Error Parsing meta data properties: ";
        public static final String ERR_EMPTY_FIELDNAME = "Error Parsing meta data properties: The class ''{0}'' may not have an empty fieldname.";
        public static final String ERR_INVALID_FIELDNAME = "Error Parsing meta data properties: The field name ''{1}'' of class ''{0}'' is not valid.";
        public static final String ERR_EMPTY_PROPERTY_NAME_OR_VALUE = "Error Parsing meta data properties: The property name and value may not be empty if a '':'' is specified: ''{0}''.";
        public static final String ERR_INVALID_PROPERTY_NAME = "Error Parsing meta data properties: Invalid property name for entry ''{0}'': ''{1}''.";
        public static final String ERR_INVALID_PROPERTY_VALUE = "Error Parsing meta data properties: Invalid value for property ''{1}'' of entry ''{0}'': ''{2}''.";
        public static final String ERR_DUPLICATE_PROPERTY_NAME = "Error Parsing meta data properties: The property ''{1}'' for the entry ''{0}'' entered twice with values: ''{2}'' and ''{3}''.";
        public static final String ERR_TRANSIENT_CLASS_WITH_PERSISTENT_FIELD = "Error Parsing meta data properties: A non-persistent class cannot have a persistent field (class ''{0}'' with field ''{1})''.";
        public static final String ERR_TRANSIENT_CLASS_WITH_TRANSACTIONAL_FIELD = "Error Parsing meta data properties: A non-persistent class cannot have a transactional field (class ''{0}'' with field ''{1})''.";
        public static final String ERR_TRANSIENT_CLASS_WITH_ANNOTATED_FIELD = "Error Parsing meta data properties: A non-persistent class cannot have an annotated field (''{1}'' of class ''{0}'') can''t have a fetch group.";
        public static final String ERR_NON_PERSISTENT_ANNOTATED_FIELD = "Error Parsing meta data properties: A non-persistent field (''{1}'' of class ''{0}'') can''t be a annotated.";
    }

    private static final class Property {
        String name = null;
        String value = null;

        private Property() {
        }

        public final String toString() {
            return '<' + this.name + ':' + this.value + '>';
        }
    }
}

