/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.AttributeVector;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassMember;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;

public class ClassMethod
extends ClassMember {
    public static final String intializerName = "<init>";
    public static final String staticIntializerName = "<clinit>";
    private int accessFlags;
    private ConstUtf8 methodName;
    private ConstUtf8 methodSignature;
    private AttributeVector methodAttributes;

    public int access() {
        return this.accessFlags;
    }

    public void setAccess(int n) {
        this.accessFlags = n;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public ConstUtf8 name() {
        return this.methodName;
    }

    public void changeName(ConstUtf8 constUtf8) {
        this.methodName = constUtf8;
    }

    public ConstUtf8 signature() {
        return this.methodSignature;
    }

    public void changeSignature(ConstUtf8 constUtf8) {
        this.methodSignature = constUtf8;
    }

    public AttributeVector attributes() {
        return this.methodAttributes;
    }

    public ClassMethod(int n, ConstUtf8 constUtf8, ConstUtf8 constUtf82, AttributeVector attributeVector) {
        this.accessFlags = n;
        this.methodName = constUtf8;
        this.methodSignature = constUtf82;
        this.methodAttributes = attributeVector;
    }

    int codeSize() {
        CodeAttribute codeAttribute = this.codeAttribute();
        return codeAttribute == null ? 0 : codeAttribute.codeSize();
    }

    public CodeAttribute codeAttribute() {
        Enumeration enumeration = this.methodAttributes.elements();
        while (enumeration.hasMoreElements()) {
            ClassAttribute classAttribute = (ClassAttribute)enumeration.nextElement();
            if (!(classAttribute instanceof CodeAttribute)) continue;
            return (CodeAttribute)classAttribute;
        }
        return null;
    }

    static ClassMethod read(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readUnsignedShort();
        ClassMethod classMethod = new ClassMethod(n, (ConstUtf8)constantPool.constantAt(n2), (ConstUtf8)constantPool.constantAt(n3), null);
        classMethod.methodAttributes = AttributeVector.readAttributes(dataInputStream, constantPool);
        return classMethod;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        CodeAttribute codeAttribute = this.codeAttribute();
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.methodName.getIndex());
        dataOutputStream.writeShort(this.methodSignature.getIndex());
        this.methodAttributes.write(dataOutputStream);
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.print("'" + this.methodName.asString() + "'");
        printStream.print(" sig = " + this.methodSignature.asString());
        printStream.print(" accessFlags = " + Integer.toString(this.accessFlags));
        printStream.println(" attributes:");
        this.methodAttributes.print(printStream, n + 2);
    }
}

