/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.util;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import com.iplanet.ias.tools.forte.util.PropertySupportUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

public class IntPropertySupport
extends PropertySupport.Reflection {
    private int minVal = Integer.MIN_VALUE;
    private int maxVal = Integer.MAX_VALUE;
    private String errMessageName = null;
    private ResourceBundle bundle = null;
    boolean reported = false;

    public IntPropertySupport(Object instance, ResourceBundle bundle, String name) throws NoSuchMethodException {
        super(instance, Integer.TYPE, name);
        PropertySupportUtils.setNames((Node.Property)this, bundle, name);
        this.errMessageName = "ERRMSG_" + name;
        this.bundle = bundle;
    }

    public IntPropertySupport(Object instance, ResourceBundle bundle, String name, int minValue, int maxValue) throws NoSuchMethodException {
        this(instance, bundle, name);
        this.minVal = minValue;
        this.maxVal = maxValue;
    }

    public void setValue(Object inVal) throws IllegalAccessException, InvocationTargetException {
        Integer iVal = (Integer)inVal;
        int i = iVal;
        if (i >= this.minVal && i <= this.maxVal) {
            super.setValue(inVal);
        } else if (!this.reported) {
            try {
                TopManager.getDefault().notify(new NotifyDescriptor((Object)this.bundle.getString(this.errMessageName), this.bundle.getString("TTL_" + this.errMessageName), -1, 0, null, null));
            }
            catch (Throwable t) {
                Reporter.critical(t);
                Reporter.verbose(new StackTrace(t));
            }
            this.reported = true;
        } else {
            this.reported = false;
        }
    }
}

