/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.server.gui.jato.IASViewBean;
import com.iplanet.ias.admin.server.gui.jato.SSLContainerView;
import com.iplanet.ias.admin.servermodel.beans.IiopListener;
import com.iplanet.ias.admin.servermodel.beans.ORBComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import javax.management.Attribute;
import javax.management.AttributeList;

public class IIOPListenerViewBean
extends IASViewBean
implements ConfigAttributeName.ORBListener,
ConfigAttributeName.Ssl {
    public static final String PAGE_NAME = "IIOPListener";
    private static final String CHILD_SSLCONTAINERVIEW = "SSLContainerView";
    private static String[] name = new String[]{"Id", "Address", "Port", "Enable"};
    private static String[] configName = new String[]{"id", "address", "port", "enabled"};
    private static short[] type = new short[]{1, 1, 1, 3};
    private static String[] SSLConfigName = new String[]{"cert", "ssl2", "ssl3", "tls", "tlsRollback", "clientAuth"};
    private static String[] SSLName = new String[]{"CertName", "SSL2Enable", "SSL3Enable", "TLSEnable", "TLSRollback", "ClientEnable"};
    private static short[] SSLType = new short[]{5, 3, 3, 3, 3, 3};
    private static String[] listName = new String[]{"Id", "Address", "Port", "Enable"};
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$gui$jato$SSLContainerView;

    public IIOPListenerViewBean(RequestContext requestContext) {
        super(requestContext, PAGE_NAME);
        this.registerChild(CHILD_SSLCONTAINERVIEW, class$com$iplanet$ias$admin$server$gui$jato$SSLContainerView == null ? (class$com$iplanet$ias$admin$server$gui$jato$SSLContainerView = IIOPListenerViewBean.class$("com.iplanet.ias.admin.server.gui.jato.SSLContainerView")) : class$com$iplanet$ias$admin$server$gui$jato$SSLContainerView);
    }

    protected View createChild(String string) {
        try {
            return super.createChild(string);
        }
        catch (Exception exception) {
            if (string.equals(CHILD_SSLCONTAINERVIEW)) {
                return new SSLContainerView((View)this, CHILD_SSLCONTAINERVIEW);
            }
            throw new IllegalArgumentException("Invalid child name [" + string + "]");
        }
    }

    private SSLContainerView getSSLContainerView() {
        return (SSLContainerView)this.getChild(CHILD_SSLCONTAINERVIEW);
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        block10: {
            super.beginDisplay(displayEvent);
            SSLContainerView sSLContainerView = this.getSSLContainerView();
            int n = this.getMode();
            try {
                String[] stringArray = this.getInstance().getCertNickNames();
                sSLContainerView.populateCertificateNickNames(stringArray);
                if (n == 2) {
                    IiopListener iiopListener = (IiopListener)this.getServerComponent(this.getKey().toString());
                    if (iiopListener != null && iiopListener.isSSLCreated()) {
                        AttributeList attributeList = iiopListener.getAttributes(SSLConfigName);
                        int n2 = 0;
                        while (n2 < SSLName.length) {
                            Attribute attribute = (Attribute)attributeList.get(n2);
                            Object object = attribute.getValue();
                            if (attribute.getName().equals("cert")) {
                                sSLContainerView.ensureCertificateNickName(object.toString());
                            }
                            if (SSLType[n2] == 3) {
                                Boolean bl = (Boolean)object;
                                if (bl == null) {
                                    bl = (Boolean)iiopListener.getDefaultAttributeValue(SSLConfigName[n2]);
                                }
                                sSLContainerView.setBooleanValue(SSLName[n2], bl);
                            } else {
                                sSLContainerView.setObjectValue(SSLName[n2], object);
                            }
                            ++n2;
                        }
                        this.setCipherAttributes(iiopListener);
                    } else {
                        this.setDefaultSSLValues(iiopListener);
                    }
                    break block10;
                }
                this.setDefaultSSLValues();
            }
            catch (Exception exception) {
                this.setErrorMessage(exception.getMessage());
            }
        }
    }

    protected String[] getDisplayNames() {
        return name;
    }

    protected String[] getConfigNames() {
        return configName;
    }

    protected short[] getTypes() {
        return type;
    }

    protected String[] getListNames() {
        return listName;
    }

    protected void add() throws Exception {
        ORBComponentBean oRBComponentBean = this.getInstance().getORBComponent();
        String string = this.getDisplayFieldStringValue(name[1]);
        String string2 = this.getDisplayFieldStringValue(name[0]);
        oRBComponentBean.addIiopListener(string2, string);
        IiopListener iiopListener = oRBComponentBean.getIiopListener(string2);
        iiopListener.setAttribute("port", (Object)this.getDisplayFieldStringValue(name[2]));
        iiopListener.setAttribute("enabled", (Object)this.getDisplayFieldStringValue(name[3]));
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        if (sSLContainerView.isCertificateSelected()) {
            this.AddSSLAttributes(iiopListener);
        }
    }

    private void AddSSLAttributes(IiopListener iiopListener) throws Exception {
        String[] stringArray = new String[]{"rc4", "rc4export", "rc2", "rc2export", "idea", "des", "desede3"};
        String[] stringArray2 = new String[]{"rsa_rc4_128_md5", "rsa_3des_sha", "rsa_des_sha", "rsa_rc4_40_md5", "rsa_rc2_40_md5", "rsa_null_md5", "rsa_des_56_sha", "rsa_rc4_56_sha"};
        String[] stringArray3 = new String[]{"CertName", "SSL2Enable", "SSL3Enable", "TLSEnable", "TLSRollback", "ClientEnable"};
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        String string = sSLContainerView.getSSLValue("CertName").toString();
        if (iiopListener.isSSLCreated()) {
            iiopListener.setAttribute("cert", (Object)string);
        } else {
            iiopListener.createSSL(string);
        }
        int n = 1;
        while (n < stringArray3.length) {
            iiopListener.setAttribute(SSLConfigName[n], sSLContainerView.getSSLValue(stringArray3[n]));
            ++n;
        }
        iiopListener.setAttribute("ssl2Ciphers", (Object)sSLContainerView.getSelectedCiphers(stringArray));
        iiopListener.setAttribute("ssl3Ciphers", (Object)sSLContainerView.getSelectedCiphers(stringArray2));
    }

    protected void postSave(RequestInvocationEvent requestInvocationEvent) throws Exception {
        String string = (String)this.getDisplayFieldValue(this.getKeyAttribute() + "Hidden");
        IiopListener iiopListener = null;
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        iiopListener = (IiopListener)this.getServerComponent(string);
        if (iiopListener != null) {
            if (sSLContainerView.isCertificateSelected()) {
                this.AddSSLAttributes(iiopListener);
            } else if (iiopListener.isSSLCreated()) {
                iiopListener.deleteSSL();
                this.setDefaultSSLValues(iiopListener);
                sSLContainerView.resetCipherAttributes();
            }
        }
        super.postSave(requestInvocationEvent);
    }

    private void setDefaultSSLValues(IiopListener iiopListener) throws Exception {
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        int n = 0;
        while (n < SSLName.length) {
            Object object;
            if (SSLType[n] == 3) {
                object = (Boolean)iiopListener.getDefaultAttributeValue(SSLConfigName[n]);
                if (object == null) {
                    object = new Boolean(false);
                }
                sSLContainerView.setBooleanValue(SSLName[n], (Boolean)object);
            } else {
                object = iiopListener.getAttribute(SSLConfigName[n]);
                sSLContainerView.setObjectValue(SSLName[n], object);
            }
            ++n;
        }
        sSLContainerView.resetCipherAttributes();
        sSLContainerView.setCipherValue("rsa_des_56_sha", true);
        sSLContainerView.setCipherValue("rsa_rc4_56_sha", true);
        sSLContainerView.setCipherValue("rsa_des_sha", true);
        sSLContainerView.setCipherValue("rsa_rc4_128_md5", true);
        sSLContainerView.setCipherValue("rsa_3des_sha", true);
    }

    private void setCipherAttributes(IiopListener iiopListener) throws Exception {
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        String string = (String)iiopListener.getAttribute("ssl2Ciphers");
        sSLContainerView.setCipherFields(string);
        String string2 = (String)iiopListener.getAttribute("ssl3Ciphers");
        sSLContainerView.setCipherFields(string2);
    }

    private void setDefaultSSLValues() {
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        sSLContainerView.setBooleanValue("TLSEnable", new Boolean(true));
        sSLContainerView.setBooleanValue("TLSRollback", new Boolean(true));
        sSLContainerView.setCipherValue("rsa_des_56_sha", true);
        sSLContainerView.setCipherValue("rsa_rc4_56_sha", true);
        sSLContainerView.setCipherValue("rsa_des_sha", true);
        sSLContainerView.setCipherValue("rsa_rc4_128_md5", true);
        sSLContainerView.setCipherValue("rsa_3des_sha", true);
    }

    protected ServerComponent getServerComponent(String string) throws Exception {
        return this.getInstance().getORBComponent().getIiopListener(string);
    }

    public String getAddURL() {
        return "CreateIIOPListener.jsp";
    }

    public String getEditURL() {
        return "EditIIOPListener.jsp";
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    public String getForwardPageName() {
        return "IIOPListeners";
    }

    public String getKeyAttribute() {
        return name[0];
    }

    protected String getListViewBeanName() {
        return "IIOPListenersViewBean";
    }

    protected IASViewBean getIASViewBean() {
        return this;
    }

    protected String getObjectType() {
        return "orblistener";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

