/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.server.gui.jato.IASViewBean;
import com.iplanet.ias.admin.server.gui.jato.SSLContainerView;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.beans.HttpListener;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.ComboBox;
import com.iplanet.jato.view.html.OptionList;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;

public class HttpListenerViewBean
extends IASViewBean
implements ConfigAttributeName.HTTPListener,
ConfigAttributeName.Ssl {
    public static final String PAGE_NAME = "HttpListener";
    private static final String CHILD_SSLCONTAINERVIEW = "SSLContainerView";
    private static String[] name = new String[]{"Id", "Address", "Port", "ServerName", "VirtualServer", "Family", "AccptThreads", "BlockEnable", "SecurityEnable", "Enable"};
    private static String[] configName = new String[]{"id", "address", "port", "serverName", "defaultVirtualServer", "family", "acceptorThreads", "blockingEnabled", "securityEnabled", "enabled"};
    private static short[] type = new short[]{1, 1, 2, 1, 5, 1, 2, 3, 3, 3};
    private static String[] SSLConfigName = new String[]{"cert", "ssl2", "ssl3", "tls", "tlsRollback", "clientAuth"};
    private static String[] SSLName = new String[]{"CertName", "SSL2Enable", "SSL3Enable", "TLSEnable", "TLSRollback", "ClientEnable"};
    private static short[] SSLType = new short[]{5, 3, 3, 3, 3, 3};
    private static String[] listName = new String[]{"Id", "Address", "Port", "Enable", "ServerName", "SecurityEnable"};
    private String[] attributes = new String[]{"Family", "AccptThreads", "BlockEnable", "SecurityEnable", "Enable"};
    private String[] configAttr = new String[]{"family", "acceptorThreads", "blockingEnabled", "securityEnabled", "enabled"};
    private RequestContext rc = null;
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$gui$jato$SSLContainerView;

    public HttpListenerViewBean(RequestContext requestContext) {
        super(requestContext, PAGE_NAME);
        this.registerChild(CHILD_SSLCONTAINERVIEW, class$com$iplanet$ias$admin$server$gui$jato$SSLContainerView == null ? (class$com$iplanet$ias$admin$server$gui$jato$SSLContainerView = HttpListenerViewBean.class$("com.iplanet.ias.admin.server.gui.jato.SSLContainerView")) : class$com$iplanet$ias$admin$server$gui$jato$SSLContainerView);
        this.rc = requestContext;
    }

    protected View createChild(String string) {
        if (string.equals(CHILD_SSLCONTAINERVIEW)) {
            return new SSLContainerView((View)this, CHILD_SSLCONTAINERVIEW);
        }
        return super.createChild(string);
    }

    private SSLContainerView getSSLContainerView() {
        return (SSLContainerView)this.getChild(CHILD_SSLCONTAINERVIEW);
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        block10: {
            super.beginDisplay(displayEvent);
            SSLContainerView sSLContainerView = this.getSSLContainerView();
            int n = this.getMode();
            try {
                String[] stringArray = this.getInstance().getCertNickNames();
                sSLContainerView.populateCertificateNickNames(stringArray);
                this.populateVirtualServers();
                if (n == 2) {
                    HttpListener httpListener = (HttpListener)this.getServerComponent(this.getKey().toString());
                    if (httpListener != null && httpListener.isSSLCreated()) {
                        AttributeList attributeList = httpListener.getAttributes(SSLConfigName);
                        int n2 = 0;
                        while (n2 < SSLName.length) {
                            Attribute attribute = (Attribute)attributeList.get(n2);
                            Object object = attribute.getValue();
                            if (attribute.getName().equals("cert")) {
                                sSLContainerView.ensureCertificateNickName(object.toString());
                            }
                            if (SSLType[n2] == 3) {
                                Boolean bl = (Boolean)object;
                                if (bl == null) {
                                    bl = (Boolean)httpListener.getDefaultAttributeValue(SSLConfigName[n2]);
                                }
                                sSLContainerView.setBooleanValue(SSLName[n2], bl);
                            } else {
                                sSLContainerView.setObjectValue(SSLName[n2], object);
                            }
                            ++n2;
                        }
                        this.setCipherAttributes(httpListener);
                    } else {
                        this.setDefaultSSLValues(httpListener);
                    }
                    break block10;
                }
                this.setDefaultSSLValues();
            }
            catch (Exception exception) {
                this.setErrorMessage(exception.getMessage());
            }
        }
    }

    protected String[] getDisplayNames() {
        return name;
    }

    protected String[] getConfigNames() {
        return configName;
    }

    protected short[] getTypes() {
        return type;
    }

    protected String[] getListNames() {
        return listName;
    }

    protected void add() throws Exception {
        AppServerInstance appServerInstance = this.getInstance();
        String string = this.getDisplayFieldStringValue(name[0]);
        String string2 = this.getDisplayFieldStringValue(name[1]);
        String string3 = this.getDisplayFieldStringValue("VirtualServer");
        String string4 = this.getDisplayFieldStringValue("ServerName");
        int n = this.getDisplayFieldIntValue(name[2]);
        HttpServiceComponentBean httpServiceComponentBean = appServerInstance.getHttpService();
        httpServiceComponentBean.createHttpListener(string, string2, n, string3, string4);
        HttpListener httpListener = httpServiceComponentBean.getHttpListener(string);
        this.setAttributes(this.attributes, this.configAttr, (ServerComponent)httpListener);
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        if (sSLContainerView.isCertificateSelected()) {
            this.AddSSLAttributes(httpListener);
        }
    }

    private void AddSSLAttributes(HttpListener httpListener) throws Exception {
        Attribute attribute;
        String[] stringArray = new String[]{"rc4", "rc4export", "rc2", "rc2export", "idea", "des", "desede3"};
        String[] stringArray2 = new String[]{"rsa_rc4_128_md5", "rsa_3des_sha", "rsa_des_sha", "rsa_rc4_40_md5", "rsa_rc2_40_md5", "rsa_null_md5", "rsa_des_56_sha", "rsa_rc4_56_sha"};
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        String string = sSLContainerView.getSSLValue("CertName").toString();
        if (httpListener.isSSLCreated()) {
            httpListener.setAttribute("cert", (Object)string);
        } else {
            httpListener.createSSL(string);
        }
        AttributeList attributeList = new AttributeList();
        int n = 1;
        while (n < SSLName.length) {
            attribute = new Attribute(SSLConfigName[n], sSLContainerView.getSSLValue(SSLName[n]));
            attributeList.add(attribute);
            ++n;
        }
        attribute = new Attribute("ssl2Ciphers", sSLContainerView.getSelectedCiphers(stringArray));
        attributeList.add(attribute);
        attribute = new Attribute("ssl3Ciphers", sSLContainerView.getSelectedCiphers(stringArray2));
        attributeList.add(attribute);
        httpListener.setAttributes(attributeList);
    }

    private void setDefaultSSLValues(HttpListener httpListener) throws Exception {
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        int n = 0;
        while (n < SSLName.length) {
            Object object;
            if (SSLType[n] == 3) {
                object = (Boolean)httpListener.getDefaultAttributeValue(SSLConfigName[n]);
                if (object == null) {
                    object = new Boolean(false);
                }
                sSLContainerView.setBooleanValue(SSLName[n], (Boolean)object);
            } else {
                object = httpListener.getDefaultAttributeValue(SSLConfigName[n]);
                sSLContainerView.setObjectValue(SSLName[n], object);
            }
            ++n;
        }
        sSLContainerView.resetCipherAttributes();
        sSLContainerView.setCipherValue("rsa_des_56_sha", true);
        sSLContainerView.setCipherValue("rsa_rc4_56_sha", true);
        sSLContainerView.setCipherValue("rsa_des_sha", true);
        sSLContainerView.setCipherValue("rsa_rc4_128_md5", true);
        sSLContainerView.setCipherValue("rsa_3des_sha", true);
    }

    private void setDefaultSSLValues() {
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        sSLContainerView.setBooleanValue("TLSEnable", new Boolean(true));
        sSLContainerView.setBooleanValue("TLSRollback", new Boolean(true));
        sSLContainerView.setCipherValue("rsa_des_56_sha", true);
        sSLContainerView.setCipherValue("rsa_rc4_56_sha", true);
        sSLContainerView.setCipherValue("rsa_des_sha", true);
        sSLContainerView.setCipherValue("rsa_rc4_128_md5", true);
        sSLContainerView.setCipherValue("rsa_3des_sha", true);
    }

    protected void postSave(RequestInvocationEvent requestInvocationEvent) throws Exception {
        String string = (String)this.getDisplayFieldValue(this.getKeyAttribute() + "Hidden");
        HttpListener httpListener = null;
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        httpListener = (HttpListener)this.getServerComponent(string);
        if (httpListener != null) {
            if (sSLContainerView.isCertificateSelected()) {
                this.AddSSLAttributes(httpListener);
            } else if (httpListener.isSSLCreated()) {
                httpListener.deleteSSL();
                this.setDefaultSSLValues(httpListener);
                sSLContainerView.resetCipherAttributes();
            }
        }
        super.postSave(requestInvocationEvent);
    }

    protected ServerComponent getServerComponent(String string) throws Exception {
        AppServerInstance appServerInstance = this.getInstance();
        HttpServiceComponentBean httpServiceComponentBean = appServerInstance.getHttpService();
        HttpListener httpListener = httpServiceComponentBean.getHttpListener(string);
        return httpListener;
    }

    public String getAddURL() {
        return "CreateHttpListener.jsp";
    }

    public String getEditURL() {
        return "EditHttpListener.jsp";
    }

    private void setCipherAttributes(HttpListener httpListener) throws Exception {
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        String string = (String)httpListener.getAttribute("ssl2Ciphers");
        sSLContainerView.setCipherFields(string);
        String string2 = (String)httpListener.getAttribute("ssl3Ciphers");
        sSLContainerView.setCipherFields(string2);
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    public String getForwardPageName() {
        return "HttpListeners";
    }

    public String getKeyAttribute() {
        return name[0];
    }

    protected String getListViewBeanName() {
        return "HttpListenersViewBean";
    }

    protected IASViewBean getIASViewBean() {
        return this;
    }

    private void populateVirtualServers() throws Exception {
        ComboBox comboBox = this.getComboBoxChild("VirtualServer");
        ArrayList arrayList = this.getVSList();
        if (arrayList.size() > 0) {
            String[] stringArray = arrayList.toArray(new String[0]);
            OptionList optionList = new OptionList(stringArray, stringArray);
            comboBox.setOptions(optionList);
        }
    }

    private ArrayList getVSList() throws Exception {
        VirtualServerClass virtualServerClass;
        ServerModelIterator serverModelIterator = null;
        AppServerInstance appServerInstance = this.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (appServerInstance != null) {
            virtualServerClass = appServerInstance.getHttpService().getVirtualServerClass("defaultclass");
            serverModelIterator = virtualServerClass.getVirtualServers();
        }
        if (serverModelIterator != null) {
            while (serverModelIterator.hasNext()) {
                virtualServerClass = (VirtualServer)serverModelIterator.next();
                arrayList.add(virtualServerClass.getDisplayName());
            }
        }
        return arrayList;
    }

    protected String getObjectType() {
        return "httplistener";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

