/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.tools.cli.BaseMultiProcessCommand;
import com.iplanet.ias.tools.cli.framework.Command;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandLineParser;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.GlobalsManager;
import com.iplanet.ias.tools.cli.framework.IUserInput;
import com.iplanet.ias.tools.cli.framework.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiProcessCommand
extends BaseMultiProcessCommand {
    private static final String ENCODING = "encoding";
    private boolean mDone = false;
    private static final String kPromptString = GlobalsManager.getLocalizedString("PromptString");
    private static final String kYesNoString = GlobalsManager.getLocalizedString("YesNoString");

    public MultiProcessCommand() {
    }

    public MultiProcessCommand(String string) {
        this.setName(string);
    }

    public String getHelp() {
        return this.helpStr;
    }

    private void setGlobalOptions() throws CommandValidationException {
        if (this.isInteractive()) {
            super.initUserInput();
        }
    }

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = true;
        bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isFileOptionSpecified()) {
            String string = this.getFileOptionValue();
            bl = this.checkForFileExistence(string);
        }
        return bl;
    }

    private boolean isFileOptionSpecified() {
        Option option = this.findOption("file");
        return option != null;
    }

    private String getFileOptionValue() {
        String string = null;
        Option option = this.findOption("file");
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private void initPrintPromptOption() throws CommandValidationException {
        Option option = this.findOption("printprompt");
        String string = option.getValue();
        if (!string.equalsIgnoreCase("true") && !string.equalsIgnoreCase("false")) {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        super.getGlobalsMgr().setOption(option);
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Option option;
        String string = null;
        this.setGlobalOptions();
        if (!this.validateOptions()) {
            return;
        }
        if (!this.isFileOptionSpecified()) {
            this.printExitMessage();
        }
        if ((option = this.findOption(ENCODING)) != null) {
            string = option.getValue();
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = string != null ? this.createBufferedReader(string) : this.createBufferedReader();
            while (!this.mDone) {
                this.printPrompt();
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    if (this.isFileOptionSpecified()) {
                        bufferedReader = this.createBufferedReaderFromStream(System.in);
                        string2 = bufferedReader.readLine();
                    } else {
                        super.getUserOutput().println("exit");
                        this.mDone = true;
                        continue;
                    }
                }
                string2.trim();
                if (!this.isExecutableLine(string2)) continue;
                if (this.isExitLine(string2)) {
                    if (this.isEchoOn()) {
                        super.getUserOutput().println(string2);
                    }
                    this.mDone = true;
                    continue;
                }
                this.processLine(string2);
            }
        }
        catch (IOException iOException) {
            this.printError(iOException.getMessage());
            throw new CommandException(iOException.getMessage());
        }
    }

    private void printPrompt() throws CommandValidationException {
        if (!this.isFileOptionSpecified()) {
            Option option = super.getGlobalsMgr().getOption("printprompt");
            if (option != null) {
                String string = option.getValue();
                if (string.equalsIgnoreCase("true")) {
                    this.printThePrompt();
                }
            } else {
                this.printThePrompt();
            }
        } else if (this.shouldPrintPrompt()) {
            this.printThePrompt();
        }
    }

    private boolean isExecutableLine(String string) {
        boolean bl = true;
        if (string == null) {
            this.mDone = true;
            bl = false;
        } else if (string.trim().equals("") || string.startsWith("#") || !this.checkForEmptyInput(string)) {
            bl = false;
        }
        return bl;
    }

    private boolean isExitLine(String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase("exit") || string.equalsIgnoreCase("quit")) {
            bl = true;
        }
        return bl;
    }

    private BufferedReader createBufferedReader() throws IOException {
        BufferedReader bufferedReader = null;
        if (this.isFileOptionSpecified()) {
            String string = this.findOption("file").getValue();
            File file = new File(string);
            bufferedReader = this.createBufferedReaderFromFile(file);
        } else {
            bufferedReader = this.createBufferedReaderFromStream(System.in);
        }
        return bufferedReader;
    }

    private BufferedReader createBufferedReader(String string) throws IOException {
        BufferedReader bufferedReader = null;
        if (this.isFileOptionSpecified()) {
            String string2 = this.findOption("file").getValue();
            FileInputStream fileInputStream = new FileInputStream(string2);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string));
        } else {
            this.printMessage(this.getLocalizedString("NeedFileInput"));
            bufferedReader = this.createBufferedReaderFromStream(System.in);
        }
        return bufferedReader;
    }

    private BufferedReader createBufferedReaderFromFile(File file) throws FileNotFoundException {
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new FileReader(file));
        return bufferedReader;
    }

    private BufferedReader createBufferedReaderFromStream(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return bufferedReader;
    }

    private void processLine(String string) throws CommandValidationException {
        String[] stringArray = this.convertLineToArgs(string);
        Command command = null;
        try {
            if (stringArray == null || stringArray.length == 0) {
                super.getUserOutput().println(this.getLocalizedString("CommandNotFound"));
                return;
            }
            CommandLineParser commandLineParser = new CommandLineParser(stringArray);
            command = commandLineParser.getCommand();
            command.runCommand();
        }
        catch (CommandValidationException commandValidationException) {
            if (command != null) {
                Debug.printStackTrace(commandValidationException);
                this.printError(commandValidationException.getMessage());
                this.printMessage(command.getUsage());
            }
        }
        catch (Exception exception) {
            IUserInput iUserInput = super.getUserInput();
            this.printError(exception.getLocalizedMessage());
            Debug.printStackTrace(exception);
        }
    }

    private String readLine() {
        String string = null;
        try {
            BufferedReader bufferedReader = this.createBufferedReaderFromStream(System.in);
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            this.printError(iOException.getMessage());
            ExceptionUtil.ignoreException(iOException);
        }
        return string;
    }

    private void userInteractiveInput(String string) {
        if (string == null) {
            this.printMessage(this.getLocalizedString("InputMustBeSpecified"));
            return;
        }
        if (string.trim().equals("")) {
            this.printError(this.getLocalizedString("IllegalOperation"));
            this.mDone = true;
        } else if (string.equalsIgnoreCase(this.getLocalizedString("YesString")) || string.equalsIgnoreCase(this.getLocalizedString("YeString")) || this.checkForFirstCharacter(string).equals(new Character(this.getLocalizedString("yCharacter").charAt(0))) || this.checkForFirstCharacter(string).equals(new Character(this.getLocalizedString("YCharacter").charAt(0)))) {
            this.mDone = false;
        } else if (string.equalsIgnoreCase(this.getLocalizedString("NoString")) || this.checkForFirstCharacter(string).equals(new Character(this.getLocalizedString("nCharacter").charAt(0))) || this.checkForFirstCharacter(string).equals(new Character(this.getLocalizedString("NCharacter").charAt(0)))) {
            this.mDone = true;
        } else {
            this.printError(this.getLocalizedString("NotValidInput"));
            this.mDone = true;
        }
    }

    private Character checkForFirstCharacter(String string) {
        Character c = null;
        if (!string.equals("")) {
            char c2 = string.charAt(0);
            c = new Character(c2);
        }
        return c;
    }

    private void printExitMessage() {
        super.getUserOutput().println(this.getLocalizedString("ExitMessage"));
    }

    private void printThePrompt() {
        super.getUserOutput().print(kPromptString);
    }

    private boolean checkForEmptyInput(String string) {
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n <= 0) {
            bl = false;
        }
        return bl;
    }

    private String[] convertLineToArgs(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String string2 = "";
        boolean bl = false;
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        while (n2 < n) {
            object = (String)stringTokenizer.nextElement();
            if (!bl && ((String)object).startsWith("\"") && !((String)object).endsWith("\"")) {
                string2 = ((String)object).substring(1);
                bl = true;
            } else if (bl) {
                string2 = string2 + " " + (String)object;
                if (((String)object).endsWith("\"")) {
                    object = string2.substring(0, string2.length() - 1);
                    bl = false;
                }
            }
            if (!bl) {
                vector.addElement(object);
            }
            ++n2;
        }
        object = new String[vector.size()];
        object = vector.toArray((T[])object);
        return object;
    }

    private void isDoneOrContinue() throws CommandValidationException {
        if (this.isInteractive()) {
            Debug.println("Interactive is true");
            super.getUserOutput().print(this.getLocalizedString("WouldContinue") + "  " + kYesNoString);
            String string = this.readLine();
            this.userInteractiveInput(string);
        } else {
            Debug.println("Interactive is false, mDone = " + this.mDone);
            this.mDone = true;
        }
    }
}

