/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;

public class ListDomainsCommand
extends BaseLifeCycleCommand {
    public ListDomainsCommand() {
    }

    public ListDomainsCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isLocal()) {
            return true;
        }
        if (this.findOption("host") == null || this.findOption("port") == null || this.findOption("user") == null) {
            String string = null;
            Option option = this.findOption("host");
            string = this.findOption("host") == null ? "host" : (this.findOption("port") == null ? "port" : "user");
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (!this.isPasswordProvided()) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{"password"}));
            }
            this.initPasswordOption();
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        DomainEntry[] domainEntryArray = null;
        try {
            domainEntryArray = this.getDomainEntries();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            Debug.println("Listing domains, Exception caught ");
            this.printMessage(this.getLocalizedString("CannotListDomains"));
            throw new CommandException(throwable.getLocalizedMessage());
        }
        if (domainEntryArray != null && domainEntryArray.length > 0) {
            this.printDomainEntries(domainEntryArray);
        } else {
            this.printMessage(this.getLocalizedString("NoDomains"));
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    public void printDomainEntries(DomainEntry[] domainEntryArray) {
        if (domainEntryArray != null) {
            int n = 0;
            while (n < domainEntryArray.length) {
                DomainEntry domainEntry = domainEntryArray[n];
                this.printMessage(domainEntry.getName() + "    [" + domainEntry.getPath() + "]");
                ++n;
            }
        }
    }
}

