/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseConfigurationCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;

public class ListAttributeCommand
extends BaseConfigurationCommand {
    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (bl) {
            int n = 0;
            while (n < this.operands.size()) {
                Operand operand = (Operand)this.operands.get(n);
                if (operand.getValue() != null) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        ServerInstanceManager serverInstanceManager;
        if (!this.validateOptions()) {
            return;
        }
        try {
            serverInstanceManager = this.getServerInstanceManager();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            throw new CommandException(exception.getMessage());
        }
        String string = ((Operand)this.operands.get(0)).getName();
        if (this.isMonitoring()) {
            try {
                int n;
                String[] stringArray = serverInstanceManager.listMonitorableComponents(string);
                int n2 = n = stringArray != null ? stringArray.length : 0;
                if (n < 1) {
                    this.printMessage(this.getLocalizedString("NoMonitorableAttributes", new Object[]{string}));
                }
                int n3 = 0;
                while (n3 < n) {
                    this.printMessage(stringArray[n3]);
                    ++n3;
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                this.printError(this.getLocalizedString("CannotListMonitorableAttributes"));
                throw new CommandException(exception.getMessage());
            }
        }
        try {
            int n;
            String[] stringArray = serverInstanceManager.listGenericDottedNameContinuiations(string);
            int n4 = n = stringArray != null ? stringArray.length : 0;
            if (n > 0) {
                this.printMessage(this.getLocalizedString("ListOfConfigurableAttributes", new Object[]{string}));
            } else {
                this.printMessage(this.getLocalizedString("NoConfigurableAttributes", new Object[]{string}));
            }
            int n5 = 0;
            while (n5 < n) {
                this.printMessage("    " + stringArray[n5]);
                ++n5;
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotListConfigurableAttributes"));
            throw new CommandException(exception.getMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

