/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.license.LicenseBase;
import com.iplanet.ias.license.LicenseManager;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;

public class DisplayLicenseCommand
extends BaseOtherCommand {
    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isLocal()) {
            return true;
        }
        if (this.findOption("host") == null || this.findOption("port") == null || this.findOption("user") == null) {
            String string = null;
            string = this.findOption("host") == null ? "host" : (this.findOption("port") == null ? "port" : "user");
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (!this.isPasswordProvided()) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{"password"}));
            }
            this.initPasswordOption();
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            if (this.isLocal()) {
                LicenseBase licenseBase = LicenseManager.getLicense();
                String string = licenseBase.printLicenseString();
                this.printMessage(string);
            } else {
                ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
                String string = serverInstanceManager.getLicenseInfo();
                this.printMessage(string);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CouldNotGetLicense"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

