/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.ORBComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreateIIOPListenerCommand
extends BaseOtherCommand {
    private static final String IIOP_PORT = "iiopport";
    private static final String ENABLED = "enabled";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Serializable serializable;
        Controllable controllable;
        ORBComponentBean oRBComponentBean = null;
        String string = null;
        AttributeList attributeList = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            controllable = this.getServerInstanceManager();
            serializable = ((ServerInstanceManager)controllable).getServerInstance(this.getInstanceOption());
            oRBComponentBean = serializable.getORBComponent();
            String string2 = this.findOption("listeneraddress").getValue();
            string = ((Operand)this.getOperands().get(0)).getName();
            attributeList = this.getAttributeList();
            oRBComponentBean.addIiopListener(string, string2);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateIIOPListener"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("CreatedIIOPListener", new Object[]{string}));
        try {
            if (attributeList != null && !attributeList.isEmpty()) {
                controllable = oRBComponentBean.getIiopListener(string);
                serializable = ((ServerComponent)controllable).setAttributes(attributeList);
                this.validateAttributeList(attributeList, (AttributeList)serializable);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        Serializable serializable;
        AttributeList attributeList = new AttributeList();
        if (this.findOption(IIOP_PORT) != null) {
            serializable = new Attribute("port", this.getIntegerOptionValue(IIOP_PORT));
            attributeList.add((Attribute)serializable);
        }
        if (this.findOption(ENABLED) != null) {
            serializable = new Attribute(ENABLED, this.getBooleanOptionValue(ENABLED));
            attributeList.add((Attribute)serializable);
        }
        if (!((Properties)(serializable = this.getProperties())).isEmpty()) {
            String string = "property.";
            Enumeration<?> enumeration = ((Properties)serializable).propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)((Properties)serializable).get(string2);
                Attribute attribute = new Attribute(string + string2, string3);
                attributeList.add(attribute);
                Debug.println("Property(name,value) = " + string2 + " , " + string3);
            }
        }
        return attributeList;
    }
}

