/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistryException;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.server.core.channel.RMIClient;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.IasCommand;
import com.iplanet.ias.tools.cli.PromptStream;
import com.iplanet.ias.tools.cli.framework.CliUtil;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.util.ExecException;
import com.iplanet.ias.util.OS;
import com.iplanet.ias.util.ProcessExecutor;
import com.iplanet.ias.util.StringUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseLifeCycleCommand
extends IasCommand {
    protected static final String LOCAL_HOST = "localhost";
    protected final String UNIX_START_COMMAND_NAME = "bin/startserv";
    protected final String WIN_START_COMMAND_NAME = "bin\\startserv.bat";
    protected static final String UNIX_STOP_COMMAND_NAME = "bin/stopserv";
    protected static final String WIN_STOP_COMMAND_NAME = "bin\\stopserv.bat";
    protected final String UNIX_RESTART_COMMAND_NAME = "bin/restartserv";
    protected final String WIN_RESTART_COMMAND_NAME = "bin\\restartserv.bat";
    protected static final String CONFIG_DIR_NAME = "config";
    protected static final String STUB_FILE_NAME = "admch";
    protected static final String SEED_FILE_NAME = "admsn";
    protected static final String ADMIN_SERVER = "admin-server";
    protected static final String DOMAIN = "domain";
    protected static final String DOMAIN_INSTANCE_DELIMETER = ":";
    protected static final String UNIX_GETTOKENS_COMMAND_NAME = "lib/gettokens";
    protected static final String UNIX_INIT_CONF_NAME = "config/init.conf";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$tools$cli$BaseLifeCycleCommand;

    public void startServerInstance(String string, String string2) throws CommandException {
        if (this.isInstanceAlreadyStarted(string, string2)) {
            this.printMessage(this.getLocalizedString("InstanceAlreadyStarted", new Object[]{string2}));
            return;
        }
        String string3 = this.getStartCommand(string, string2);
        if (!new File(string3).exists()) {
            throw new CommandException(this.getLocalizedString("StartScriptNotFound") + " " + string3);
        }
        try {
            Debug.println("Exec Command = " + string3);
            ProcessExecutor processExecutor = new ProcessExecutor(new String[]{string3});
            processExecutor.execute();
        }
        catch (ExecException execException) {
            String string4 = this.getLocalizedString("ServerFailedToStart") + ": " + execException.getMessage();
            throw new CommandException(string4);
        }
        catch (Exception exception) {
            String string5 = exception.getMessage();
            throw new CommandException(string5);
        }
    }

    public void startServerInstance(String string, String string2, String[] stringArray) throws CommandException {
        if (this.isInstanceAlreadyStarted(string, string2)) {
            this.printMessage(this.getLocalizedString("InstanceAlreadyStarted", new Object[]{string2}));
            return;
        }
        String string3 = this.getStartCommand(string, string2);
        String[] stringArray2 = null;
        stringArray2 = stringArray != null ? stringArray : new String[]{};
        try {
            Debug.println("Exec command = " + string3);
            ProcessExecutor processExecutor = new ProcessExecutor(new String[]{string3}, stringArray2);
            processExecutor.execute();
        }
        catch (ExecException execException) {
            String string4 = this.getLocalizedString("ServerFailedToStart") + ": " + execException.getMessage();
            throw new CommandException(string4);
        }
        catch (Exception exception) {
            String string5 = exception.getMessage();
            throw new CommandException(string5);
        }
    }

    public void startServerInstanceWithSecurityOn(String string, String string2) throws CommandException, CommandValidationException {
        String[] stringArray;
        String string3 = this.getDomainLocation(string);
        String[] stringArray2 = new String[]{string3, string2, CONFIG_DIR_NAME, "password.conf"};
        String string4 = StringUtils.makeFilePath(stringArray2, false);
        if (!this.checkForFileExistence(string4) && (stringArray = this.getTokens(string, string2)) != null && stringArray.length > 0) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("CannotGetPassword"));
            }
            String[] stringArray3 = this.getPasswords(stringArray, string2 + DOMAIN_INSTANCE_DELIMETER);
            this.startServerInstance(string, string2, stringArray3);
            return;
        }
        this.startServerInstance(string, string2);
    }

    public void stopServerInstance(String string, String string2) throws CommandException {
        if (!this.isInstanceAlreadyStarted(string, string2)) {
            this.printMessage(this.getLocalizedString("InstanceNotRunning", new Object[]{string2}));
            return;
        }
        String string3 = this.getStopCommand(string, string2);
        if (!new File(string3).exists()) {
            throw new CommandException(this.getLocalizedString("StopScriptNotFound") + " " + string3);
        }
        try {
            Debug.println("Exec Command = " + string3);
            ProcessExecutor processExecutor = new ProcessExecutor(new String[]{string3});
            processExecutor.execute();
        }
        catch (ExecException execException) {
            String string4 = this.getLocalizedString("ServerFailedToStop") + ": " + execException.getMessage();
            throw new CommandException(string4);
        }
        catch (Exception exception) {
            String string5 = exception.getMessage();
            throw new CommandException(string5);
        }
    }

    public void restartServerInstance(String string, String string2) throws CommandException {
        if (!this.isInstanceAlreadyStarted(string, string2)) {
            throw new CommandException(this.getLocalizedString("InstanceNotRunning", new Object[]{string2}));
        }
        String string3 = this.getRestartCommand(string, string2);
        if (!new File(string3).exists()) {
            throw new CommandException(this.getLocalizedString("RestartScriptNotFound") + " " + string3);
        }
        try {
            Debug.println("Exec Command = " + string3);
            ProcessExecutor processExecutor = new ProcessExecutor(new String[]{string3});
            processExecutor.execute();
        }
        catch (ExecException execException) {
            String string4 = this.getLocalizedString("ServerFailedToRestart") + ": " + execException.getMessage();
            throw new CommandException(string4);
        }
        catch (Exception exception) {
            String string5 = exception.getMessage();
            throw new CommandException(string5);
        }
    }

    protected boolean startDomain(String string) throws CommandException {
        String string2 = this.getDomainLocation(string);
        if (!new File(string2).exists()) {
            throw new CommandException(this.getLocalizedString("DomainLocationNotFound", new Object[]{string2}));
        }
        if (this.isAllInstancesInDomainStarted(string)) {
            this.printMessage(this.getLocalizedString("DomainAlreadyStarted", new Object[]{string}));
            return true;
        }
        String[] stringArray = new File(string2).list();
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            try {
                if (this.isInstanceAlreadyStarted(string, stringArray[n])) {
                    this.printMessage(this.getLocalizedString("InstanceAlreadyStarted", new Object[]{string + DOMAIN_INSTANCE_DELIMETER + stringArray[n]}));
                } else if (new File(string2 + File.separator + stringArray[n]).isDirectory()) {
                    if (OS.isUnix() && this.checkIfSecurityIsON(string, stringArray[n])) {
                        this.startServerInstanceWithSecurityOn(string, stringArray[n]);
                    } else {
                        this.startServerInstance(string, stringArray[n]);
                    }
                    this.printMessage(this.getLocalizedString("InstanceStarted", new Object[]{string + DOMAIN_INSTANCE_DELIMETER + stringArray[n]}));
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                Debug.println("Locally starting instance, Exception caught ");
                this.printMessage(this.getLocalizedString("CannotStartInstance") + ": " + string + DOMAIN_INSTANCE_DELIMETER + stringArray[n]);
                this.printError(exception.getLocalizedMessage());
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    protected boolean stopDomain(String string, boolean bl) throws CommandException {
        String string2 = this.getDomainLocation(string);
        if (!new File(string2).exists()) {
            throw new CommandException(this.getLocalizedString("DomainRootNotFound", new Object[]{string2}));
        }
        if (!this.isAnyInstanceInDomainStarted(string)) {
            this.printMessage(this.getLocalizedString("DomainAlreadyStopped", new Object[]{string}));
            return true;
        }
        String[] stringArray = new File(string2).list();
        boolean bl2 = true;
        int n = 0;
        while (n < stringArray.length) {
            try {
                if (bl || !stringArray[n].equals(ADMIN_SERVER)) {
                    if (!this.isInstanceAlreadyStarted(string, stringArray[n])) {
                        this.printMessage(this.getLocalizedString("InstanceNotRunning", new Object[]{string + DOMAIN_INSTANCE_DELIMETER + stringArray[n]}));
                    } else if (new File(string2 + File.separator + stringArray[n]).isDirectory()) {
                        this.stopServerInstance(string, stringArray[n]);
                        this.printMessage(this.getLocalizedString("InstanceStopped", new Object[]{string + DOMAIN_INSTANCE_DELIMETER + stringArray[n]}));
                    }
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                Debug.println("Locally stopping instance, Exception caught ");
                this.printMessage(this.getLocalizedString("CannotStopInstance") + ": " + string + DOMAIN_INSTANCE_DELIMETER + stringArray[n]);
                this.printError(exception.getLocalizedMessage());
                bl2 = false;
            }
            ++n;
        }
        return bl2;
    }

    protected String[] getAllDomains() throws CommandException {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        try {
            DomainRegistry domainRegistry = DomainRegistry.newInstance();
            Iterator iterator = domainRegistry.iterator();
            while (iterator.hasNext()) {
                DomainEntry domainEntry = (DomainEntry)iterator.next();
                vector.addElement(domainEntry.getName());
            }
            stringArray = new String[vector.size()];
            stringArray = vector.toArray(stringArray);
        }
        catch (DomainRegistryException domainRegistryException) {
            throw new CommandException(domainRegistryException.getMessage());
        }
        return stringArray;
    }

    protected String getDomain() throws CommandException {
        String string = this.getOptionValue(DOMAIN);
        if (string == null) {
            String[] stringArray = this.getAllDomains();
            if (stringArray == null || stringArray.length < 1) {
                throw new CommandException(this.getLocalizedString("NoDomains"));
            }
            if (stringArray.length > 1) {
                throw new CommandException(this.getLocalizedString("NoDefaultDomain"));
            }
            string = stringArray[0];
        }
        return string;
    }

    public String getStartCommand(String string, String string2) throws CommandException {
        String string3 = null;
        if (OS.isWindows()) {
            string3 = "bin\\startserv.bat";
        } else if (OS.isUnix()) {
            string3 = "bin/startserv";
        } else {
            throw new IllegalArgumentException();
        }
        String string4 = this.getDomainLocation(string);
        String[] stringArray = new String[]{string4, string2, string3};
        String string5 = StringUtils.makeFilePath(stringArray, false);
        Debug.println("start command path = " + string5);
        return string5;
    }

    public String getStopCommand(String string, String string2) throws CommandException {
        String string3 = null;
        if (OS.isWindows()) {
            string3 = WIN_STOP_COMMAND_NAME;
        } else if (OS.isUnix()) {
            string3 = UNIX_STOP_COMMAND_NAME;
        } else {
            throw new IllegalArgumentException();
        }
        String string4 = this.getDomainLocation(string);
        String[] stringArray = new String[]{string4, string2, string3};
        String string5 = StringUtils.makeFilePath(stringArray, false);
        Debug.println("stop command path = " + string5);
        return string5;
    }

    protected String getStubFilePath(String string, String string2) throws CommandException {
        String string3 = this.getDomainLocation(string);
        String[] stringArray = new String[]{string3, string2, CONFIG_DIR_NAME, STUB_FILE_NAME};
        String string4 = StringUtils.makeFilePath(stringArray, false);
        Debug.println("stub file path = " + string4);
        return string4;
    }

    protected String getSeedFilePath(String string, String string2) throws CommandException {
        String string3 = this.getDomainLocation(string);
        String[] stringArray = new String[]{string3, string2, CONFIG_DIR_NAME, SEED_FILE_NAME};
        String string4 = StringUtils.makeFilePath(stringArray, false);
        Debug.println("seed file path = " + string4);
        return string4;
    }

    protected boolean isInstanceAlreadyStarted(String string, String string2) throws CommandException {
        String string3 = this.getStubFilePath(string, string2);
        String string4 = this.getSeedFilePath(string, string2);
        File file = new File(string3);
        File file2 = file.getParentFile();
        String[] stringArray = file2.list();
        if (stringArray == null) {
            String string5 = file.getParent();
            throw new CommandException(this.getLocalizedString("CannotAccessFile", new Object[]{string5}));
        }
        RMIClient rMIClient = new RMIClient(true, string3, string4);
        int n = rMIClient.getInstanceStatusCode();
        return n == 0;
    }

    protected boolean isInstanceExists(String string, String string2) throws CommandException {
        String string3 = this.getDomainLocation(string);
        String[] stringArray = new File(string3).list();
        Vector<String> vector = new Vector<String>(Arrays.asList(stringArray));
        return vector.contains(string2);
    }

    protected boolean isAnyInstanceInDomainStarted(String string) throws CommandException {
        String string2 = this.getDomainLocation(string);
        String[] stringArray = new File(string2).list();
        int n = 0;
        while (n < stringArray.length) {
            if (this.isInstanceAlreadyStarted(string, stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isAllInstancesInDomainStarted(String string) throws CommandException {
        String string2 = this.getDomainLocation(string);
        String[] stringArray = new File(string2).list();
        int n = 0;
        while (n < stringArray.length) {
            if (!this.isInstanceAlreadyStarted(string, stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getRestartCommand(String string, String string2) throws CommandException {
        String string3 = null;
        if (OS.isWindows()) {
            string3 = "bin\\restartserv.bat";
        } else if (OS.isUnix()) {
            string3 = "bin/restartserv";
        } else {
            throw new IllegalArgumentException();
        }
        String string4 = this.getDomainLocation(string);
        String[] stringArray = new String[]{string4, string2, string3};
        String string5 = StringUtils.makeFilePath(stringArray, false);
        Debug.println("restart command path = " + string5);
        return string5;
    }

    protected String getDomainLocation(String string) throws CommandException {
        try {
            DomainRegistry domainRegistry = DomainRegistry.newInstance();
            DomainEntry domainEntry = domainRegistry.getDomain(string);
            if (domainEntry == null) {
                throw new CommandException(this.getLocalizedString("NotARegisteredDomain", new Object[]{string}));
            }
            return domainEntry.getRoot().getAbsolutePath();
        }
        catch (DomainRegistryException domainRegistryException) {
            Debug.printStackTrace(domainRegistryException);
            throw new CommandException(domainRegistryException.getLocalizedMessage());
        }
    }

    protected DomainEntry[] getDomainEntries() throws DomainRegistryException, CommandValidationException, AFException {
        DomainEntry[] domainEntryArray = null;
        if (this.isLocal()) {
            domainEntryArray = this.getLocalDomainEntries();
        } else {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            domainEntryArray = serverInstanceManager.listDomains();
        }
        return domainEntryArray;
    }

    private DomainEntry[] getLocalDomainEntries() throws DomainRegistryException {
        DomainRegistry domainRegistry = DomainRegistry.newInstance();
        int n = domainRegistry.size();
        DomainEntry[] domainEntryArray = new DomainEntry[n];
        Iterator iterator = domainRegistry.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            domainEntryArray[n2++] = (DomainEntry)iterator.next();
        }
        if (!$assertionsDisabled && n != n2) {
            throw new AssertionError();
        }
        return domainEntryArray;
    }

    protected void unsetLicenseLogger() {
        Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.core");
        logger.setLevel(Level.OFF);
    }

    protected String[] getTokens(String string, String string2) throws CommandException, CommandValidationException {
        String string3 = this.getDomainLocation(string);
        String[] stringArray = new String[]{System.getProperty("com.sun.aas.installRoot"), UNIX_GETTOKENS_COMMAND_NAME};
        String string4 = StringUtils.makeFilePath(stringArray, false);
        if (this.checkForFileExistence(string4)) {
            String[] stringArray2 = new String[]{string4, string2, string3};
            try {
                Debug.println("Exec Command = " + stringArray2[0]);
                ProcessExecutor processExecutor = new ProcessExecutor(stringArray2);
                String[] stringArray3 = processExecutor.execute(true);
                return stringArray3;
            }
            catch (Exception exception) {
                Debug.println("Exception occured");
                Debug.println(exception.getMessage());
                return null;
            }
        }
        throw new CommandValidationException(this.getLocalizedString("FileNotFound", new Object[]{string4}));
    }

    protected String[] getPasswords(String[] stringArray, String string) {
        PromptStream promptStream = new PromptStream(System.in, System.out);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray2.length) {
            try {
                CliUtil cliUtil = new CliUtil();
                this.printPrompt(this.getLocalizedString("PasswordPrefix") + string + stringArray[n]);
                stringArray2[n] = cliUtil.getPassword();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                String string2 = unsatisfiedLinkError.getLocalizedMessage();
                Debug.println(string2);
                stringArray2[n] = promptStream.readln(stringArray[n]);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                String string3 = noClassDefFoundError.getLocalizedMessage();
                if (string3 != null) {
                    Debug.println(string3);
                }
                stringArray2[n] = promptStream.readln(stringArray[n]);
            }
            ++n;
        }
        return stringArray2;
    }

    protected boolean checkIfSecurityIsON(String string, String string2) throws CommandException, CommandValidationException {
        String string3 = this.getDomainLocation(string);
        String[] stringArray = new String[]{string3, string2, UNIX_INIT_CONF_NAME};
        String string4 = StringUtils.makeFilePath(stringArray, false);
        if (this.checkForFileExistence(string4)) {
            try {
                String string5;
                File file = new File(string4);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string5 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string5);
                    if (!stringTokenizer.nextToken().equals("Security")) continue;
                    return stringTokenizer.nextToken().equals("on");
                }
                return false;
            }
            catch (IOException iOException) {
                throw new CommandException(iOException.getMessage());
            }
        }
        throw new CommandValidationException(this.getLocalizedString("FileNotFound", new Object[]{string4}));
    }

    protected String[] getInstanceList(File file, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file == null || !file.exists() || !file.isDirectory()) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (fileArray[n2].isDirectory()) {
                boolean bl2 = true;
                if (!bl && ADMIN_SERVER.equals(fileArray[n2].getName())) {
                    bl2 = false;
                }
                if (bl2) {
                    arrayList.add(fileArray[n2].getName());
                }
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected int getInstanceCount(File file, boolean bl) {
        String[] stringArray = this.getInstanceList(file, bl);
        return stringArray == null ? 0 : stringArray.length;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$tools$cli$BaseLifeCycleCommand == null ? (class$com$iplanet$ias$tools$cli$BaseLifeCycleCommand = BaseLifeCycleCommand.class$("com.iplanet.ias.tools.cli.BaseLifeCycleCommand")) : class$com$iplanet$ias$tools$cli$BaseLifeCycleCommand).desiredAssertionStatus();
    }
}

