/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.EntityStatus;
import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFOtherException;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.ComponentController;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DeployedApplicationComponentController
implements ComponentController {
    private static final String IS_ENABLED = "isEnabled";
    private static final String ENABLE_APPLICATION = "enable";
    private static final String DISABLE_APPLICATION = "disable";
    private static final String GET_STATUS = "getStatus";
    private static final String GET_ALL_MODULES = "getModules";
    private static final String GET_EJB_MODULES = "getEjbModules";
    private static final String GET_WEB_MODULES = "getWebModules";
    private DeployedApplicationComponentBean deployedApp;

    public DeployedApplicationComponentController(DeployedApplicationComponentBean deployedApplicationComponentBean) {
        this.deployedApp = deployedApplicationComponentBean;
    }

    public boolean isEnabled() throws AFException {
        EntityStatus entityStatus = this.getEntityStatus();
        return entityStatus.getStatusCode() == 4;
    }

    public boolean enable() throws AFException {
        this.invoke(ENABLE_APPLICATION, null, null);
        return true;
    }

    public boolean disable() throws AFException {
        this.invoke(DISABLE_APPLICATION, null, null);
        return true;
    }

    public String getStatus() throws AFException {
        EntityStatus entityStatus = this.getEntityStatus();
        String string = entityStatus.getStatusString();
        return string;
    }

    public ServerModelIterator getEJBModules() throws AFException {
        Vector<DeployedEJBModuleComponentBean> vector = new Vector<DeployedEJBModuleComponentBean>();
        String[] stringArray = (String[])this.invoke(GET_EJB_MODULES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                String string;
                String string2 = this.deployedApp.getInstanceName();
                ObjectName objectName = ObjectNames.getEjbModuleObjectName(string2, stringArray[n], string = this.deployedApp.getAppName());
                Assert.assertit(objectName != null, "null value returned");
                Debug.println("DeployedApplicationComponentBean.getEjbModules: mbeanName = " + objectName);
                DeployedEJBModuleComponentBean deployedEJBModuleComponentBean = new DeployedEJBModuleComponentBean(objectName.toString(), stringArray[n], false);
                deployedEJBModuleComponentBean.setContextHolder(this.deployedApp.getContextHolder());
                vector.add(deployedEJBModuleComponentBean);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public ServerModelIterator getWebModules() throws AFException {
        Vector<DeployedWebModuleComponentBean> vector = new Vector<DeployedWebModuleComponentBean>();
        String[] stringArray = (String[])this.invoke(GET_WEB_MODULES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                String string;
                String string2 = this.deployedApp.getInstanceName();
                ObjectName objectName = ObjectNames.getWebModuleObjectName(string2, stringArray[n], string = this.deployedApp.getAppName());
                Assert.assertit(objectName != null, "null value returned");
                Debug.println("DeployedApplicationComponentBean.getWebModules: mbeanName = " + objectName);
                DeployedWebModuleComponentBean deployedWebModuleComponentBean = new DeployedWebModuleComponentBean(objectName.toString(), stringArray[n], false);
                deployedWebModuleComponentBean.setContextHolder(this.deployedApp.getContextHolder());
                vector.add(deployedWebModuleComponentBean);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public String[] getAllModules() throws AFException {
        String[] stringArray = (String[])this.invoke(GET_ALL_MODULES, null, null);
        return stringArray;
    }

    public ServerModelIterator getConnectorModules() throws AFException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerComponent[] getSubComponents() {
        throw new UnsupportedOperationException("To be implemented");
    }

    private EntityStatus getEntityStatus() throws AFException {
        Object object = this.invoke(GET_STATUS, null, null);
        EntityStatus entityStatus = (EntityStatus)object;
        Assert.assertit(entityStatus != null, "null value returned");
        return entityStatus;
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        Object object = null;
        try {
            ObjectName objectName = new ObjectName(this.deployedApp.getIdentifier());
            ContextHolder contextHolder = this.deployedApp.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            object = sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AFOtherException(malformedObjectNameException);
        }
        return object;
    }
}

