/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.beans.AuthDb;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.VirtualServerController;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class VirtualServer
extends ServerComponent
implements Serializable {
    private transient VirtualServerController controller = new VirtualServerController(this);
    private static final String DELIMITER = ",";

    public VirtualServer(String string, String string2) {
        super(string, string2);
    }

    public Controller getController() {
        return this.controller;
    }

    public boolean isHttpQosCreated() throws AFException {
        return this.controller.isHttpQosCreated();
    }

    public void createHttpQos() throws AFException {
        this.controller.createHttpQos();
    }

    public void removeHttpQos() throws AFException {
        this.controller.removeHttpQos();
    }

    public void createAuthDb(String string, String string2) throws AFException {
        this.controller.createAuthDb(string, string2);
    }

    public void removeAuthDb(String string) throws AFException {
        this.controller.removeAuthDb(string);
    }

    public ServerModelIterator getAuthDbs() throws AFException {
        return this.controller.getAuthDbs();
    }

    public AuthDb getAuthDb(String string) {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        String string2 = this.getInstanceName();
        String string3 = this.getVirtualServerClassId();
        String string4 = this.getVirtualServerId();
        ObjectName objectName = ObjectNames.getVirtualServerAuthDBObjectName(string2, string3, string4, string);
        Assert.assertit(objectName != null, "null value returned");
        Debug.println("VirtualServer.getAuthDb: mbeanName = " + objectName);
        AuthDb authDb = new AuthDb(objectName.toString(), string);
        authDb.setContextHolder(this.getContextHolder());
        return authDb;
    }

    public String getInstanceName() {
        String string = null;
        try {
            String string2 = this.getIdentifier();
            ObjectName objectName = new ObjectName(string2);
            string = objectName.getKeyProperty("instance-name");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return string;
    }

    public String getVirtualServerClassId() {
        String string = null;
        try {
            String string2 = this.getIdentifier();
            ObjectName objectName = new ObjectName(string2);
            string = objectName.getKeyProperty("virtual-server-class-id");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return string;
    }

    public String getVirtualServerId() {
        String string = null;
        try {
            String string2 = this.getIdentifier();
            ObjectName objectName = new ObjectName(string2);
            string = objectName.getKeyProperty("name");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return string;
    }

    public AttributeList setAttributes(AttributeList attributeList) throws AttributeNotFoundException, AFException {
        AttributeList attributeList2 = super.setAttributes(attributeList);
        String string = (String)this.getAttribute("defaultWebModule");
        int n = string.indexOf(":");
        if (n == -1) {
            this.updateWebModule(string);
        } else if (n > 0) {
            String string2 = string.substring(0, n);
            this.updateJ2EEApplication(string2);
        }
        return attributeList2;
    }

    public void setAttribute(String string, Object object) throws AttributeNotFoundException, InvalidAttributeValueException, AccessViolationException, AFTargetNotFoundException {
        if (string.equals("defaultWebModule") && !((String)object).equals(this.getAttribute("defaultWebModule"))) {
            this.updateWebModule((String)object);
        }
        super.setAttribute(string, object);
    }

    private void updateWebModule(String string) throws AttributeNotFoundException, InvalidAttributeValueException, AccessViolationException, AFTargetNotFoundException {
        String string2;
        String[] stringArray;
        DeployedWebModuleComponentBean deployedWebModuleComponentBean;
        boolean bl = false;
        String string3 = this.getVirtualServerId();
        if (string != null && !string.equals("") && (deployedWebModuleComponentBean = this.getWebModule(string)) != null && (stringArray = this.getArrayFromCommaSeparatedList(string2 = (String)deployedWebModuleComponentBean.getAttribute("virtualServers"))) != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string3)) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                String string4 = this.getVirtualServerId() + DELIMITER + string2;
                deployedWebModuleComponentBean.setAttribute("virtualServers", string4);
            }
        }
    }

    private DeployedWebModuleComponentBean getWebModule(String string) {
        ArgChecker.checkValid(string, "moduleName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getWebModuleObjectName(this.getInstanceName(), string);
        Assert.assertit(objectName != null, "null value returned");
        DeployedWebModuleComponentBean deployedWebModuleComponentBean = new DeployedWebModuleComponentBean(objectName.toString(), string, true);
        deployedWebModuleComponentBean.setContextHolder(this.getContextHolder());
        return deployedWebModuleComponentBean;
    }

    private void updateJ2EEApplication(String string) throws AttributeNotFoundException, InvalidAttributeValueException, AccessViolationException, AFTargetNotFoundException {
        String string2;
        String[] stringArray;
        DeployedApplicationComponentBean deployedApplicationComponentBean;
        boolean bl = false;
        String string3 = this.getVirtualServerId();
        if (string != null && !string.equals("") && (deployedApplicationComponentBean = this.getJ2EEApplication(string)) != null && (stringArray = this.getArrayFromCommaSeparatedList(string2 = (String)deployedApplicationComponentBean.getAttribute("virtualServers"))) != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string3)) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                String string4 = this.getVirtualServerId() + DELIMITER + string2;
                deployedApplicationComponentBean.setAttribute("virtualServers", string4);
            }
        }
    }

    private DeployedApplicationComponentBean getJ2EEApplication(String string) {
        ArgChecker.checkValid(string, "moduleName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getApplicationObjectName(this.getInstanceName(), string);
        Assert.assertit(objectName != null, "null value returned");
        DeployedApplicationComponentBean deployedApplicationComponentBean = new DeployedApplicationComponentBean(objectName.toString(), string);
        deployedApplicationComponentBean.setContextHolder(this.getContextHolder());
        return deployedApplicationComponentBean;
    }

    private String[] getArrayFromCommaSeparatedList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }
}

