/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.ServerInstanceStatus;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFResourceException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.DeploymentException;
import com.iplanet.ias.admin.common.exception.InstanceAlreadyRunningException;
import com.iplanet.ias.admin.common.exception.InstanceNotRunningException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.beans.CustomResource;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedConnectorComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.JDBCConnectionPool;
import com.iplanet.ias.admin.servermodel.beans.JDBCResource;
import com.iplanet.ias.admin.servermodel.beans.JMSComponentBean;
import com.iplanet.ias.admin.servermodel.beans.JMSResource;
import com.iplanet.ias.admin.servermodel.beans.JNDIResource;
import com.iplanet.ias.admin.servermodel.beans.JTAComponentBean;
import com.iplanet.ias.admin.servermodel.beans.JVMComponentBean;
import com.iplanet.ias.admin.servermodel.beans.JavaMailResource;
import com.iplanet.ias.admin.servermodel.beans.LifeCycleModule;
import com.iplanet.ias.admin.servermodel.beans.ORBComponentBean;
import com.iplanet.ias.admin.servermodel.beans.PersistenceManagerFactoryResource;
import com.iplanet.ias.admin.servermodel.beans.SecurityServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.beans.ServiceComponentBean;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.AppServerInstanceController;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AppServerInstance
implements Controllable,
Serializable {
    private final String name;
    private HostAndPort hostAndPort;
    private ContextHolder contextHolder;
    private transient AppServerInstanceController controller;

    public AppServerInstance(String string) {
        ArgChecker.checkValid(string, "name", StringValidator.getInstance());
        this.name = string;
        this.contextHolder = new ContextHolder();
        this.controller = new AppServerInstanceController(this);
    }

    public AppServerInstance(HostAndPort hostAndPort, String string) {
        this(string);
        ArgChecker.checkValid(hostAndPort, "hAndp");
        this.hostAndPort = hostAndPort;
    }

    public void setContextHolder(ContextHolder contextHolder) {
        this.contextHolder = contextHolder;
    }

    public ContextHolder getContextHolder() {
        return this.contextHolder;
    }

    public String getName() {
        return this.name;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AppServerInstance) {
            AppServerInstance appServerInstance = (AppServerInstance)object;
            return this.hostAndPort.equals(appServerInstance.hostAndPort) && this.name.equals(appServerInstance.name);
        }
        return false;
    }

    public String toString() {
        String string = this.name;
        if (this.hostAndPort != null) {
            string = string + '[' + this.hostAndPort.toString() + ']';
        }
        return string;
    }

    public Controller getController() {
        return this.controller;
    }

    public boolean isRunning() throws AFException {
        return this.controller.isRunning();
    }

    public int startInDebugMode() throws AFTargetNotFoundException, ControlException {
        return this.controller.startInDebugMode();
    }

    public int startSecureInDebugMode(String[] stringArray) throws AFTargetNotFoundException, ControlException {
        return this.controller.startSecureInDebugMode(stringArray);
    }

    public boolean stop() throws AFTargetNotFoundException, InstanceNotRunningException, ControlException {
        return this.controller.stop();
    }

    public boolean restart() throws AFTargetNotFoundException, ControlException {
        return this.controller.restart();
    }

    public boolean start() throws InstanceAlreadyRunningException, AFTargetNotFoundException, ControlException {
        return this.controller.start();
    }

    public String[] getSecurityPasswordTokens() throws AFException {
        return this.controller.getSecurityPasswordTokens();
    }

    public boolean startSecure(String[] stringArray) throws InstanceAlreadyRunningException, AFTargetNotFoundException, ControlException {
        return this.controller.startSecure(stringArray);
    }

    public String getStatus() throws AFException {
        return this.controller.getStatus();
    }

    public ServerInstanceStatus getServerStatus() throws AFException {
        return (ServerInstanceStatus)this.controller.getServerStatus();
    }

    public boolean deployApplication(String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4) throws DeploymentException {
        return this.controller.deployApplication(string, string2, bl, string3, bl2, bl3, bl4, true);
    }

    public boolean deployApplication(String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws DeploymentException {
        return this.controller.deployApplication(string, string2, bl, string3, bl2, bl3, bl4, bl5);
    }

    public boolean deployApplicationDirectory(String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4) throws DeploymentException {
        return this.controller.deployApplicationDirectory(string, string2, bl, string3, bl2, bl3, bl4);
    }

    public boolean undeployApplication(String string) throws DeploymentException {
        return this.controller.undeployApplication(string);
    }

    public boolean redeployApplication(String string, String string2) throws DeploymentException {
        return this.controller.redeployApplication(string, string2);
    }

    public boolean deployModule(String string, String string2) throws DeploymentException {
        return this.controller.deployModule(string, string2);
    }

    public boolean deployModule(String string) throws DeploymentException {
        return this.controller.deployModule(string);
    }

    public boolean deployEJBJarModule(String string, String string2) throws DeploymentException {
        return this.controller.deployEJBJarModule(string, string2);
    }

    public boolean deployEJBJarModule(String string, String string2, boolean bl) throws DeploymentException {
        return this.controller.deployEJBJarModule(string, string2, bl, false, true);
    }

    public boolean deployEJBJarModule(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        return this.controller.deployEJBJarModule(string, string2, bl, bl2, true);
    }

    public boolean deployEJBJarModule(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws DeploymentException {
        return this.controller.deployEJBJarModule(string, string2, bl, bl2, bl3);
    }

    public boolean deployEJBJarModuleDirectory(String string, String string2, boolean bl) throws DeploymentException {
        return this.controller.deployEJBJarModuleDirectory(string, string2, bl, false);
    }

    public boolean deployEJBJarModuleDirectory(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        return this.controller.deployEJBJarModuleDirectory(string, string2, bl, bl2);
    }

    public boolean redeployEJBJarModule(String string, String string2) throws DeploymentException {
        return this.controller.redeployEJBJarModule(string, string2);
    }

    public boolean deployWarModule(String string, String string2, String string3, boolean bl, String string4, boolean bl2, boolean bl3, boolean bl4) throws DeploymentException {
        return this.controller.deployWarModule(string, string2, string3, bl, string4, bl2, bl3, bl4, true);
    }

    public boolean deployWarModule(String string, String string2, String string3, boolean bl, String string4, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws DeploymentException {
        return this.controller.deployWarModule(string, string2, string3, bl, string4, bl2, bl3, bl4, bl5);
    }

    public boolean deployWarModuleDirectory(String string, String string2, String string3, boolean bl, String string4, boolean bl2, boolean bl3, boolean bl4) throws DeploymentException {
        return this.controller.deployWarModuleDirectory(string, string2, string3, bl, string4, bl2, bl3, bl4);
    }

    public boolean redeployWarModule(String string, String string2, String string3) throws DeploymentException {
        return this.controller.redeployWarModule(string, string2, string3);
    }

    public boolean deployConnectorModule(String string, String string2) throws DeploymentException {
        return this.controller.deployConnectorModule(string, string2);
    }

    public boolean deployConnectorModule(String string, String string2, boolean bl) throws DeploymentException {
        return this.controller.deployConnectorModule(string, string2, bl, false, true);
    }

    public boolean deployConnectorModule(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        return this.controller.deployConnectorModule(string, string2, bl, bl2, true);
    }

    public boolean deployConnectorModule(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws DeploymentException {
        return this.controller.deployConnectorModule(string, string2, bl, bl2, bl3);
    }

    public boolean deployConnectorModuleDirectory(String string, String string2, boolean bl) throws DeploymentException {
        return this.controller.deployConnectorModuleDirectory(string, string2, bl, false);
    }

    public boolean deployConnectorModuleDirectory(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        return this.controller.deployConnectorModuleDirectory(string, string2, bl, bl2);
    }

    public boolean redeployConnectorModule(String string, String string2) throws DeploymentException {
        return this.controller.redeployConnectorModule(string, string2);
    }

    public boolean undeployModule(String string, int n) throws DeploymentException {
        return this.controller.undeployModule(string, n);
    }

    public boolean undeployModuleInApplication(String string, String string2) throws DeploymentException {
        return this.controller.undeployModuleInApplication(string, string2);
    }

    public ServerModelIterator getDeployedApplications() throws AFException {
        return this.controller.getDeployedApplications();
    }

    public DeployedApplicationComponentBean getDeployedApplication(String string) {
        ArgChecker.checkValid(string, "appname", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getApplicationObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        DeployedApplicationComponentBean deployedApplicationComponentBean = new DeployedApplicationComponentBean(objectName.toString(), string);
        deployedApplicationComponentBean.setContextHolder(this.getContextHolder());
        return deployedApplicationComponentBean;
    }

    public ServerModelIterator getDeployedModules() {
        return this.controller.getDeployedModules();
    }

    public ServerModelIterator getDeployedEJBModules() throws AFException {
        return this.controller.getDeployedEJBModules();
    }

    public ServerModelIterator getDeployedWebModules() throws AFException {
        return this.controller.getDeployedWebModules();
    }

    public ServerModelIterator getDeployedConnectors() throws AFException {
        return this.controller.getDeployedConnectors();
    }

    public DeployedEJBModuleComponentBean getDeployedEJBModule(String string) {
        ArgChecker.checkValid(string, "moduleName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getEjbModuleObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        DeployedEJBModuleComponentBean deployedEJBModuleComponentBean = new DeployedEJBModuleComponentBean(objectName.toString(), string, true);
        deployedEJBModuleComponentBean.setContextHolder(this.getContextHolder());
        return deployedEJBModuleComponentBean;
    }

    public DeployedWebModuleComponentBean getDeployedWebModule(String string) {
        ArgChecker.checkValid(string, "moduleName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getWebModuleObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        DeployedWebModuleComponentBean deployedWebModuleComponentBean = new DeployedWebModuleComponentBean(objectName.toString(), string, true);
        deployedWebModuleComponentBean.setContextHolder(this.getContextHolder());
        return deployedWebModuleComponentBean;
    }

    public DeployedConnectorComponentBean getDeployedConnector(String string) {
        ArgChecker.checkValid(string, "moduleName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getConnectorModuleObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        DeployedConnectorComponentBean deployedConnectorComponentBean = new DeployedConnectorComponentBean(objectName.toString(), string, true);
        deployedConnectorComponentBean.setContextHolder(this.getContextHolder());
        return deployedConnectorComponentBean;
    }

    public DeployedModuleComponentBean getDeployedModule(String string) {
        DeployedModuleComponentBean deployedModuleComponentBean = null;
        int n = this.controller.getModuleType(string);
        ObjectName objectName = ObjectNames.getModuleObjectName(this.name, string);
        if (n == 0) {
            deployedModuleComponentBean = new DeployedEJBModuleComponentBean(objectName.toString(), string, true);
        } else if (n == 1) {
            deployedModuleComponentBean = new DeployedWebModuleComponentBean(objectName.toString(), string, true);
        }
        if (deployedModuleComponentBean != null) {
            deployedModuleComponentBean.setContextHolder(this.getContextHolder());
        }
        return deployedModuleComponentBean;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, AccessViolationException, AFTargetNotFoundException {
        return this.controller.getAttribute(string);
    }

    public void setAttribute(String string, Object object) throws AttributeNotFoundException, AccessViolationException, InvalidAttributeValueException, AFTargetNotFoundException {
        this.controller.setAttribute(string, object);
    }

    public AttributeList getAttributes(String[] stringArray) throws AFException {
        return this.controller.getAttributes(stringArray);
    }

    public AttributeList setAttributes(AttributeList attributeList) throws AFException {
        return this.controller.setAttributes(attributeList);
    }

    public Object getDefaultAttributeValue(String string) throws AFException {
        return this.controller.getDefaultAttributeValue(string);
    }

    public void reconfig() {
        this.controller.reconfig();
    }

    public void backupConfig() {
        this.controller.backupConfig();
    }

    public void restoreConfig() {
        this.controller.restoreConfig();
    }

    public ServiceComponentBean getWebContainer() {
        ObjectName objectName = ObjectNames.getWebContainerObjectName(this.name);
        Assert.assertit(objectName != null, "null value returned");
        ServiceComponentBean serviceComponentBean = new ServiceComponentBean(objectName.toString(), "Web container");
        serviceComponentBean.setContextHolder(this.getContextHolder());
        return serviceComponentBean;
    }

    public ServiceComponentBean getEjbContainer() {
        ObjectName objectName = ObjectNames.getEjbContainerObjectName(this.name);
        Assert.assertit(objectName != null, "null value returned");
        ServiceComponentBean serviceComponentBean = new ServiceComponentBean(objectName.toString(), "Ejb container");
        serviceComponentBean.setContextHolder(this.getContextHolder());
        return serviceComponentBean;
    }

    public ServiceComponentBean getMdbContainer() {
        ObjectName objectName = ObjectNames.getMdbContainerObjectName(this.name);
        Assert.assertit(objectName != null, "null value returned");
        ServiceComponentBean serviceComponentBean = new ServiceComponentBean(objectName.toString(), "Mdb container");
        serviceComponentBean.setContextHolder(this.getContextHolder());
        return serviceComponentBean;
    }

    public ServiceComponentBean getLogService() {
        ObjectName objectName = ObjectNames.getLogServiceObjectName(this.name);
        Assert.assertit(objectName != null, "null value returned");
        ServiceComponentBean serviceComponentBean = new ServiceComponentBean(objectName.toString(), "Log Service");
        serviceComponentBean.setContextHolder(this.getContextHolder());
        return serviceComponentBean;
    }

    public ORBComponentBean getORBComponent() {
        ObjectName objectName = ObjectNames.getORBObjectName(this.name);
        Assert.assertit(objectName != null, "null value returned");
        ORBComponentBean oRBComponentBean = new ORBComponentBean(objectName.toString());
        oRBComponentBean.setContextHolder(this.getContextHolder());
        return oRBComponentBean;
    }

    public void retrieveApplication(String string, File file) throws IOException {
        this.controller.retrieveApplication(string, file);
    }

    public void retrieveModule(String string, File file) throws IOException {
        this.controller.retrieveModule(string, file);
    }

    public Iterator getServerComponents() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerComponent getServerComponent(String string) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void createResource(String string) throws AFResourceException {
        this.controller.createResource(string);
    }

    public void createJDBCConnectionPool(String string, String string2) throws AFResourceException {
        this.controller.createJDBCConnectionPool(string, string2);
    }

    public void deleteJDBCConnectionPool(String string) throws AFResourceException {
        this.controller.deleteJDBCConnectionPool(string);
    }

    public JDBCConnectionPool getJDBCConnectionPool(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "poolId", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getJDBCConnectionPoolObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        JDBCConnectionPool jDBCConnectionPool = new JDBCConnectionPool(objectName.toString(), string);
        jDBCConnectionPool.setContextHolder(this.getContextHolder());
        return jDBCConnectionPool;
    }

    public ServerModelIterator getJDBCConnectionPools() throws AFException {
        return this.controller.getJDBCConnectionPools();
    }

    public void createJDBCResource(String string, String string2) throws AFResourceException {
        this.controller.createJDBCResource(string, string2);
    }

    public void deleteJDBCResource(String string) throws AFResourceException {
        this.controller.deleteJDBCResource(string);
    }

    public JDBCResource getJDBCResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getJDBCResourceObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        JDBCResource jDBCResource = new JDBCResource(objectName.toString(), string);
        jDBCResource.setContextHolder(this.getContextHolder());
        return jDBCResource;
    }

    public ServerModelIterator getJDBCResources() throws AFException {
        return this.controller.getJDBCResources();
    }

    public void createJMSResource(String string, String string2) throws AFResourceException {
        this.controller.createJMSResource(string, string2);
    }

    public void deleteJMSResource(String string) throws AFResourceException {
        this.controller.deleteJMSResource(string);
    }

    public JMSResource getJMSResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getJMSResourceObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        JMSResource jMSResource = new JMSResource(objectName.toString(), string);
        jMSResource.setContextHolder(this.getContextHolder());
        return jMSResource;
    }

    public ServerModelIterator getJMSResources() throws AFException {
        return this.controller.getJMSResources();
    }

    public ServerModelIterator getJMSDestObjs() throws AFException {
        return this.controller.getJMSDestResources();
    }

    public ServerModelIterator getJMSConnObjs() throws AFException {
        return this.controller.getJMSConnResources();
    }

    public void createJNDIResource(String string, String string2, String string3, String string4) throws AFResourceException {
        this.controller.createJNDIResource(string, string2, string3, string4);
    }

    public void deleteJNDIResource(String string) throws AFResourceException {
        this.controller.deleteJNDIResource(string);
    }

    public JNDIResource getJNDIResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getJNDIResourceObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        JNDIResource jNDIResource = new JNDIResource(objectName.toString(), string);
        jNDIResource.setContextHolder(this.getContextHolder());
        return jNDIResource;
    }

    public ServerModelIterator getJNDIResources() throws AFException {
        return this.controller.getJNDIResources();
    }

    public void createJavaMailResource(String string, String string2, String string3, String string4) throws AFResourceException {
        this.controller.createJavaMailResource(string, string2, string3, string4);
    }

    public void deleteJavaMailResource(String string) throws AFResourceException {
        this.controller.deleteJavaMailResource(string);
    }

    public JavaMailResource getJavaMailResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getMailResourceObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        JavaMailResource javaMailResource = new JavaMailResource(objectName.toString(), string);
        javaMailResource.setContextHolder(this.getContextHolder());
        return javaMailResource;
    }

    public ServerModelIterator getJavaMailResources() throws AFException {
        return this.controller.getJavaMailResources();
    }

    public void createPersistenceManagerFactoryResource(String string) throws AFResourceException {
        this.controller.createPersistenceManagerFactoryResource(string);
    }

    public void deletePersistenceManagerFactoryResource(String string) throws AFResourceException {
        this.controller.deletePersistenceManagerFactoryResource(string);
    }

    public PersistenceManagerFactoryResource getPersistenceManagerFactoryResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getPersistenceManagerFactoryResourceObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        PersistenceManagerFactoryResource persistenceManagerFactoryResource = new PersistenceManagerFactoryResource(objectName.toString(), string);
        persistenceManagerFactoryResource.setContextHolder(this.getContextHolder());
        return persistenceManagerFactoryResource;
    }

    public ServerModelIterator getPersistenceManagerFactoryResources() throws AFException {
        return this.controller.getPersistenceManagerFactoryResources();
    }

    public void createCustomResource(String string, String string2, String string3) throws AFResourceException {
        this.controller.createCustomResource(string, string2, string3);
    }

    public void deleteCustomResource(String string) throws AFResourceException {
        this.controller.deleteCustomResource(string);
    }

    public CustomResource getCustomResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getCustomResourceObjectName(this.name, string);
        Assert.assertit(objectName != null, "null value returned");
        CustomResource customResource = new CustomResource(objectName.toString(), string);
        customResource.setContextHolder(this.getContextHolder());
        return customResource;
    }

    public ServerModelIterator getCustomResources() throws AFException {
        return this.controller.getCustomResources();
    }

    public JMSComponentBean getJMSComponent() {
        ObjectName objectName = ObjectNames.getJMSAdminHandlerObjectName(this.name);
        Assert.assertit(objectName != null, "null value returned");
        JMSComponentBean jMSComponentBean = new JMSComponentBean(objectName.toString());
        jMSComponentBean.setContextHolder(this.getContextHolder());
        return jMSComponentBean;
    }

    public JTAComponentBean getJTAComponent() {
        ObjectName objectName = ObjectNames.getJTSComponentObjectName(this.name);
        Assert.assertit(objectName != null, "null value returned");
        JTAComponentBean jTAComponentBean = new JTAComponentBean(objectName.toString());
        jTAComponentBean.setContextHolder(this.getContextHolder());
        return jTAComponentBean;
    }

    public JVMComponentBean getJVMComponent() {
        ObjectName objectName = ObjectNames.getJVMComponentObjectName(this.name);
        Assert.assertit(objectName != null, "null value returned");
        JVMComponentBean jVMComponentBean = new JVMComponentBean(objectName.toString());
        jVMComponentBean.setContextHolder(this.getContextHolder());
        return jVMComponentBean;
    }

    public SecurityServiceComponentBean getSecurityService() {
        ObjectName objectName = ObjectNames.getSecurityServiceObjectName(this.name);
        Assert.assertit(objectName != null, "null value returned");
        SecurityServiceComponentBean securityServiceComponentBean = new SecurityServiceComponentBean(objectName.toString());
        securityServiceComponentBean.setContextHolder(this.getContextHolder());
        return securityServiceComponentBean;
    }

    public HttpServiceComponentBean getHttpService() {
        ObjectName objectName = ObjectNames.getHttpServiceObjectName(this.name);
        Assert.assertit(objectName != null, "null value returned");
        HttpServiceComponentBean httpServiceComponentBean = new HttpServiceComponentBean(objectName.toString());
        httpServiceComponentBean.setContextHolder(this.getContextHolder());
        return httpServiceComponentBean;
    }

    public boolean isApplyNeeded() throws AFException {
        return this.controller.isApplyNeeded();
    }

    public boolean isRestartNeeded() throws AFException {
        return this.controller.isRestartNeeded();
    }

    public boolean applyChanges() throws AFException {
        return this.controller.applyChanges();
    }

    public boolean overwriteChanges() throws AFException {
        return this.controller.overwriteChanges();
    }

    public boolean useManualChanges() throws AFException {
        return this.controller.useManualChanges();
    }

    public void createLifeCycleModule(String string, String string2) throws AFException {
        this.controller.createLifeCycleModule(string, string2);
    }

    public void removeLifeCycleModule(String string) throws AFException {
        this.controller.removeLifeCycleModule(string);
    }

    public ServerModelIterator getLifeCycleModules() throws AFException {
        return this.controller.getLifeCycleModules();
    }

    public LifeCycleModule getLifeCycleModule(String string) {
        ArgChecker.checkValid(string, "moduleName", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getLifeCycleModuleObjectName(this.getName(), string);
        Assert.assertit(objectName != null, "null value returned");
        Debug.println("AppServerInstance.getLifeCycleModule: mbean = " + objectName);
        LifeCycleModule lifeCycleModule = new LifeCycleModule(objectName.toString(), string);
        lifeCycleModule.setContextHolder(this.getContextHolder());
        return lifeCycleModule;
    }

    public String exportClientStubs(String string, int n, String string2) throws AFException {
        return this.controller.exportClientStubs(string, n, string2);
    }

    public String[] getCertNickNames() throws AFException {
        return this.controller.getCertNickNames();
    }

    public String getInstanceRoot() throws AFException {
        return this.controller.getInstanceRoot();
    }

    public String[] getUserNames() throws AFException {
        return this.controller.getUserNames();
    }

    public String[] getGroupNames() throws AFException {
        return this.controller.getGroupNames();
    }

    public String[] getUserGroupNames(String string) throws AFException {
        return this.controller.getUserGroupNames(string);
    }

    public void addUser(String string, String string2, String[] stringArray) throws AFException {
        this.controller.addUser(string, string2, stringArray);
    }

    public void removeUser(String string) throws AFException {
        this.controller.removeUser(string);
    }

    public void updateUser(String string, String string2, String[] stringArray) throws AFException {
        this.controller.updateUser(string, string2, stringArray);
    }
}

