/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.StringValidator;
import com.iplanet.ias.connectors.util.xml.InstancePropertiesObject;
import com.sun.enterprise.repository.ResourceProperty;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class ResourceAdapterInfo
implements Serializable {
    private String jndiName;
    private Properties attrs;
    private static final String DEBUG_LEVEL = "debugLevel";
    private static final String MAX_POOL_SIZE = "maxPoolSize";
    private static final String STEADY_POOL_SIZE = "steadyPoolSize";
    private static final String MAX_WAIT = "maxWait";
    private static final String UNUSED_MAX_LIFE = "unusedMaxLife";

    public ResourceAdapterInfo(String string) {
        this(string, null, null);
    }

    public ResourceAdapterInfo(String string, InstancePropertiesObject instancePropertiesObject) {
        this(string, instancePropertiesObject, null);
    }

    public ResourceAdapterInfo(String string, InstancePropertiesObject instancePropertiesObject, Set set) {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        this.jndiName = string;
        this.attrs = new Properties();
        this.convertIPOToProps(instancePropertiesObject);
        this.convertAdapterProps(set);
    }

    private void convertIPOToProps(InstancePropertiesObject instancePropertiesObject) {
        if (instancePropertiesObject != null) {
            this.attrs.setProperty(MAX_POOL_SIZE, Integer.toString(instancePropertiesObject.getMaxPoolSize()));
            this.attrs.setProperty(STEADY_POOL_SIZE, Integer.toString(instancePropertiesObject.getSteadyPoolSize()));
            this.attrs.setProperty(MAX_WAIT, Integer.toString(instancePropertiesObject.getMaxWait()));
            this.attrs.setProperty(UNUSED_MAX_LIFE, Integer.toString(instancePropertiesObject.getUnusedMaxLife()));
        }
    }

    private void convertAdapterProps(Set set) {
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
                this.attrs.setProperty(resourceProperty.getName(), resourceProperty.getValue().toString());
            }
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Properties getAttrs() {
        return this.attrs;
    }

    public String toString() {
        return this.jndiName + " " + this.attrs;
    }
}

