/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.resourceEnvRefs;

import com.iplanet.ias.tools.common.dd.ResourceEnvRef;
import com.iplanet.ias.tools.common.dd.ejb.Ejb;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.LinkedPropertyManager;
import com.iplanet.ias.tools.forte.ejb.resourceEnvRefs.ResEnvRefMap;
import com.iplanet.ias.tools.forte.util.BundleHelper;
import com.iplanet.ias.tools.forte.util.ui.JNDINameMappingModel;
import org.netbeans.modules.j2ee.server.datamodel.EjbStandardData;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;

public class ResEnvRefMapModel
extends JNDINameMappingModel {
    public static final int JNDI_COLUMN = 1;
    public static final int REF_COLUMN = 0;
    private EjbStandardData.Ejb ejbJ2EE = null;
    private Ejb ejbNode = null;
    private String[] j2eeRefNames = null;
    private ResEnvRefMap[] maps = null;
    private int numRefs = 0;
    private String[] columnNames = new String[2];
    private LinkedPropertyManager refNameManager = new LinkedPropertyManager("ResourceEnvRefName");
    static /* synthetic */ Class class$java$lang$String;

    public ResEnvRefMapModel(Ejb n, EjbStandardData.Ejb e) {
        Reporter.assertIt((Object)n);
        Reporter.assertIt(e);
        this.ejbJ2EE = e;
        this.ejbNode = n;
        this.columnNames[0] = BundleHelper.getString(this, "TTL_J2EEColumn");
        this.columnNames[1] = BundleHelper.getString(this, "TTL_JNDIColumn");
        this.load();
    }

    public String getColumnName(int c) {
        return this.columnNames[c];
    }

    public Class getColumnClass(int c) {
        return class$java$lang$String == null ? (class$java$lang$String = ResEnvRefMapModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.numRefs;
    }

    public Object getValueAt(int r, int c) {
        if (r > this.numRefs) {
            Reporter.crit("Internal Error: getValueAt() asked for row# " + r + " but only " + this.numRefs + " rows exist.");
            return null;
        }
        if (c != 0 && c != 1) {
            Reporter.crit("Internal Error: getValueAt() asked for column# " + c + " but only 2 exist.");
            return null;
        }
        if (c == 0) {
            return this.maps[r].getJ2EE();
        }
        return this.maps[r].getJNDI();
    }

    public void setValueAt(Object obj, int r, int c) {
        Reporter.info("Setting row# " + r + "'s JNDI Name to: " + obj);
        Reporter.assertIt(obj instanceof String);
        String s = (String)obj;
        if (r > this.numRefs) {
            Reporter.crit("Internal Error: setValueAt() asked for row# " + r + " but only " + this.numRefs + " rows exist.");
            return;
        }
        if (c != 0 && c != 1) {
            Reporter.crit("Internal Error: setValueAt() asked for column# " + c + " but only 2 exist.");
            return;
        }
        if (c == 0) {
            this.maps[r].setJ2EE(s);
        } else {
            this.maps[r].setJNDI(s);
        }
        Reporter.verbose("setValueAt(" + r + ", " + c + "): " + s);
    }

    public boolean isCellEditable(int r, int c) {
        return c == 1;
    }

    public Object saveData() {
        int num = this.howManyMaps();
        Reporter.info("Saving Resource Env Reference Maps --- numMaps: " + num + ",  numRefs: " + this.numRefs);
        int size = this.ejbNode.sizeResourceEnvRef();
        ResourceEnvRef[] existingRrs = this.ejbNode.getResourceEnvRef();
        ResourceEnvRef[] rrs = new ResourceEnvRef[num];
        int currentMap = 0;
        ResourceEnvRef rr = null;
        int i = 0;
        while (i < this.numRefs) {
            String jndi = this.maps[i].getJNDI();
            String j2ee = this.maps[i].getJ2EE();
            rr = null;
            boolean newEntry = true;
            int j = 0;
            while (j < size) {
                if (existingRrs[j].getResourceEnvRefName().equals(j2ee) && existingRrs[j].getJndiName().equals(jndi)) {
                    rr = existingRrs[j];
                    newEntry = false;
                    break;
                }
                ++j;
            }
            if (newEntry) {
                rr = new ResourceEnvRef();
                rr.setJndiName(jndi);
                rr.setResourceEnvRefName(j2ee);
            }
            rrs[currentMap++] = rr;
            this.refNameManager.joinWithSource(j2ee, (Object)rr, "ResourceEnvRefName");
            ++i;
        }
        this.ejbNode.setResourceEnvRef(rrs);
        return this.ejbNode;
    }

    int howManyMaps() {
        return this.numRefs;
    }

    private void load() {
        this.loadJ2EERefs();
        this.maps = new ResEnvRefMap[this.numRefs];
        int i = 0;
        while (i < this.numRefs) {
            this.maps[i] = new ResEnvRefMap(this.j2eeRefNames[i]);
            ++i;
        }
        this.loadExistingMaps();
    }

    private void loadJ2EERefs() {
        Reporter.assertIt(this.ejbJ2EE);
        this.numRefs = 0;
        EjbStandardData.ResourceEnvRefCategory rrc = this.ejbJ2EE.getResourceEnvRefCategory();
        if (rrc == null) {
            Reporter.warn("No EjbStandardData.ResourceEnvRefCategory returned from ejbJ2EE");
            this.j2eeRefNames = new String[0];
            return;
        }
        EjbStandardData.ResourceEnvRef[] rr = rrc.getResourceEnvRef();
        if (rr == null || rr.length <= 0) {
            this.j2eeRefNames = new String[0];
            return;
        }
        this.numRefs = rr.length;
        this.j2eeRefNames = new String[this.numRefs];
        int i = 0;
        while (i < this.numRefs) {
            this.j2eeRefNames[i] = rr[i].getResourceEnvRefName();
            this.refNameManager.addNewSource(this.j2eeRefNames[i], (StandardData)rr[i]);
            ++i;
        }
    }

    private void loadExistingMaps() {
        ResourceEnvRef[] iasRefs = this.ejbNode.getResourceEnvRef();
        int i = 0;
        while (i < iasRefs.length) {
            String jndi = iasRefs[i].getJndiName();
            String j2ee = iasRefs[i].getResourceEnvRefName();
            Reporter.info(((Object)((Object)iasRefs[i])).hashCode() + " has name " + j2ee);
            this.refNameManager.joinWithSource(j2ee, (Object)iasRefs[i], "ResourceEnvRefName");
            int j = 0;
            while (j < this.numRefs) {
                if (j2ee.equals(this.maps[j].getJ2EE())) {
                    this.maps[j].setJNDI(jndi);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

