/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.appclient;

import com.iplanet.ias.tools.common.dd.EjbRef;
import com.iplanet.ias.tools.common.dd.PluginData;
import com.iplanet.ias.tools.common.dd.ResourceEnvRef;
import com.iplanet.ias.tools.common.dd.ResourceRef;
import com.iplanet.ias.tools.common.dd.appclient.SunApplicationClient;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.common.IASRefBean;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.deployment.api.ConfigBean;
import org.netbeans.modules.j2ee.deployment.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.api.StandardDDBean;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.TopManager;

public class IASACConfigBean
implements ConfigBean {
    public static final String EJB_REF_PATH = "ejb-ref";
    public static final String RESOURCE_ENV_REF_PATH = "resource-env-ref";
    public static final String RESOURCE_REF_PATH = "resource-ref";
    SunApplicationClient info;
    StandardDDBean standard;

    IASACConfigBean(StandardDDBean standard) {
        this.standard = standard;
        this.info = new SunApplicationClient();
    }

    IASACConfigBean(StandardDDBean standard, InputStream in) throws ConfigurationException {
        this.standard = standard;
        try {
            this.info = null == in ? SunApplicationClient.createGraph() : SunApplicationClient.createGraph(in);
            if (this.info == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw (ConfigurationException)TopManager.getDefault().getErrorManager().annotate((Throwable)new ConfigurationException(e.getMessage()), (Throwable)e);
        }
    }

    void save(OutputStream out) throws IOException {
        this.info.write(out);
    }

    public String getClientJarPath() {
        Reporter.verbose("getClientJarPath");
        PluginData pluginData = this.info.getPluginData();
        if (pluginData != null) {
            String clientJarPath = pluginData.getClientJarPath();
            Reporter.verbose("clientJarPath :" + clientJarPath);
            if (clientJarPath != null && clientJarPath.length() > 0) {
                return new String(clientJarPath);
            }
        }
        return new String("");
    }

    public void setClientJarPath(String clientJarPath) {
        Reporter.verbose("setClientJarPath");
        Reporter.verbose("clientJarPath:" + clientJarPath);
        PluginData pluginData = this.info.getPluginData();
        if (pluginData == null) {
            pluginData = new PluginData();
            this.info.setPluginData(pluginData);
        }
        pluginData.setClientJarPath(clientJarPath);
    }

    public String getClientArgs() {
        Reporter.verbose("getClientArgs");
        PluginData pluginData = this.info.getPluginData();
        if (pluginData != null) {
            String clientArgs = pluginData.getClientArgs();
            Reporter.verbose("clientArgs :" + clientArgs);
            if (clientArgs != null && clientArgs.length() > 0) {
                return new String(clientArgs);
            }
        }
        return new String("");
    }

    public void setClientArgs(String clientArgs) {
        Reporter.verbose("clientArgs:" + clientArgs);
        PluginData pluginData = this.info.getPluginData();
        if (pluginData == null) {
            pluginData = new PluginData();
            this.info.setPluginData(pluginData);
        }
        pluginData.setClientArgs(clientArgs);
    }

    public StandardDDBean getStandardDDBean() {
        return this.standard;
    }

    public String[] getXpaths() {
        return new String[]{EJB_REF_PATH, RESOURCE_ENV_REF_PATH, RESOURCE_REF_PATH};
    }

    public ConfigBean getConfigBean(StandardDDBean subStandard) {
        String xpath = subStandard.getXpath();
        if (xpath.equals("/application-client/ejb-ref")) {
            return new ACEjbRefBean(this.info, this.standard, subStandard);
        }
        if (xpath.equals("/application-client/resource-env-ref")) {
            return new ACResourceEnvRefBean(this.info, this.standard, subStandard);
        }
        if (xpath.equals("/application-client/resource-ref")) {
            return new ACResourceRefBean(this.info, this.standard, subStandard);
        }
        return null;
    }

    public void removeConfigBean(ConfigBean bean) {
    }

    public void notifyStandardDDBeanChanged() {
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.info.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.info.removePropertyChangeListener(pcl);
    }

    public SunApplicationClient getSunApplicationClient() {
        return this.info;
    }

    public static class ACResourceRefBean
    extends IASRefBean.ResourceRefBean {
        ACResourceRefBean(BaseBean parent, StandardDDBean parentStandard, StandardDDBean standard) {
            super(parent, parentStandard, standard);
        }

        public BaseBean[] getRefsFromDD() {
            return ((SunApplicationClient)this.getParent()).getResourceRef();
        }

        public void removeRefFromDD(BaseBean ref) {
            ((SunApplicationClient)this.getParent()).removeResourceRef((ResourceRef)ref);
        }

        public void addRefToDD(BaseBean ref) {
            ((SunApplicationClient)this.getParent()).addResourceRef((ResourceRef)ref);
        }

        public String getRefPath() {
            return IASACConfigBean.RESOURCE_REF_PATH;
        }

        public String getTypeName() {
            return "Appclient resource";
        }
    }

    public static class ACResourceEnvRefBean
    extends IASRefBean.ResourceEnvRefBean {
        ACResourceEnvRefBean(BaseBean parent, StandardDDBean parentStandard, StandardDDBean standard) {
            super(parent, parentStandard, standard);
        }

        public BaseBean[] getRefsFromDD() {
            return ((SunApplicationClient)this.getParent()).getResourceEnvRef();
        }

        public void removeRefFromDD(BaseBean ref) {
            ((SunApplicationClient)this.getParent()).removeResourceEnvRef((ResourceEnvRef)ref);
        }

        public void addRefToDD(BaseBean ref) {
            ((SunApplicationClient)this.getParent()).addResourceEnvRef((ResourceEnvRef)ref);
        }

        public String getRefPath() {
            return IASACConfigBean.RESOURCE_ENV_REF_PATH;
        }

        public String getTypeName() {
            return "Appclient resource env";
        }
    }

    public static class ACEjbRefBean
    extends IASRefBean.EjbRefBean {
        ACEjbRefBean(BaseBean parent, StandardDDBean parentStandard, StandardDDBean standard) {
            super(parent, parentStandard, standard);
        }

        public BaseBean[] getRefsFromDD() {
            return ((SunApplicationClient)this.getParent()).getEjbRef();
        }

        public void removeRefFromDD(BaseBean ref) {
            ((SunApplicationClient)this.getParent()).removeEjbRef((EjbRef)ref);
        }

        public void addRefToDD(BaseBean ref) {
            ((SunApplicationClient)this.getParent()).addEjbRef((EjbRef)ref);
        }

        public String getRefPath() {
            return IASACConfigBean.EJB_REF_PATH;
        }

        public String getTypeName() {
            return "Appclient EJB";
        }
    }
}

