/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.common.deploy;

import com.iplanet.ias.tools.common.deploy.IPMFactory;
import com.iplanet.ias.tools.common.deploy.NameValuePair;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.List;

public class PersistenceManager
implements Serializable {
    private String name;
    private String Description = "";
    private String JndiName = "jdo/";
    private String FactoryClassName = "com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerFactoryImpl";
    private String Enabled = "true";
    private NameValuePair[] extParams = new NameValuePair[0];
    private String DataSourceName = "jdbc/";
    protected transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public PersistenceManager(List resources) {
        String resName = "PersistenceManager";
        String t_name = null;
        if (resources.size() != 0) {
            int num = resources.size() + 1;
            t_name = resName + "_" + num;
            boolean resource_exists = this.FactoryName(t_name, resources);
            while (resource_exists) {
                t_name = resName + "_" + ++num;
                resource_exists = this.FactoryName(t_name, resources);
            }
        } else {
            t_name = resName + "_1";
        }
        this.name = t_name;
    }

    public boolean FactoryName(String value, List resources) {
        boolean exists = false;
        int i = 0;
        while (i < resources.size()) {
            IPMFactory instance = (IPMFactory)resources.get(i);
            String inst = instance.getName();
            if (inst.equals(value)) {
                exists = true;
            }
            ++i;
        }
        return exists;
    }

    public String getJndiName() {
        return this.JndiName;
    }

    public void setJndiName(String value) {
        String oldValue = this.JndiName;
        this.JndiName = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("JndiName", oldValue, this.JndiName);
        this.setName(this.JndiName);
    }

    public void simpleSetJndiName(String value) {
        this.JndiName = value;
        this.setName(this.JndiName);
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String value) {
        String oldValue = this.Description;
        this.Description = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("Description", oldValue, this.Description);
    }

    public String getFactoryClassName() {
        return this.FactoryClassName;
    }

    public void setFactoryClassName(String value) {
        String oldValue = this.FactoryClassName;
        this.FactoryClassName = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("FactoryClassName", oldValue, this.FactoryClassName);
    }

    public String getEnabled() {
        return this.Enabled;
    }

    public void setEnabled(String value) {
        String oldValue = this.Enabled;
        this.Enabled = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("Enabled", oldValue, this.Enabled);
    }

    public String getDataSourceName() {
        return this.DataSourceName;
    }

    public void setDataSourceName(String value) {
        String oldValue = this.DataSourceName;
        this.DataSourceName = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("DataSourceName", oldValue, this.DataSourceName);
    }

    private void initPropertyChangeSupport() {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.initPropertyChangeSupport();
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.initPropertyChangeSupport();
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        String oldValue = this.name;
        this.name = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("name", oldValue, this.name);
    }

    public NameValuePair[] getExtParams() {
        return this.extParams;
    }

    public void setExtParams(Object[] value) {
        Reporter.info(new Integer(value.length));
        NameValuePair[] pairs = new NameValuePair[value.length];
        int i = 0;
        while (i < value.length) {
            NameValuePair val = (NameValuePair)value[i];
            NameValuePair pair = new NameValuePair();
            pair.setParamName(val.getParamName());
            pair.setParamValue(val.getParamValue());
            pair.setParamDescription(val.getParamDescription());
            Reporter.info(pair.getParamName() + "   " + pair.getParamValue() + "  " + pair.getParamDescription());
            pairs[i] = pair;
            ++i;
        }
        NameValuePair[] oldValue = this.extParams;
        this.extParams = pairs;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("extParams", oldValue, this.extParams);
    }

    public String toString() {
        return "name: " + this.getName() + ", Description: " + this.getDescription() + ", JndiName: " + this.getJndiName() + ", FactoryClassName: " + this.getFactoryClassName() + ", Enabled: " + this.getEnabled();
    }
}

