/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;

public class SubjectPublicKeyInfo
implements ASN1Value,
PublicKey {
    private AlgorithmIdentifier algorithm;
    private BIT_STRING subjectPublicKey;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private SubjectPublicKeyInfo() {
    }

    public SubjectPublicKeyInfo(PublicKey publicKey) throws InvalidBERException, IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)ASN1Util.decode(SubjectPublicKeyInfo.getTemplate(), publicKey.getEncoded());
        this.algorithm = subjectPublicKeyInfo.algorithm;
        this.subjectPublicKey = subjectPublicKeyInfo.subjectPublicKey;
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, BIT_STRING bIT_STRING) {
        this.algorithm = algorithmIdentifier;
        this.subjectPublicKey = bIT_STRING;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.algorithm);
        sEQUENCE.addElement(this.subjectPublicKey);
        sEQUENCE.encode(tag, outputStream);
    }

    public String getAlgorithm() {
        try {
            return PrivateKey.Type.fromOID(this.algorithm.getOID()).toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        if (this.subjectPublicKey.getPadCount() != 0) {
            Assert.notReached("public key is not an integral number of bytes");
            return null;
        }
        return this.subjectPublicKey.getBits();
    }

    public String getFormat() {
        return "X.509";
    }

    public BIT_STRING getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public PublicKey toPublicKey() throws NoSuchAlgorithmException, InvalidKeyFormatException {
        PrivateKey.Type type = PrivateKey.Type.fromOID(this.algorithm.getOID());
        if (this.subjectPublicKey.getPadCount() != 0) {
            throw new InvalidKeyFormatException();
        }
        return PK11PubKey.fromRaw(type, this.subjectPublicKey.getBits());
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(BIT_STRING.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new SubjectPublicKeyInfo((AlgorithmIdentifier)sEQUENCE.elementAt(0), (BIT_STRING)sEQUENCE.elementAt(1));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

