/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.util.Assert;

public class SignerIdentifier
implements ASN1Value {
    public static Type ISSUER_AND_SERIALNUMBER = Type.ISSUER_AND_SERIALNUMBER;
    public static Type SUBJECT_KEY_IDENTIFIER = Type.SUBJECT_KEY_IDENTIFIER;
    private Type type;
    private IssuerAndSerialNumber issuerAndSerialNumber = null;
    private OCTET_STRING subjectKeyIdentifier = null;
    private static Template templateInstance = new Template();

    private SignerIdentifier() {
    }

    public SignerIdentifier(Type type, IssuerAndSerialNumber issuerAndSerialNumber, OCTET_STRING oCTET_STRING) {
        this.type = type;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.subjectKeyIdentifier = oCTET_STRING;
    }

    public static SignerIdentifier createIssuerAndSerialNumber(IssuerAndSerialNumber issuerAndSerialNumber) {
        return new SignerIdentifier(ISSUER_AND_SERIALNUMBER, issuerAndSerialNumber, null);
    }

    public static SignerIdentifier createSubjectKeyIdentifier(OCTET_STRING oCTET_STRING) {
        return new SignerIdentifier(SUBJECT_KEY_IDENTIFIER, null, oCTET_STRING);
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.type == SUBJECT_KEY_IDENTIFIER) {
            this.subjectKeyIdentifier.encode(Tag.get(0L), outputStream);
        } else {
            Assert.assert(this.type == ISSUER_AND_SERIALNUMBER);
            this.issuerAndSerialNumber.encode(outputStream);
        }
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.encode(outputStream);
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public OCTET_STRING getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public Tag getTag() {
        if (this.type == SUBJECT_KEY_IDENTIFIER) {
            return Tag.get(0L);
        }
        Assert.assert(this.type == ISSUER_AND_SERIALNUMBER);
        return IssuerAndSerialNumber.TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public Type getType() {
        return this.type;
    }

    public static class Type {
        static Type ISSUER_AND_SERIALNUMBER = new Type();
        static Type SUBJECT_KEY_IDENTIFIER = new Type();

        private Type() {
        }
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(Tag.get(0L), OCTET_STRING.getTemplate());
            this.choicet.addElement(IssuerAndSerialNumber.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            CHOICE cHOICE = (CHOICE)this.choicet.decode(inputStream);
            if (cHOICE.getTag() == SEQUENCE.TAG) {
                return SignerIdentifier.createIssuerAndSerialNumber((IssuerAndSerialNumber)cHOICE.getValue());
            }
            Assert.assert(cHOICE.getTag().equals(Tag.get(0L)));
            OCTET_STRING oCTET_STRING = (OCTET_STRING)cHOICE.getValue();
            return SignerIdentifier.createSubjectKeyIdentifier(oCTET_STRING);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(inputStream);
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }
    }
}

