/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import org.mozilla.jss.crypto.CryptoToken;

public interface SymmetricKey {
    public static final Type DES = Type.DES;
    public static final Type DES3 = Type.DES3;
    public static final Type RC4 = Type.RC4;
    public static final Type RC2 = Type.RC2;
    public static final Type SHA1_HMAC = Type.SHA1_HMAC;

    public byte[] getKeyData() throws NotExtractableException;

    public CryptoToken getOwningToken();

    public int getStrength();

    public Type getType();

    public static class NotExtractableException
    extends Exception {
    }

    public static final class Type {
        private String name;
        public static final Type DES = new Type("DES");
        public static final Type DES3 = new Type("DES3");
        public static final Type RC4 = new Type("RC4");
        public static final Type RC2 = new Type("RC2");
        public static final Type SHA1_HMAC = new Type("SHA1_HMAC");

        private Type() {
        }

        private Type(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class Usage {
        private int val;
        public static final Usage ENCRYPT = new Usage(0);
        public static final Usage DECRYPT = new Usage(1);
        public static final Usage WRAP = new Usage(2);
        public static final Usage UNWRAP = new Usage(3);
        public static final Usage SIGN = new Usage(4);
        public static final Usage VERIFY = new Usage(5);

        private Usage() {
        }

        private Usage(int n) {
            this.val = n;
        }

        public int getVal() {
            return this.val;
        }
    }
}

