/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.PasswordCallback;

public interface CryptoToken {
    public static final int ONE_TIME = 0;
    public static final int TIMEOUT = 1;
    public static final int EVERY_TIME = 2;

    public void changePassword(PasswordCallback var1, PasswordCallback var2) throws IncorrectPasswordException, TokenException;

    public SymmetricKey cloneKey(SymmetricKey var1) throws SymmetricKey.NotExtractableException, InvalidKeyException, TokenException;

    public boolean doesAlgorithm(Algorithm var1);

    public boolean equals(Object var1);

    public String generateCertRequest(String var1, int var2, String var3, byte[] var4, byte[] var5, byte[] var6) throws TokenException, InvalidParameterException, PQGParamGenException;

    public Cipher getCipherContext(EncryptionAlgorithm var1) throws NoSuchAlgorithmException, TokenException;

    public CryptoStore getCryptoStore();

    public JSSMessageDigest getDigestContext(DigestAlgorithm var1) throws NoSuchAlgorithmException, DigestException;

    public KeyGenerator getKeyGenerator(KeyGenAlgorithm var1) throws NoSuchAlgorithmException, TokenException;

    public KeyPairGenerator getKeyPairGenerator(KeyPairAlgorithm var1) throws NoSuchAlgorithmException, TokenException;

    public KeyWrapper getKeyWrapper(KeyWrapAlgorithm var1) throws NoSuchAlgorithmException, TokenException;

    public int getLoginMode() throws TokenException;

    public int getLoginTimeoutMinutes() throws TokenException;

    public String getName() throws TokenException;

    public Signature getSignatureContext(SignatureAlgorithm var1) throws NoSuchAlgorithmException, TokenException;

    public void initPassword(PasswordCallback var1, PasswordCallback var2) throws IncorrectPasswordException, AlreadyInitializedException, TokenException;

    public boolean isLoggedIn() throws TokenException;

    public boolean isPresent();

    public void login(PasswordCallback var1) throws IncorrectPasswordException, TokenException;

    public void logout() throws TokenException;

    public boolean passwordIsInitialized() throws TokenException;

    public void setLoginMode(int var1) throws TokenException;

    public void setLoginTimeoutMinutes(int var1) throws TokenException;
}

