/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.LogControl;
import com.sun.jts.CosTransactions.LogControlDescriptor;
import com.sun.jts.CosTransactions.LogCursor;
import com.sun.jts.CosTransactions.LogException;
import com.sun.jts.CosTransactions.LogExtent;
import com.sun.jts.CosTransactions.LogFileHandle;
import com.sun.jts.CosTransactions.LogLSN;
import com.sun.jts.CosTransactions.LogRecordEnding;
import com.sun.jts.CosTransactions.LogRecordHeader;
import com.sun.jts.CosTransactions.LogRestartDescriptor;
import com.sun.jts.CosTransactions.LogUpcallTarget;
import java.io.File;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class LogHandle {
    static final int BUFFER = 0;
    static final int FORCE = 1;
    static final int TAIL_NOT_INCLUSIVE = 0;
    static final int TAIL_INCLUSIVE = 1;
    static final int START_CKPT = 0;
    static final int INDV_CKPT = 1;
    static final int END_CKPT = 2;
    static final int NEW_JRNL = 3;
    static final int RECORD_TYPE_MAX = 65535;
    static final int MARKER = 65535;
    static final int LINK = 65536;
    static final int MAX_NUMBER_EXTENTS = -1;
    static final int CONTROL_FORCE_INTERVAL = 20;
    static final int MAX_EXTENT_SIZE = 65536;
    static final int CUSHION_SIZE = 65536;
    static final int NAME_LENGTH = 8;
    static final int MAX_NAMES = 4096;
    static final int FILENAME_PREFIX_LEN = 5;
    static final int EXTENT_TABLE_SIZE = 16;
    static final int CALLBACK_REASON_SOS = 1;
    static final int RESTART_OFFSET_1 = 4096;
    static final int RESTART_OFFSET_2 = 20480;
    static final int MAX_RECORD_SIZE = 65456;
    static final int MAX_RESTART_SIZE = 16360;
    static final int CONTROL_FILE_SIZE = 36864;
    static final int ALLOCATE_SIZE = 65536;
    LogHandle blockValid = null;
    int restartDataLength = 0;
    int recordsWritten = 0;
    int chunkRemaining = 0;
    int activeRestartVersion = 0;
    LogUpcallTarget upcallTarget = null;
    Vector cursors = null;
    boolean cushionExists = false;
    boolean upcallInProgress = false;
    Hashtable extentTable = null;
    String logFileName = null;
    LogFileHandle logFileHandle = null;
    LogControlDescriptor logControlDescriptor = null;
    LogControl logControl = null;

    LogHandle(LogControl logControl, String string, LogFileHandle logFileHandle, LogUpcallTarget logUpcallTarget) throws LogException {
        this.logFileName = new String(string);
        this.upcallTarget = logUpcallTarget;
        this.logControl = logControl;
        this.logFileHandle = logFileHandle;
        this.blockValid = this;
        this.logControlDescriptor = new LogControlDescriptor();
        this.cursors = new Vector();
        this.extentTable = new Hashtable(16);
    }

    synchronized LogLSN writeRecord(byte[] byArray, int n, int n2) throws LogException {
        int n3;
        int n4;
        byte[] byArray2;
        Object object;
        Serializable serializable;
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.logControl.logReadOnly) {
            throw new LogException(null, 27, 3);
        }
        if (n > 65535) {
            throw new LogException(null, 24, 5);
        }
        if (n2 != 1 && n2 != 0) {
            throw new LogException(null, 25, 6);
        }
        int n5 = byArray.length + 32 + 8;
        if (n5 > 65456) {
            throw new LogException(null, 10, 7);
        }
        int n6 = 65536 - (this.logControlDescriptor.nextLSN.offset + 64 + 8);
        Object object2 = this.positionFilePointer(this.logControlDescriptor.nextLSN, 0, 2);
        if (n6 < n5) {
            serializable = new LogRecordHeader();
            int n7 = this.logControlDescriptor.headLSN.extent + 1;
            if (n7 < 0) {
                throw new LogException(null, 7, 8);
            }
            if (this.extentTable.containsKey(new Integer(LogExtent.modExtent(n7)))) {
                throw new LogException(null, 7, 9);
            }
            ((LogRecordHeader)serializable).recordType = 65536;
            ((LogRecordHeader)serializable).previousLSN = new LogLSN(this.logControlDescriptor.headLSN);
            ((LogRecordHeader)serializable).currentLSN = new LogLSN(this.logControlDescriptor.nextLSN);
            ((LogRecordHeader)serializable).nextLSN = new LogLSN(n7, 0);
            object = this.positionFilePointer(((LogRecordHeader)serializable).nextLSN, 0, 2);
            byArray2 = new byte[32];
            ((LogRecordHeader)serializable).toBytes(byArray2, 0);
            n4 = 0;
            try {
                n4 = ((LogExtent)object2).fileHandle.fileWrite(byArray2);
            }
            catch (LogException logException) {
                this.extentTable.remove(new Integer(this.logControlDescriptor.headLSN.extent));
                ((LogExtent)object).finalize();
                throw new LogException(null, 7, 10);
            }
            ((LogExtent)object2).writtenSinceLastForce = true;
            ((LogExtent)object2).cursorPosition += n4;
            this.logControlDescriptor.headLSN.copy(((LogRecordHeader)serializable).currentLSN);
            this.logControlDescriptor.nextLSN.copy(((LogRecordHeader)serializable).nextLSN);
            object2 = object;
            this.chunkRemaining = 0;
        }
        serializable = new LogLSN(this.logControlDescriptor.nextLSN.extent, this.logControlDescriptor.nextLSN.offset + n5);
        LogRecordHeader logRecordHeader = new LogRecordHeader();
        logRecordHeader.recordType = n;
        logRecordHeader.recordLength = byArray.length;
        logRecordHeader.nextLSN = serializable;
        logRecordHeader.previousLSN = new LogLSN(this.logControlDescriptor.headLSN);
        logRecordHeader.currentLSN = new LogLSN(this.logControlDescriptor.nextLSN);
        object = new LogRecordEnding();
        ((LogRecordEnding)object).currentLSN = logRecordHeader.currentLSN;
        byArray2 = new byte[32 + byArray.length + 8];
        logRecordHeader.toBytes(byArray2, 0);
        System.arraycopy(byArray, 0, byArray2, 32, byArray.length);
        ((LogRecordEnding)object).toBytes(byArray2, 32 + byArray.length);
        n4 = 0;
        if (this.chunkRemaining > n5) {
            this.chunkRemaining -= n5;
        } else {
            n3 = this.chunkRemaining + 65536;
            if (n3 + this.logControlDescriptor.nextLSN.offset > 65536) {
                n3 = 65536 - this.logControlDescriptor.nextLSN.offset;
            }
            boolean bl = false;
            do {
                try {
                    ((LogExtent)object2).fileHandle.allocFileStorage(n3);
                }
                catch (LogException logException) {
                    if (logException.errorCode == 11) {
                        if (!this.cushionExists) {
                            if (n4 != 0) {
                                this.restoreCushion(false);
                            }
                            throw new LogException(null, 11, 11);
                        }
                        this.freeCushion();
                        n4 = 1;
                        try {
                            object2 = this.positionFilePointer(this.logControlDescriptor.nextLSN, 0, 2);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    bl = false;
                }
            } while (!(bl = true));
            if (!bl) {
                throw new LogException(null, 7, 12);
            }
            this.chunkRemaining = n3 - n5;
        }
        n3 = ((LogExtent)object2).fileHandle.fileWrite(byArray2);
        ((LogExtent)object2).writtenSinceLastForce = true;
        ((LogExtent)object2).cursorPosition += n3;
        if (n2 == 1) {
            Enumeration enumeration = this.extentTable.elements();
            while (enumeration.hasMoreElements()) {
                LogExtent logExtent = (LogExtent)enumeration.nextElement();
                if (!logExtent.writtenSinceLastForce) continue;
                try {
                    logExtent.fileHandle.fileSync();
                    logExtent.writtenSinceLastForce = false;
                }
                catch (LogException logException) {
                    throw new LogException(null, 13, 14);
                }
            }
        }
        this.logControlDescriptor.headLSN.copy(logRecordHeader.currentLSN);
        this.logControlDescriptor.nextLSN.copy(logRecordHeader.nextLSN);
        ++this.recordsWritten;
        if (this.recordsWritten >= 20) {
            this.writeControlFile();
            this.recordsWritten = 0;
        }
        if (n4 != 0) {
            this.restoreCushion(true);
        }
        LogLSN logLSN = new LogLSN(logRecordHeader.currentLSN);
        return logLSN;
    }

    synchronized byte[] readRecord(LogLSN logLSN, int[] nArray) throws LogException {
        LogLSN logLSN2;
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.logControlDescriptor.headLSN.isNULL()) {
            throw new LogException(null, 14, 3);
        }
        if (logLSN.equals(LogLSN.HEAD_LSN)) {
            logLSN2 = this.logControlDescriptor.headLSN;
        } else if (logLSN.equals(LogLSN.TAIL_LSN)) {
            logLSN2 = this.logControlDescriptor.tailLSN;
        } else {
            if (logLSN.lessThan(this.logControlDescriptor.tailLSN) || logLSN.greaterThan(this.logControlDescriptor.headLSN)) {
                throw new LogException(null, 14, 4);
            }
            logLSN2 = logLSN;
        }
        LogExtent logExtent = this.positionFilePointer(logLSN2, 0, 1);
        byte[] byArray = new byte[32];
        int n = 0;
        try {
            n = logExtent.fileHandle.fileRead(byArray);
        }
        catch (LogException logException) {
            logExtent.lastAccess = 0;
            throw new LogException(null, logException.errorCode, 6);
        }
        LogRecordHeader logRecordHeader = new LogRecordHeader(byArray, 0);
        logExtent.cursorPosition += n;
        if (logRecordHeader.recordType == 65536 || !logRecordHeader.currentLSN.equals(logLSN2)) {
            throw new LogException(null, 14, 7);
        }
        byte[][] byArrayArray = new byte[][]{new byte[logRecordHeader.recordLength], new byte[8]};
        try {
            n = logExtent.fileHandle.readVector(byArrayArray);
        }
        catch (LogException logException) {
            logExtent.lastAccess = 0;
            throw new LogException(null, logException.errorCode, 9);
        }
        LogRecordEnding logRecordEnding = new LogRecordEnding(byArrayArray[1], 0);
        logExtent.cursorPosition += n;
        if (!logRecordEnding.currentLSN.equals(logLSN2)) {
            throw new LogException(null, 4, 10);
        }
        nArray[0] = logRecordHeader.recordType;
        return byArrayArray[0];
    }

    synchronized void writeRestart(byte[] byArray) throws LogException {
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.logControl.logReadOnly) {
            throw new LogException(null, 27, 3);
        }
        if (byArray.length > 16360) {
            throw new LogException(null, 10, 4);
        }
        if (this.blockValid != this) {
            throw new LogException(null, 5, 5);
        }
        int n = LogHandle.alternateRestart(this.activeRestartVersion);
        int n2 = LogHandle.restartPosition(n);
        this.logFileHandle.fileSeek(n2, 1);
        LogRestartDescriptor logRestartDescriptor = new LogRestartDescriptor();
        logRestartDescriptor.restartDataLength = byArray.length;
        logRestartDescriptor.timeStamp = (int)new Date().getTime();
        logRestartDescriptor.restartValid = n2;
        byte[] byArray2 = new byte[24 + byArray.length];
        logRestartDescriptor.toBytes(byArray2, 0);
        System.arraycopy(byArray, 0, byArray2, 12, byArray.length);
        logRestartDescriptor.toBytes(byArray2, 12 + byArray.length);
        int n3 = this.logFileHandle.fileWrite(byArray2);
        this.activeRestartVersion = n;
    }

    synchronized byte[] readRestart() throws LogException {
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.blockValid != this) {
            throw new LogException(null, 5, 3);
        }
        if (this.restartDataLength == 0) {
            return new byte[0];
        }
        int n = LogHandle.restartPosition(this.activeRestartVersion);
        this.logFileHandle.fileSeek(n, 1);
        byte[][] byArrayArray = new byte[][]{new byte[12], new byte[this.restartDataLength], new byte[12]};
        int n2 = this.logFileHandle.readVector(byArrayArray);
        LogRestartDescriptor logRestartDescriptor = new LogRestartDescriptor(byArrayArray[0], 0);
        LogRestartDescriptor logRestartDescriptor2 = new LogRestartDescriptor(byArrayArray[2], 0);
        if (logRestartDescriptor.restartValid != n || logRestartDescriptor.restartDataLength != this.restartDataLength || !logRestartDescriptor.equals(logRestartDescriptor2)) {
            throw new LogException(null, 4, 7);
        }
        return byArrayArray[1];
    }

    synchronized void closeFile(boolean bl) throws LogException {
        Object object;
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        this.blockValid = null;
        boolean bl2 = false;
        Enumeration enumeration = this.extentTable.elements();
        while (enumeration.hasMoreElements()) {
            LogExtent logExtent;
            Boolean bl3;
            object = (LogExtent)enumeration.nextElement();
            if (((LogExtent)object).writtenSinceLastForce) {
                ((LogExtent)object).fileHandle.fileSync();
                ((LogExtent)object).writtenSinceLastForce = false;
                bl2 = true;
            }
            ((LogExtent)object).fileHandle.fileClose();
            if (bl && !(bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(logExtent = object){
                private final /* synthetic */ LogExtent val$tmplogEDP;
                {
                    this.val$tmplogEDP = logExtent;
                }

                public Object run() {
                    return new Boolean(this.val$tmplogEDP.file.delete());
                }
            })).booleanValue()) {
                throw new LogException(null, 8, 6);
            }
            this.extentTable.remove(new Integer(((LogExtent)object).extentNumber));
            ((LogExtent)object).finalize();
        }
        if (bl2 && !this.logControl.logReadOnly) {
            this.writeControlFile();
        }
        this.logFileHandle.fileClose();
        this.logFileHandle.finalize();
        if (bl) {
            object = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(LogHandle.this.logControl.controlFile.delete());
                }
            });
            if (!((Boolean)object).booleanValue()) {
                throw new LogException(null, 8, 7);
            }
            this.freeCushion();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    LogControl.directory(LogHandle.this.logFileName, LogHandle.this.logControl.directoryPath).delete();
                    return null;
                }
            });
        }
        this.logControl.removeFile(this);
    }

    synchronized void truncate(LogLSN logLSN, int n) throws LogException {
        Object object;
        int n2;
        LogLSN logLSN2;
        LogLSN logLSN3;
        LogLSN logLSN4;
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.logControl.logReadOnly) {
            throw new LogException(null, 27, 3);
        }
        if (this.logControlDescriptor.headLSN.isNULL()) {
            if (logLSN.equals(LogLSN.HEAD_LSN)) {
                return;
            }
            throw new LogException(null, 15, 6);
        }
        boolean bl = false;
        if (logLSN.equals(LogLSN.HEAD_LSN) || logLSN.equals(this.logControlDescriptor.headLSN)) {
            logLSN4 = new LogLSN(this.logControlDescriptor.headLSN);
            bl = true;
        } else {
            logLSN4 = logLSN.equals(LogLSN.TAIL_LSN) ? new LogLSN(this.logControlDescriptor.tailLSN) : new LogLSN(logLSN);
        }
        if (logLSN4.lessThan(this.logControlDescriptor.tailLSN)) {
            throw new LogException(null, 16, 7);
        }
        if (logLSN4.greaterThan(this.logControlDescriptor.headLSN)) {
            throw new LogException(null, 15, 8);
        }
        boolean bl2 = false;
        if (bl && n == 0) {
            logLSN3 = new LogLSN(logLSN4);
            logLSN2 = new LogLSN(this.logControlDescriptor.nextLSN);
        } else {
            if (n == 1 && logLSN4.equals(this.logControlDescriptor.tailLSN)) {
                return;
            }
            LogExtent logExtent = this.positionFilePointer(logLSN4, 0, 1);
            byte[] byArray = new byte[32];
            n2 = 0;
            try {
                n2 = logExtent.fileHandle.fileRead(byArray);
            }
            catch (LogException logException) {
                logExtent.lastAccess = 0;
                throw new LogException(null, 3, 11);
            }
            logExtent.cursorPosition += n2;
            object = new LogRecordHeader(byArray, 0);
            if (((LogRecordHeader)object).recordType == 65536) {
                throw new LogException(null, 17, 12);
            }
            if (n == 1) {
                logLSN3 = new LogLSN(((LogRecordHeader)object).previousLSN);
                logLSN2 = new LogLSN(logLSN4);
                if (logLSN4.offset == 0) {
                    bl2 = true;
                }
            } else {
                logLSN3 = new LogLSN(logLSN4);
                logLSN2 = new LogLSN(((LogRecordHeader)object).nextLSN);
            }
        }
        int n3 = this.logControlDescriptor.tailLSN.extent;
        int n4 = logLSN3.extent;
        if (bl && n == 0) {
            this.logControlDescriptor.tailLSN.copy(logLSN2);
            this.logControlDescriptor.headLSN.copy(LogLSN.NULL_LSN);
        } else {
            this.logControlDescriptor.tailLSN.copy(logLSN2);
        }
        this.writeControlFile();
        if (bl2) {
            ++n4;
        }
        n2 = n3;
        while (n2 <= n4 - 1) {
            Object object2;
            Boolean bl3;
            object = (LogExtent)this.extentTable.get(new Integer(n2));
            if (object != null) {
                ((LogExtent)object).fileHandle.fileClose();
            }
            if (!(bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction((LogExtent)(object2 = object)){
                private final /* synthetic */ LogExtent val$tmplogEDP;
                {
                    this.val$tmplogEDP = logExtent;
                }

                public Object run() {
                    return new Boolean(this.val$tmplogEDP.file.delete());
                }
            })).booleanValue()) {
                throw new LogException(null, 8, 15);
            }
            this.extentTable.remove(new Integer(n2));
            ((LogExtent)object).finalize();
            ++n2;
        }
        if (!this.cushionExists && n3 <= n4 - 1) {
            this.restoreCushion(false);
        }
        if (this.logControlDescriptor.tailLSN.offset > 0) {
            this.freeFileStorage(this.logControlDescriptor.tailLSN);
        }
        if (this.logControlDescriptor.headLSN.isNULL()) {
            this.recordsWritten = 20;
        }
    }

    synchronized void checkLSN(LogLSN logLSN) throws LogException {
        int n;
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.logControl.logReadOnly) {
            throw new LogException(null, 27, 3);
        }
        LogLSN logLSN2 = logLSN.equals(LogLSN.HEAD_LSN) ? new LogLSN(this.logControlDescriptor.headLSN) : (logLSN.equals(LogLSN.TAIL_LSN) ? new LogLSN(this.logControlDescriptor.tailLSN) : new LogLSN(logLSN));
        if (logLSN2.lessThan(this.logControlDescriptor.tailLSN)) {
            return;
        }
        if (this.logControlDescriptor.headLSN.isNULL()) {
            return;
        }
        if (logLSN2.greaterThan(this.logControlDescriptor.headLSN)) {
            logLSN2.copy(this.logControlDescriptor.headLSN);
        }
        int n2 = logLSN2.extent;
        int n3 = n = this.logControlDescriptor.tailLSN.extent;
        while (n3 <= n2) {
            LogExtent logExtent = (LogExtent)this.extentTable.get(new Integer(n3));
            if (logExtent != null && logExtent.writtenSinceLastForce) {
                logExtent.fileHandle.fileSync();
                logExtent.writtenSinceLastForce = false;
            }
            ++n3;
        }
    }

    synchronized LogCursor openCursor(LogLSN logLSN, LogLSN logLSN2) throws LogException {
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        LogCursor logCursor = new LogCursor(this.logControl, this, logLSN, logLSN2);
        if (logCursor == null) {
            throw new LogException(null, 12, 4);
        }
        this.cursors.addElement(logCursor);
        return logCursor;
    }

    synchronized void closeCursor(LogCursor logCursor) throws LogException {
        if (logCursor == null || logCursor.blockValid != logCursor) {
            throw new LogException(null, 20, 1);
        }
        if (this.blockValid != this) {
            throw new LogException(null, 20, 2);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 3);
        }
        this.cursors.removeElement(logCursor);
        logCursor.finalize();
    }

    LogExtent positionFilePointer(LogLSN logLSN, int n, int n2) throws LogException {
        boolean bl = false;
        LogExtent logExtent = (LogExtent)this.extentTable.get(new Integer(logLSN.extent));
        if (logExtent == null) {
            logExtent = this.openExtent(logLSN.extent);
            bl = true;
        }
        if (logExtent.cursorPosition != logLSN.offset + n || logExtent.lastAccess != n2) {
            int n3 = logLSN.offset + n > logExtent.cursorPosition ? logLSN.offset + n - logExtent.cursorPosition : logExtent.cursorPosition - logLSN.offset - n;
            try {
                if (logExtent.lastAccess == 0 || logLSN.offset + n < n3) {
                    logExtent.fileHandle.fileSeek(logLSN.offset + n, 1);
                } else {
                    logExtent.fileHandle.fileSeek(logLSN.offset + n - logExtent.cursorPosition, 0);
                }
            }
            catch (LogException logException) {
                if (bl) {
                    this.extentTable.remove(new Integer(logLSN.extent));
                    logExtent.finalize();
                }
                throw new LogException(null, 3, 3);
            }
            logExtent.cursorPosition = logLSN.offset + n;
            logExtent.lastAccess = n2;
        }
        return logExtent;
    }

    private void freeCushion() {
        if (this.cushionExists) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    LogHandle.this.logControl.cushionFile.delete();
                    return null;
                }
            });
            this.cushionExists = false;
        }
    }

    void restoreCushion(boolean bl) throws LogException {
        if (!this.logControl.cushionFile.exists()) {
            LogFileHandle logFileHandle;
            int n = 14;
            try {
                logFileHandle = new LogFileHandle(this.logControl.cushionFile, n);
            }
            catch (LogException logException) {
                if (bl && !this.upcallInProgress) {
                    this.upcallInProgress = true;
                    this.upcallTarget.upcall(1);
                    this.upcallInProgress = false;
                }
                throw new LogException(null, 2, 3);
            }
            try {
                logFileHandle.allocFileStorage(65536);
            }
            catch (LogException logException) {
                logFileHandle.finalize();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        LogHandle.this.logControl.cushionFile.delete();
                        return null;
                    }
                });
                if (bl && !this.upcallInProgress) {
                    this.upcallInProgress = true;
                    this.upcallTarget.upcall(1);
                    this.upcallInProgress = false;
                }
                this.cushionExists = false;
                throw new LogException(null, 2, 4);
            }
            logFileHandle.finalize();
        }
        this.cushionExists = true;
    }

    void writeControlFile() throws LogException {
        Object object;
        Enumeration enumeration = this.extentTable.elements();
        while (enumeration.hasMoreElements()) {
            object = (LogExtent)enumeration.nextElement();
            if (!((LogExtent)object).writtenSinceLastForce) continue;
            try {
                ((LogExtent)object).fileHandle.fileSync();
                ((LogExtent)object).writtenSinceLastForce = false;
            }
            catch (LogException logException) {
                throw new LogException(null, 13, 14);
            }
        }
        this.logFileHandle.fileSeek(0L, 1);
        object = new byte[24];
        this.logControlDescriptor.toBytes((byte[])object, 0);
        int n = this.logFileHandle.fileWrite((byte[])object);
    }

    LogExtent openExtent(int n) throws LogException {
        LogFileHandle logFileHandle;
        LogExtent logExtent;
        File file = this.logControl.extentFile(this.logFileName, LogExtent.modExtent(n));
        int n2 = 6;
        if (this.logControl.logReadOnly) {
            n2 = 1;
        }
        if ((logExtent = new LogExtent(n, logFileHandle = new LogFileHandle(file, n2), file)) == null) {
            logFileHandle.finalize();
            throw new LogException(null, 12, 2);
        }
        this.extentTable.put(new Integer(n), logExtent);
        logExtent.blockValid = logExtent;
        return logExtent;
    }

    void freeFileStorage(LogLSN logLSN) throws LogException {
        int n = logLSN.offset;
        if (n == 0) {
            return;
        }
        LogLSN logLSN2 = new LogLSN(logLSN.extent, 0);
        LogExtent logExtent = this.positionFilePointer(logLSN2, 0, 0);
        logExtent.fileHandle.fileSync();
    }

    static void checkRestart(LogFileHandle logFileHandle, int n, int[] nArray) throws LogException {
        nArray[0] = 0;
        nArray[1] = 0;
        byte[] byArray = new byte[12];
        int n2 = LogHandle.restartPosition(n);
        logFileHandle.fileSeek(n2, 1);
        int n3 = logFileHandle.fileRead(byArray);
        LogRestartDescriptor logRestartDescriptor = new LogRestartDescriptor(byArray, 0);
        if (n3 > 0 && logRestartDescriptor.restartValid == LogHandle.restartPosition(n)) {
            logFileHandle.fileSeek(logRestartDescriptor.restartDataLength, 0);
            n3 = logFileHandle.fileRead(byArray);
            LogRestartDescriptor logRestartDescriptor2 = new LogRestartDescriptor(byArray, 0);
            if (logRestartDescriptor.equals(logRestartDescriptor2)) {
                nArray[0] = logRestartDescriptor.restartDataLength;
                nArray[1] = logRestartDescriptor.timeStamp;
            } else {
                throw new LogException(null, 4, 1);
            }
        }
    }

    void dump() throws LogException {
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        Enumeration enumeration = this.extentTable.elements();
        while (enumeration.hasMoreElements()) {
            LogExtent logExtent = (LogExtent)enumeration.nextElement();
        }
        Enumeration enumeration2 = this.cursors.elements();
        while (enumeration2.hasMoreElements()) {
            LogCursor logCursor = (LogCursor)enumeration2.nextElement();
        }
    }

    void cleanUpExtents() {
        Enumeration enumeration = this.extentTable.elements();
        while (enumeration.hasMoreElements()) {
            LogExtent logExtent = (LogExtent)enumeration.nextElement();
            this.extentTable.remove(new Integer(logExtent.extentNumber));
            logExtent.finalize();
        }
        this.extentTable = null;
    }

    static final int alternateRestart(int n) {
        return n == 1 ? 2 : 1;
    }

    static final int restartPosition(int n) {
        return n == 1 ? 4096 : 20480;
    }

    final String logFileName() {
        return this.logFileName;
    }
}

