/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.ejb.Container;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class UserTransactionImpl
implements UserTransaction,
Serializable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    private static final boolean debug = false;
    private transient J2EETransactionManager transactionManager;
    private transient InvocationManager invocationManager;
    private transient boolean initialized;
    private transient UserTransaction userTx;
    private transient int transactionTimeout;

    public UserTransactionImpl() {
        this.init();
    }

    private void init() {
        this.initialized = true;
        Switch switch_ = Switch.getSwitch();
        this.transactionManager = switch_.getTransactionManager();
        this.invocationManager = switch_.getInvocationManager();
        if (this.transactionManager == null) {
            this.userTx = new com.sun.jts.jta.UserTransactionImpl();
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.begin();
            return;
        }
        if (this.transactionTimeout > 0) {
            this.transactionManager.begin(this.transactionTimeout);
        } else {
            this.transactionManager.begin();
        }
        ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new InvocationException();
        }
        try {
            if (componentInvocation.container instanceof Container) {
                ((Container)componentInvocation.container).doAfterBegin(componentInvocation);
            }
            if (componentInvocation.getInvocationType() == 2) {
                throw new NotSupportedException("UserTransaction not supported in application client");
            }
            componentInvocation.setTransaction(this.transactionManager.getTransaction());
            this.transactionManager.enlistComponentResources();
        }
        catch (RemoteException remoteException) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_begin", remoteException);
            throw new SystemException();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.commit();
            return;
        }
        try {
            this.transactionManager.delistComponentResources(false);
            this.transactionManager.commit();
        }
        catch (RemoteException remoteException) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_commit", remoteException);
            throw new SystemException();
        }
        finally {
            ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
            if (componentInvocation == null) {
                throw new InvocationException();
            }
            componentInvocation.setTransaction(null);
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.rollback();
            return;
        }
        try {
            this.transactionManager.delistComponentResources(false);
            this.transactionManager.rollback();
        }
        catch (RemoteException remoteException) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_rollback", remoteException);
            throw new SystemException();
        }
        finally {
            ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
            if (componentInvocation == null) {
                throw new InvocationException();
            }
            componentInvocation.setTransaction(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setRollbackOnly();
            return;
        }
        this.transactionManager.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            return this.userTx.getStatus();
        }
        return this.transactionManager.getStatus();
    }

    public void setTransactionTimeout(int n) throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setTransactionTimeout(n);
            return;
        }
        if (n < 0) {
            n = 0;
        }
        this.transactionTimeout = n;
    }
}

