/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.sqlgen;

import com.sun.ejb.PMDeployer;
import com.sun.ejb.PersistenceUtils;
import com.sun.ejb.ejbql.EjbQLDriver;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.sqlgen.DBInfo;
import com.sun.ejb.sqlgen.DBMetaData;
import com.sun.ejb.sqlgen.SQLTypeMapper;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;

public final class SQLGenerator {
    private static final boolean debug = false;
    private PersistenceDescriptor pers;
    private String tableName;
    private String[] pkeyFieldNames;
    private String[] contMgFieldNames;
    private String[] contMgNoPkeyFieldNames;
    private String whereClause;
    private String createTableQuery;
    private String deleteTableQuery;
    private String loadRowQuery;
    private String storeRowQuery;
    private String createRowQuery;
    private String deleteRowQuery;
    private String findByPrimaryKeyQuery;
    private String findBySourceKeyQuery;
    private String findBySinkKeyQuery;
    private String nonPrimaryKeyFinderQuery;
    private Hashtable findQueryTable = new Hashtable();
    private SQLTypeMapper typeMapper;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$sqlgen$SQLGenerator == null ? (class$com$sun$ejb$sqlgen$SQLGenerator = SQLGenerator.class$("com.sun.ejb.sqlgen.SQLGenerator")) : class$com$sun$ejb$sqlgen$SQLGenerator);
    private boolean isMSSqlServer = false;
    static /* synthetic */ Class class$com$sun$ejb$sqlgen$SQLGenerator;

    private SQLGenerator(PersistenceDescriptor persistenceDescriptor, String string, SQLTypeMapper sQLTypeMapper, DBMetaData dBMetaData) {
        this.pers = persistenceDescriptor;
        this.typeMapper = sQLTypeMapper;
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPersistentFieldInfo();
        PersistentFieldInfo[] persistentFieldInfoArray2 = persistenceDescriptor.getNonPkeyPersFieldInfo();
        PersistentFieldInfo[] persistentFieldInfoArray3 = persistenceDescriptor.getPkeyFieldInfo();
        String string2 = "Table";
        int n = dBMetaData.maxTableNameLength - 2;
        int n2 = dBMetaData.maxColumnNameLength - 2;
        if (dBMetaData.dbName.toLowerCase().indexOf("microsoft") != -1) {
            this.isMSSqlServer = true;
        }
        String string3 = string;
        String string4 = string3.substring(string3.lastIndexOf(".") + 1);
        this.tableName = string4 + string2;
        if (this.tableName.length() > n) {
            this.tableName = this.tableName.substring(0, n);
        }
        this.tableName = "\"" + this.tableName + "\"";
        persistenceDescriptor.setTableName(this.tableName);
        String[] stringArray = new String[persistentFieldInfoArray.length];
        int n3 = 0;
        while (n3 < persistentFieldInfoArray.length) {
            String string5 = persistentFieldInfoArray[n3].name;
            if (string5.length() > n2) {
                Log.err.println(localStrings.getLocalString("ejb.sqlgen.fieldnamewillbetruncatedtomaxchars", "Warning: field name {0} will be truncated to {1} characters to get column name.", new Object[]{string5, new Integer(n2)}));
                string5 = string5.substring(0, n2);
            }
            stringArray[n3] = string5 = "\"" + string5 + "\"";
            persistentFieldInfoArray[n3].columnName = string5;
            ++n3;
        }
        this.contMgFieldNames = stringArray;
        stringArray = new String[persistentFieldInfoArray2.length];
        int n4 = 0;
        while (n4 < persistentFieldInfoArray2.length) {
            String string6 = persistentFieldInfoArray2[n4].name;
            if (string6.length() > n2) {
                string6 = string6.substring(0, n2);
            }
            stringArray[n4] = string6 = "\"" + string6 + "\"";
            persistentFieldInfoArray2[n4].columnName = string6;
            ++n4;
        }
        this.contMgNoPkeyFieldNames = stringArray;
        stringArray = new String[persistentFieldInfoArray3.length];
        int n5 = 0;
        while (n5 < persistentFieldInfoArray3.length) {
            String string7 = persistentFieldInfoArray3[n5].name;
            if (string7.length() > n2) {
                string7 = string7.substring(0, n2);
            }
            stringArray[n5] = string7 = "\"" + string7 + "\"";
            persistentFieldInfoArray3[n5].columnName = string7;
            ++n5;
        }
        this.pkeyFieldNames = stringArray;
        try {
            this.generateWhereClause();
            this.generateCreateTableQuery();
            this.generateDeleteTableQuery();
            this.generateLoadRowQuery();
            this.generateStoreRowQuery();
            this.generateCreateRowQuery();
            this.generateDeleteRowQuery();
            this.generateFindByPrimaryKeyQuery();
            this.generateNonPrimaryKeyFinderQuery();
            if (persistenceDescriptor.getParentDescriptor() instanceof JoinObjectDescriptor) {
                this.generateFindBySourceSinkKeyQuery();
            }
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public static void generateSQL(EjbBundleDescriptor ejbBundleDescriptor, ResourceReferenceDescriptor resourceReferenceDescriptor, boolean bl, DBInfo dBInfo) throws Exception {
        Object object;
        Object[] objectArray = ejbBundleDescriptor.getEjbs().toArray();
        boolean bl2 = false;
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof EjbCMPEntityDescriptor) {
                bl2 = true;
                break;
            }
            ++n;
        }
        if (!bl2) {
            return;
        }
        if (resourceReferenceDescriptor == null || resourceReferenceDescriptor.getResourcePrincipal() == null) {
            throw new RuntimeException("No database specified for CMP EntityBeans' persistent state");
        }
        ResourcePrincipal resourcePrincipal = resourceReferenceDescriptor.getResourcePrincipal();
        DBMetaData dBMetaData = dBInfo.getDBMetaData(resourceReferenceDescriptor.getJndiName(), resourcePrincipal.getName(), resourcePrincipal.getPassword());
        SQLTypeMapper sQLTypeMapper = new SQLTypeMapper();
        sQLTypeMapper.initializeMapping(dBMetaData);
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof EjbCMPEntityDescriptor) {
                object = (EjbCMPEntityDescriptor)objectArray[n2];
                SQLGenerator.generateSQL((EjbCMPEntityDescriptor)object, bl, dBMetaData, sQLTypeMapper);
            }
            ++n2;
        }
        object = new EjbQLDriver(ejbBundleDescriptor);
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)objectArray[n3];
                SQLGenerator.generateSQLForEjbQLQueries(ejbCMPEntityDescriptor.getPersistenceDescriptor(), (EjbQLDriver)object);
            }
            ++n3;
        }
    }

    private static void generateSQL(EjbCMPEntityDescriptor ejbCMPEntityDescriptor, boolean bl, DBMetaData dBMetaData, SQLTypeMapper sQLTypeMapper) throws Exception {
        PersistenceDescriptor persistenceDescriptor = ejbCMPEntityDescriptor.getPersistenceDescriptor();
        String string = ejbCMPEntityDescriptor.getEjbClassName();
        EjbBundleDescriptor ejbBundleDescriptor = persistenceDescriptor.getEjbBundleDescriptor();
        PersistenceUtils.getPMDeployer(ejbBundleDescriptor).addForeignKeyFields(persistenceDescriptor);
        SQLGenerator sQLGenerator = new SQLGenerator(persistenceDescriptor, string, sQLTypeMapper, dBMetaData);
        sQLGenerator.storeIntoDescriptor(bl);
        SQLGenerator.generateJoinObjectSQL(persistenceDescriptor, sQLTypeMapper, dBMetaData, bl);
    }

    private static void generateJoinObjectSQL(PersistenceDescriptor persistenceDescriptor, SQLTypeMapper sQLTypeMapper, DBMetaData dBMetaData, boolean bl) {
        EjbBundleDescriptor ejbBundleDescriptor = persistenceDescriptor.getEjbBundleDescriptor();
        PMDeployer pMDeployer = PersistenceUtils.getPMDeployer(ejbBundleDescriptor);
        Vector vector = pMDeployer.addJoinObjectDescriptors(persistenceDescriptor);
        int n = 0;
        while (n < vector.size()) {
            JoinObjectDescriptor joinObjectDescriptor = (JoinObjectDescriptor)vector.elementAt(n);
            PersistenceDescriptor persistenceDescriptor2 = joinObjectDescriptor.getPersistenceDescriptor();
            SQLGenerator sQLGenerator = new SQLGenerator(persistenceDescriptor2, joinObjectDescriptor.getJoinObjectClass(), sQLTypeMapper, dBMetaData);
            sQLGenerator.storeIntoDescriptor(bl);
            ++n;
        }
    }

    private void storeIntoDescriptor(boolean bl) {
        Object object;
        Object object2;
        Iterator iterator = this.pers.getAllSqlStatementedMethods().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = this.pers.getSqlStatementFor((String)object2);
            if (!bl && object != null && !((String)object).equals("")) continue;
            if (((String)object2).equals("createRow")) {
                this.pers.setSqlStatementFor((String)object2, this.createRowQuery);
                continue;
            }
            if (((String)object2).equals("deleteRow")) {
                this.pers.setSqlStatementFor((String)object2, this.deleteRowQuery);
                continue;
            }
            if (((String)object2).equals("storeRow")) {
                this.pers.setSqlStatementFor((String)object2, this.storeRowQuery);
                continue;
            }
            if (((String)object2).equals("loadRow")) {
                this.pers.setSqlStatementFor((String)object2, this.loadRowQuery);
                continue;
            }
            if (((String)object2).equals("findByPrimaryKey")) {
                this.pers.setSqlStatementFor((String)object2, this.findByPrimaryKeyQuery);
                continue;
            }
            if (((String)object2).equals("findBySourceKey")) {
                this.pers.setSqlStatementFor((String)object2, this.findBySourceKeyQuery);
                continue;
            }
            if (((String)object2).equals("findBySinkKey")) {
                this.pers.setSqlStatementFor((String)object2, this.findBySinkKeyQuery);
                continue;
            }
            if (((String)object2).startsWith("createTable")) {
                this.pers.setSqlStatementFor((String)object2, this.createTableQuery);
                continue;
            }
            if (!((String)object2).startsWith("deleteTable")) continue;
            this.pers.setSqlStatementFor((String)object2, this.deleteTableQuery);
        }
        object2 = this.pers.getAllPossibleQueriedMethods().iterator();
        while (object2.hasNext()) {
            object = (Method)object2.next();
            QueryDescriptor queryDescriptor = this.pers.getQueryFor((Method)object);
            if (queryDescriptor == null) {
                queryDescriptor = new QueryDescriptor();
                queryDescriptor.setQueryMethod((Method)object);
                this.pers.setQueryFor((Method)object, queryDescriptor);
            }
            if (queryDescriptor.getIsEjbQl() || !bl && queryDescriptor.getSQL() != null && !queryDescriptor.getSQL().equals("")) continue;
            queryDescriptor.setSQL(this.nonPrimaryKeyFinderQuery);
        }
    }

    private void printQueries() {
        System.err.println("findByPrimaryKey query: " + this.findByPrimaryKeyQuery);
        System.err.println("loadRowQuery query: " + this.loadRowQuery);
        System.err.println("storeRowQuery query: " + this.storeRowQuery);
        System.err.println("deleteRowQuery query: " + this.deleteRowQuery);
        System.err.println("createRowQuery query: " + this.createRowQuery);
        System.err.println("Table Create query: " + this.createTableQuery);
        System.err.println("Table Remove query: " + this.deleteTableQuery);
        if (this.pers.getParentDescriptor() instanceof JoinObjectDescriptor) {
            System.err.println("findBySourceKey query: " + this.findBySourceKeyQuery);
            System.err.println("findBySinkKey query: " + this.findBySinkKeyQuery);
        }
    }

    private void generateWhereClause() {
        String string = " WHERE ";
        int n = 0;
        while (n < this.pkeyFieldNames.length) {
            if (n > 0) {
                string = string + " AND ";
            }
            string = string + this.pkeyFieldNames[n] + " = ? ";
            ++n;
        }
        this.whereClause = string;
    }

    private void generateCreateTableQuery() {
        Object object;
        String string = "CREATE TABLE " + this.tableName + " (";
        int n = 0;
        while (n < this.contMgFieldNames.length) {
            int n2;
            if (n > 0) {
                string = string + " , ";
            }
            object = this.pers.getPersistentFieldInfo()[n].type;
            String string2 = this.typeMapper.getSQLTypeFor((Class)object);
            string = string + this.contMgFieldNames[n] + " " + string2;
            if (((Class)object).isPrimitive()) {
                string = string + " NOT NULL";
            } else if (this.isMSSqlServer && !this.isPkeyField(this.contMgFieldNames[n]) && (n2 = this.typeMapper.getJDBCTypeFor((Class)object)) != -7) {
                string = string + " NULL";
            }
            ++n;
        }
        object = "\"pk_" + this.tableName.substring(1, this.tableName.length() - 2) + "\"";
        string = string + ", CONSTRAINT " + (String)object + " PRIMARY KEY (";
        int n3 = 0;
        while (n3 < this.pkeyFieldNames.length) {
            if (n3 > 0) {
                string = string + " , ";
            }
            string = string + this.pkeyFieldNames[n3];
            ++n3;
        }
        this.createTableQuery = string = string + ") )";
    }

    private boolean isPkeyField(String string) {
        int n = 0;
        while (n < this.pkeyFieldNames.length) {
            if (this.pkeyFieldNames[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void generateDeleteTableQuery() {
        this.deleteTableQuery = "DROP TABLE " + this.tableName;
    }

    private void generateNonPrimaryKeyFinderQuery() {
        this.nonPrimaryKeyFinderQuery = "SELECT ";
        int n = 0;
        while (n < this.pkeyFieldNames.length) {
            if (n > 0) {
                this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + " , ";
            }
            this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + this.pkeyFieldNames[n];
            ++n;
        }
        this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + " FROM " + this.tableName;
    }

    private void generateFindByPrimaryKeyQuery() {
        this.findByPrimaryKeyQuery = "SELECT ";
        int n = 0;
        while (n < this.pkeyFieldNames.length) {
            if (n > 0) {
                this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + " , ";
            }
            this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + this.pkeyFieldNames[n];
            ++n;
        }
        this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + " FROM " + this.tableName + this.whereClause;
    }

    private void generateFindBySourceSinkKeyQuery() {
        JoinObjectDescriptor joinObjectDescriptor = (JoinObjectDescriptor)this.pers.getParentDescriptor();
        RelationshipDescriptor relationshipDescriptor = joinObjectDescriptor.getRelationshipDesc();
        RelationRoleDescriptor relationRoleDescriptor = relationshipDescriptor.getSource();
        RelationRoleDescriptor relationRoleDescriptor2 = relationshipDescriptor.getSink();
        PersistenceDescriptor persistenceDescriptor = relationRoleDescriptor.getPersistenceDescriptor();
        PersistenceDescriptor persistenceDescriptor2 = relationRoleDescriptor2.getPersistenceDescriptor();
        PersistentFieldInfo[] persistentFieldInfoArray = this.pers.getPersistentFieldInfo();
        this.findBySourceKeyQuery = "SELECT ";
        this.findBySinkKeyQuery = "SELECT ";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < persistentFieldInfoArray.length) {
            if (persistentFieldInfoArray[n3].relatedObj == persistenceDescriptor2) {
                if (n > 0) {
                    this.findBySourceKeyQuery = this.findBySourceKeyQuery + " , ";
                }
                this.findBySourceKeyQuery = this.findBySourceKeyQuery + persistentFieldInfoArray[n3].columnName;
                ++n;
            } else {
                if (n2 > 0) {
                    this.findBySinkKeyQuery = this.findBySinkKeyQuery + " , ";
                }
                this.findBySinkKeyQuery = this.findBySinkKeyQuery + persistentFieldInfoArray[n3].columnName;
                ++n2;
            }
            ++n3;
        }
        this.findBySourceKeyQuery = this.findBySourceKeyQuery + " FROM " + this.tableName;
        this.findBySinkKeyQuery = this.findBySinkKeyQuery + " FROM " + this.tableName;
        n = 0;
        n2 = 0;
        this.findBySourceKeyQuery = this.findBySourceKeyQuery + " WHERE ";
        this.findBySinkKeyQuery = this.findBySinkKeyQuery + " WHERE ";
        int n4 = 0;
        while (n4 < persistentFieldInfoArray.length) {
            if (persistentFieldInfoArray[n4].relatedObj == persistenceDescriptor2) {
                if (n2 > 0) {
                    this.findBySinkKeyQuery = this.findBySinkKeyQuery + " AND ";
                }
                this.findBySinkKeyQuery = this.findBySinkKeyQuery + persistentFieldInfoArray[n4].columnName + " = ? ";
                ++n2;
            } else {
                if (n > 0) {
                    this.findBySourceKeyQuery = this.findBySourceKeyQuery + " AND ";
                }
                this.findBySourceKeyQuery = this.findBySourceKeyQuery + persistentFieldInfoArray[n4].columnName + " = ? ";
                ++n;
            }
            ++n4;
        }
    }

    private void generateLoadRowQuery() {
        this.loadRowQuery = "SELECT ";
        int n = 0;
        while (n < this.contMgNoPkeyFieldNames.length) {
            if (n > 0) {
                this.loadRowQuery = this.loadRowQuery + " , ";
            }
            this.loadRowQuery = this.loadRowQuery + this.contMgNoPkeyFieldNames[n];
            ++n;
        }
        if (this.contMgNoPkeyFieldNames.length == 0) {
            this.loadRowQuery = this.loadRowQuery + " * ";
        }
        this.loadRowQuery = this.loadRowQuery + " FROM " + this.tableName + this.whereClause;
    }

    private void generateStoreRowQuery() {
        if (this.contMgNoPkeyFieldNames.length == 0) {
            this.storeRowQuery = " ";
            return;
        }
        this.storeRowQuery = "UPDATE " + this.tableName + " SET ";
        int n = 0;
        while (n < this.contMgNoPkeyFieldNames.length) {
            if (n > 0) {
                this.storeRowQuery = this.storeRowQuery + " , ";
            }
            this.storeRowQuery = this.storeRowQuery + this.contMgNoPkeyFieldNames[n] + " = ? ";
            ++n;
        }
        this.storeRowQuery = this.storeRowQuery + this.whereClause;
    }

    private void generateCreateRowQuery() {
        String string = "INSERT INTO " + this.tableName + " ( ";
        int n = 0;
        while (n < this.contMgFieldNames.length) {
            if (n > 0) {
                string = string + " , ";
            }
            string = string + this.contMgFieldNames[n];
            ++n;
        }
        string = string + " ) VALUES ( ";
        int n2 = 0;
        while (n2 < this.contMgFieldNames.length) {
            if (n2 > 0) {
                string = string + " , ";
            }
            string = string + " ? ";
            ++n2;
        }
        this.createRowQuery = string = string + " )";
    }

    private void generateDeleteRowQuery() {
        this.deleteRowQuery = "DELETE FROM " + this.tableName + this.whereClause;
    }

    private static void generateSQLForEjbQLQueries(PersistenceDescriptor persistenceDescriptor, EjbQLDriver ejbQLDriver) throws Exception {
        Set set = persistenceDescriptor.getQueriedMethods();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            QueryDescriptor queryDescriptor = persistenceDescriptor.getQueryFor(method);
            if (!queryDescriptor.getIsEjbQl()) continue;
            String string = queryDescriptor.getQuery();
            EjbQLQuery ejbQLQuery = ejbQLDriver.parse(persistenceDescriptor, method, string);
            String string2 = ejbQLDriver.generateSql(ejbQLQuery);
            System.out.println("Generated sql = " + string2);
            queryDescriptor.setSQL(string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

