/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.portable;

import com.sun.ejb.portable.HomeHandleImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;
import javax.rmi.PortableRemoteObject;

public final class EJBMetaDataImpl
implements EJBMetaData,
Serializable {
    private Class keyClass;
    private Class homeClass;
    private Class remoteClass;
    private boolean isSessionBean;
    private boolean isStatelessSessionBean;
    private HomeHandle homeHandle;
    private transient EJBHome ejbHomeStub;

    public EJBMetaDataImpl(EJBHome eJBHome, Class clazz, Class clazz2, Class clazz3, boolean bl, boolean bl2) {
        this.ejbHomeStub = eJBHome;
        this.homeHandle = new HomeHandleImpl(eJBHome);
        this.keyClass = clazz3;
        this.homeClass = clazz;
        this.remoteClass = clazz2;
        this.isSessionBean = bl;
        this.isStatelessSessionBean = bl2;
    }

    public Class getHomeInterfaceClass() {
        return this.homeClass;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteClass;
    }

    public EJBHome getEJBHome() {
        return this.ejbHomeStub;
    }

    public Class getPrimaryKeyClass() {
        if (this.keyClass == null) {
            throw new RuntimeException("SessionBeans do not have a primary key");
        }
        return this.keyClass;
    }

    public boolean isSession() {
        return this.isSessionBean;
    }

    public boolean isStatelessSession() {
        return this.isStatelessSessionBean;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.isSessionBean = objectInputStream.readBoolean();
        this.isStatelessSessionBean = objectInputStream.readBoolean();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.remoteClass = classLoader.loadClass(objectInputStream.readUTF());
        this.homeClass = classLoader.loadClass(objectInputStream.readUTF());
        if (!this.isSessionBean) {
            this.keyClass = classLoader.loadClass(objectInputStream.readUTF());
        }
        this.homeHandle = (HomeHandle)objectInputStream.readObject();
        this.ejbHomeStub = this.homeHandle.getEJBHome();
        this.ejbHomeStub = (EJBHome)PortableRemoteObject.narrow((Object)this.ejbHomeStub, (Class)this.homeClass);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.isSessionBean);
        objectOutputStream.writeBoolean(this.isStatelessSessionBean);
        objectOutputStream.writeUTF(this.remoteClass.getName());
        objectOutputStream.writeUTF(this.homeClass.getName());
        if (!this.isSessionBean) {
            objectOutputStream.writeUTF(this.keyClass.getName());
        }
        objectOutputStream.writeObject(this.homeHandle);
    }
}

