/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.iplanet.ias.util.threadpool.Servicable;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.cache.Cache;
import com.sun.ejb.containers.util.cache.CacheEntry;
import com.sun.ejb.containers.util.cache.MonitorableCache;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBeanCache
implements Cache,
MonitorableCache {
    protected static final int DEFAULT_CAPACITY = 128;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x100000;
    protected static boolean debug = false;
    protected transient CacheEntry[] table;
    protected float loadFactor;
    protected transient int size;
    protected int bucketmask;
    protected int capacity;
    protected int threshold;
    protected int maxBeansInCache;
    protected int numberOfVictimsToSelect;
    protected boolean cacheOverflowTolerated;
    protected int idleInCacheTimeoutInSeconds;
    protected String victimSelectionPolicy;
    protected int removalTimeoutInSeconds;
    protected int cacheHits;
    protected int cacheMisses;
    protected int victimCount;
    private boolean inSelectingVictims = false;
    private Object victimSemaphore = new Object();
    private Object timerSemaphore = new Object();
    protected boolean timerValid = true;
    private TimerTask cacheVictimSelector;
    private TimerTask idleBeansPassivator;
    protected int cacheSuccess;
    protected int cacheFailures;
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    protected boolean performReaping = true;

    public void destroy() {
    }

    public AbstractBeanCache() {
        this(128, 0.75f);
    }

    public AbstractBeanCache(int n) {
        this(n, 0.75f);
    }

    public AbstractBeanCache(int n, float f) {
        if (n > 0x100000) {
            n = 0x100000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        this.capacity = n;
        this.loadFactor = f;
    }

    protected void initializeCache(int n, int n2, boolean bl, int n3, boolean bl2) {
        block4: {
            if (this.capacity > 0x100000) {
                this.capacity = 0x100000;
            }
            this.threshold = (int)((float)this.capacity * this.loadFactor);
            while (this.threshold < 0x100000 && this.threshold <= n) {
                this.capacity <<= 1;
                this.threshold = (int)((float)this.capacity * this.loadFactor);
            }
            this.table = new CacheEntry[this.capacity];
            this.bucketmask = this.capacity - 1;
            this.maxBeansInCache = n;
            this.numberOfVictimsToSelect = n2;
            this.cacheOverflowTolerated = bl;
            this.idleInCacheTimeoutInSeconds = n3;
            this.performReaping = bl2;
            if (!bl2 || n3 <= 0) break block4;
            this.idleBeansPassivator = new IdleBeansPassivator();
            try {
                ContainerFactoryImpl.getTimer().scheduleAtFixedRate(this.idleBeansPassivator, n3 * 1000, (long)(n3 * 1000));
            }
            catch (Throwable throwable) {
                _logger.log(Level.WARNING, "[AbstractBeanCache]: Could not add  idleBeansPassivator... Continuing anyway...");
            }
        }
    }

    protected abstract void passivateIdleBeans();

    protected abstract void selectVictims();

    protected CacheEntry createCacheEntry(Object object, int n, Object object2, CacheEntry cacheEntry) {
        return new CacheEntry(object, n, object2, cacheEntry);
    }

    protected void cacheEntryAccessed(CacheEntry cacheEntry) {
    }

    protected void cacheEntryRemoved(CacheEntry cacheEntry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimerTasks() {
        try {
            Object object = this.timerSemaphore;
            synchronized (object) {
                this.timerValid = false;
                if (this.idleBeansPassivator != null) {
                    this.idleBeansPassivator.cancel();
                }
                if (this.cacheVictimSelector != null) {
                    this.cacheVictimSelector.cancel();
                }
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "[AbstractBeanCache]: cancelTimerTask: " + throwable.toString());
        }
    }

    public boolean contains(Object object) {
        int n = object.hashCode();
        CacheEntry cacheEntry = this.table[n & this.bucketmask];
        while (cacheEntry != null) {
            if (cacheEntry.keyHashCode == n && cacheEntry.key.equals(object)) {
                ++this.cacheHits;
                return true;
            }
            cacheEntry = cacheEntry.next;
        }
        ++this.cacheMisses;
        return false;
    }

    public Object get(Object object) {
        int n = object.hashCode();
        CacheEntry cacheEntry = this.table[n & this.bucketmask];
        while (cacheEntry != null) {
            if (cacheEntry.keyHashCode == n && cacheEntry.key.equals(object)) {
                ++this.cacheHits;
                this.cacheEntryAccessed(cacheEntry);
                return cacheEntry.value;
            }
            cacheEntry = cacheEntry.next;
        }
        ++this.cacheMisses;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        block13: {
            Object object3;
            int n;
            int n2 = object.hashCode();
            int n3 = n2 & this.bucketmask;
            CacheEntry cacheEntry = this.table[n3];
            while (cacheEntry != null) {
                if (cacheEntry.keyHashCode == n2 && cacheEntry.key.equals(object)) {
                    Object object4 = cacheEntry.value;
                    cacheEntry.value = object2;
                    return object4;
                }
                cacheEntry = cacheEntry.next;
            }
            this.table[n3] = this.createCacheEntry(object, n2, object2, this.table[n3]);
            if (this.size++ >= this.threshold) {
                n = 2 * this.capacity;
                object3 = new CacheEntry[n];
                this.transfer((CacheEntry[])object3);
                this.table = object3;
                this.capacity = n;
                this.threshold = (int)((float)n * this.loadFactor);
                this.bucketmask = this.capacity - 1;
            }
            if (this.size < this.maxBeansInCache || this.inSelectingVictims) break block13;
            n = 0;
            object3 = this.victimSemaphore;
            synchronized (object3) {
                if (!this.inSelectingVictims) {
                    this.inSelectingVictims = true;
                    n = 1;
                }
            }
            if (this.performReaping && n != 0) {
                try {
                    try {
                        CacheVictimSelector cacheVictimSelector = new CacheVictimSelector();
                        ContainerWorkPool.addLast(cacheVictimSelector);
                    }
                    catch (Exception exception) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, "Cannot add task for victim selction", exception);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!_logger.isLoggable(Level.WARNING)) break block13;
                    _logger.log(Level.WARNING, "[AbstractBeanCache]: Could not add  cacheVictimSelector... Continuing anyway...", throwable);
                }
            }
        }
        return null;
    }

    protected void transfer(CacheEntry[] cacheEntryArray) {
        CacheEntry[] cacheEntryArray2 = this.table;
        int n = cacheEntryArray.length;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < cacheEntryArray2.length) {
            CacheEntry cacheEntry = cacheEntryArray2[n3];
            if (cacheEntry != null) {
                CacheEntry cacheEntry2;
                cacheEntryArray2[n3] = null;
                do {
                    cacheEntry2 = cacheEntry.next;
                    int n4 = cacheEntry.keyHashCode & n2;
                    cacheEntry.next = cacheEntryArray[n4];
                    cacheEntryArray[n4] = cacheEntry;
                } while ((cacheEntry = cacheEntry2) != null);
            }
            ++n3;
        }
    }

    public Object remove(Object object) {
        CacheEntry cacheEntry;
        int n = object.hashCode();
        int n2 = n & this.bucketmask;
        CacheEntry cacheEntry2 = cacheEntry = this.table[n2];
        while (cacheEntry2 != null) {
            if (cacheEntry2.keyHashCode == n && cacheEntry2.key.equals(object)) {
                --this.size;
                if (cacheEntry == cacheEntry2) {
                    this.table[n2] = cacheEntry2.next;
                } else {
                    cacheEntry.next = cacheEntry2.next;
                }
                ++this.cacheHits;
                cacheEntry2.next = null;
                this.cacheEntryRemoved(cacheEntry2);
                return cacheEntry2.value;
            }
            cacheEntry = cacheEntry2;
            cacheEntry2 = cacheEntry2.next;
        }
        ++this.cacheMisses;
        return null;
    }

    public Enumeration elements() {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.capacity) {
            CacheEntry cacheEntry = this.table[n];
            while (cacheEntry != null) {
                vector.addElement(cacheEntry.value);
                cacheEntry = cacheEntry.next;
            }
            ++n;
        }
        return vector.elements();
    }

    public Iterator values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.capacity) {
            CacheEntry cacheEntry = this.table[n];
            while (cacheEntry != null) {
                arrayList.add(cacheEntry.value);
                cacheEntry = cacheEntry.next;
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public Iterator keys() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.capacity) {
            CacheEntry cacheEntry = this.table[n];
            while (cacheEntry != null) {
                arrayList.add(cacheEntry.key);
                cacheEntry = cacheEntry.next;
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        _logger.log(Level.FINE, "[AbstractBeanCache]: Clearing " + this.size + " entries from cache....");
        int n = 0;
        while (n < this.table.length) {
            this.table[n] = null;
            ++n;
        }
        this.size = 0;
    }

    public int getMaxCacheSize() {
        return this.maxBeansInCache;
    }

    public int getCurrentSize() {
        return this.size;
    }

    public int getResizeQuantity() {
        return this.numberOfVictimsToSelect;
    }

    public boolean isCacheOverflowAllowed() {
        return this.cacheOverflowTolerated;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleInCacheTimeoutInSeconds;
    }

    public int getRemovalTimeoutInSeconds() {
        return this.removalTimeoutInSeconds;
    }

    public String getVictimSelectionPolicy() {
        return this.victimSelectionPolicy;
    }

    public int getCacheHits() {
        return this.cacheSuccess;
    }

    public int getCacheMisses() {
        return this.cacheFailures;
    }

    public int getVictimCount() {
        return this.victimCount;
    }

    public String getAllAttrValues() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" :CACHE -> maxCachesize:=").append(this.maxBeansInCache).append(";").append("currentSize=").append(this.size).append(";").append("cacheHits=").append(this.cacheHits).append(";").append("cacheMisses=").append(this.cacheMisses).append(";");
        return stringBuffer.toString();
    }

    public void incrementCacheSuccess() {
        ++this.cacheSuccess;
    }

    public void incrementCacheFailures() {
        ++this.cacheFailures;
    }

    public void incrementCacheFailures(Object object) {
    }

    public void incrementCacheSuccess(Object object) {
    }

    private class IdleBeansPassivator
    extends TimerTask {
        private IdleBeansPassivator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: {
                try {
                    boolean bl = true;
                    Object object = AbstractBeanCache.this.timerSemaphore;
                    synchronized (object) {
                        bl = AbstractBeanCache.this.timerValid;
                    }
                    if (bl) {
                        try {
                            IdleBeanWork idleBeanWork = new IdleBeanWork();
                            ContainerWorkPool.addLast(idleBeanWork);
                        }
                        catch (Exception exception) {
                            if (!_logger.isLoggable(Level.WARNING)) break block8;
                            _logger.log(Level.WARNING, "Cannot perform  idle bean cleanup", exception);
                        }
                        break block8;
                    }
                    super.cancel();
                }
                catch (Throwable throwable) {
                    if (!_logger.isLoggable(Level.WARNING)) break block8;
                    _logger.log(Level.WARNING, "[IdleBeansPassivator]: Error during passivateIdleBeans. " + throwable);
                }
            }
        }
    }

    private class CacheVictimSelector
    implements Servicable {
        private CacheVictimSelector() {
        }

        public void prolog() {
        }

        public void epilog() {
        }

        public void service() {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block11: {
                    try {
                        boolean bl = true;
                        Object object = AbstractBeanCache.this.timerSemaphore;
                        synchronized (object) {
                            bl = AbstractBeanCache.this.timerValid;
                            if (!bl) break block11;
                        }
                        AbstractBeanCache.this.selectVictims();
                    }
                    catch (Throwable throwable) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, "[CacheTimerTask]: Error during selectingVictims ", throwable);
                        }
                        Object var5_5 = null;
                        Object object = AbstractBeanCache.this.victimSemaphore;
                        synchronized (object) {
                            AbstractBeanCache.this.inSelectingVictims = false;
                            return;
                        }
                    }
                }
                Object var5_4 = null;
                Object object = AbstractBeanCache.this.victimSemaphore;
                synchronized (object) {
                    AbstractBeanCache.this.inSelectingVictims = false;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                Object object2 = AbstractBeanCache.this.victimSemaphore;
                synchronized (object2) {
                    AbstractBeanCache.this.inSelectingVictims = false;
                    throw throwable;
                }
            }
        }
    }

    private class IdleBeanWork
    implements Servicable {
        private IdleBeanWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        public void run() {
            AbstractBeanCache.this.passivateIdleBeans();
        }
    }
}

