/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.EjbContainer;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.deployment.IASEjbExtraDescriptors;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.ArrayListStack;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.BeanContext;
import com.sun.ejb.containers.CommitCEntityContainer;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.containers.MessageBeanContainer;
import com.sun.ejb.containers.PMTransactionManagerImpl;
import com.sun.ejb.containers.ReadOnlyBeanContainer;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.ejb.containers.util.LongHashMap;
import com.sun.ejb.containers.util.PoolCacheTimer;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.NoSuchObjectLocalException;
import javax.naming.InvalidNameException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public final class ContainerFactoryImpl
implements ContainerFactory {
    private boolean debugMonitoring = false;
    private long debugMonitoringPeriodMS = 30000L;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static final boolean debug = false;
    public static final byte HOME_KEY = -1;
    public static final byte[] homeInstanceKey = new byte[]{-1};
    private PMTransactionManagerImpl pmtm;
    private Hashtable syncTable = new Hashtable();
    LongHashMap containers = new LongHashMap(128);
    private ThreadLocal threadLocalContext = new ThreadLocal();
    private Hashtable txBeanTable = new Hashtable();
    private static PoolCacheTimer _timer = new PoolCacheTimer();
    private PoolCacheTimer _localTimer;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$containers$ContainerFactoryImpl == null ? (class$com$sun$ejb$containers$ContainerFactoryImpl = ContainerFactoryImpl.class$("com.sun.ejb.containers.ContainerFactoryImpl")) : class$com$sun$ejb$containers$ContainerFactoryImpl);
    static /* synthetic */ Class class$com$sun$ejb$containers$ContainerFactoryImpl;

    public ContainerFactoryImpl() {
        this.pmtm = new PMTransactionManagerImpl();
        this._localTimer = _timer;
        this.getDebugMonitoringDetails();
        if (this.debugMonitoring) {
            _timer.schedule((TimerTask)new DebugMonitor(), 0L, this.debugMonitoringPeriodMS);
        }
    }

    private void getDebugMonitoringDetails() {
        try {
            String string;
            Properties properties = System.getProperties();
            String string2 = properties.getProperty("MONITOR_EJB_CONTAINER");
            if (null != string2 && (string2.startsWith("TRUE") || string2.startsWith("true"))) {
                this.debugMonitoring = true;
            }
            if (null != (string = properties.getProperty("MONITOR_EJB_TIME_PERIOD_SECONDS"))) {
                this.debugMonitoringPeriodMS = new Long(string) * 1000L;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ContainerFactoryImpl.getDebugMonitoringDetails(), Exception when trying to get the System properties - ", exception.toString());
        }
    }

    public static Timer getTimer() {
        return _timer;
    }

    public TransactionManager getTransactionMgr() {
        return this.pmtm;
    }

    public Container createContainer(EjbDescriptor ejbDescriptor, ClassLoader classLoader, SecurityManager securityManager) throws Exception {
        Object object;
        BaseContainer baseContainer = null;
        boolean bl = true;
        String string = null;
        String string2 = ejbDescriptor.getApplication().getRegistrationName();
        String string3 = ejbDescriptor.getEjbBundleDescriptor().getArchivist().getArchiveUri();
        String string4 = FileUtils.makeFriendlyFilename(string3);
        String string5 = ejbDescriptor.getName();
        IASEjbExtraDescriptors iASEjbExtraDescriptors = null;
        Server server = null;
        EjbContainer ejbContainer = null;
        if (!(ejbDescriptor instanceof EjbMessageBeanDescriptor) && ((object = ejbDescriptor.getJndiName()) == null || "".equals(object))) {
            String string6 = localStrings.getLocalString("containers.invalid_jndi_name", "Invalid jndi name [{0}] found in application [{1}]; module [{2}]; ejb [{3}]. Please populate the jndi element and restart the server.", new Object[]{object, string2, string3, string5});
            throw new InvalidNameException(string6);
        }
        try {
            if (ejbDescriptor instanceof EjbSessionDescriptor) {
                object = (EjbSessionDescriptor)ejbDescriptor;
                baseContainer = ((EjbSessionDescriptor)object).isStateless() ? new StatelessSessionContainer(ejbDescriptor, classLoader) : new StatefulSessionContainer(ejbDescriptor, classLoader);
            } else if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                baseContainer = new MessageBeanContainer(ejbDescriptor, classLoader);
                bl = false;
            } else {
                if (((EjbEntityDescriptor)ejbDescriptor).getIASEjbExtraDescriptors().isIsReadOnlyBean()) {
                    baseContainer = new ReadOnlyBeanContainer(ejbDescriptor, classLoader);
                } else {
                    iASEjbExtraDescriptors = ((EjbEntityDescriptor)ejbDescriptor).getIASEjbExtraDescriptors();
                    if (iASEjbExtraDescriptors != null) {
                        string = iASEjbExtraDescriptors.getCommitOption();
                    }
                    if (string == null) {
                        try {
                            object = ApplicationServer.getServerContext();
                            server = ServerBeansFactory.getServerBean(object.getConfigContext());
                        }
                        catch (ConfigException configException) {
                            _logger.log(Level.WARNING, "ejb.createContainer_exception", configException);
                        }
                        ejbContainer = server.getEjbContainer();
                        string = ejbContainer.getCommitOption();
                    }
                    if (string.equals("A")) {
                        _logger.log(Level.WARNING, "Commit option A is not currently supported, using commint option B " + ejbDescriptor.getName());
                        baseContainer = new EntityContainer(ejbDescriptor, classLoader);
                    } else if (string.equals("C")) {
                        _logger.log(Level.FINE, "Using commit option C for: " + ejbDescriptor.getName());
                        baseContainer = new CommitCEntityContainer(ejbDescriptor, classLoader);
                    } else {
                        _logger.log(Level.FINE, "Using commit option B for: " + ejbDescriptor.getName());
                        baseContainer = new EntityContainer(ejbDescriptor, classLoader);
                    }
                }
                ((EntityContainer)baseContainer).setTxBeanTable(this.txBeanTable);
            }
            this.containers.put(ejbDescriptor.getUniqueId(), baseContainer);
            baseContainer.setSecurityManager(securityManager);
            if (bl) {
                baseContainer.initializeHome();
            }
            baseContainer.setDebugMonitorFlag(this.debugMonitoring);
            return baseContainer;
        }
        catch (InvalidNameException invalidNameException) {
            _logger.log(Level.SEVERE, "ejb.create_container_exception", invalidNameException.toString());
            _logger.log(Level.SEVERE, "Invalid jndiName forappId=" + string2 + "; moduleName=" + string4 + "; ejbName=" + string5);
            _logger.log(Level.SEVERE, "jndiName=" + ejbDescriptor.getJndiName());
            try {
                baseContainer.unregisterEJBMonitorMBean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.removeContainer(ejbDescriptor.getUniqueId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw invalidNameException;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.create_container_exception", exception.toString());
            _logger.log(Level.SEVERE, "appId=" + string2 + " moduleName=" + string4 + " ejbName=" + string5);
            try {
                baseContainer.unregisterEJBMonitorMBean();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                this.removeContainer(ejbDescriptor.getUniqueId());
            }
            catch (Exception exception3) {}
            throw exception;
        }
    }

    public Container getContainer(long l) {
        return (Container)this.containers.get(l);
    }

    public void removeContainer(long l) {
        this.containers.remove(l);
    }

    public Enumeration listContainers() {
        return this.containers.elements();
    }

    public Remote getTargetObject(long l, byte[] byArray) {
        ArrayListStack arrayListStack;
        final BaseContainer baseContainer = (BaseContainer)this.containers.get(l);
        if (baseContainer == null) {
            throw new NoSuchObjectLocalException("Bean does not exist");
        }
        BeanContext beanContext = new BeanContext();
        final Thread thread = Thread.currentThread();
        beanContext.previousClassLoader = thread.getContextClassLoader();
        if (!beanContext.previousClassLoader.equals(baseContainer.getClassLoader())) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    thread.setContextClassLoader(baseContainer.getClassLoader());
                    return null;
                }
            });
            beanContext.classLoaderSwitched = true;
        }
        if ((arrayListStack = (ArrayListStack)this.threadLocalContext.get()) == null) {
            arrayListStack = new ArrayListStack();
            this.threadLocalContext.set(arrayListStack);
        }
        arrayListStack.push(beanContext);
        Object object = byArray.length == 1 && byArray[0] == -1 ? baseContainer.getEJBHome() : baseContainer.getEJBObject(byArray);
        return object;
    }

    public void releaseTargetObject(Remote remote) {
        try {
            ArrayListStack arrayListStack = (ArrayListStack)this.threadLocalContext.get();
            final BeanContext beanContext = (BeanContext)arrayListStack.pop();
            if (beanContext.classLoaderSwitched) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(beanContext.previousClassLoader);
                        return null;
                    }
                });
            }
        }
        catch (Exception exception) {}
    }

    public EjbDescriptor getEjbDescriptor(long l) {
        Container container = (Container)this.containers.get(l);
        if (container == null) {
            return null;
        }
        return container.getEjbDescriptor();
    }

    ContainerSynchronization getContainerSync(Transaction transaction) throws RollbackException, SystemException {
        ContainerSynchronization containerSynchronization = (ContainerSynchronization)this.syncTable.get(transaction);
        if (containerSynchronization == null) {
            containerSynchronization = new ContainerSynchronization(transaction, this);
            transaction.registerSynchronization((Synchronization)containerSynchronization);
            this.syncTable.put(transaction, containerSynchronization);
        }
        return containerSynchronization;
    }

    void removeContainerSync(Transaction transaction) {
        this.syncTable.remove(transaction);
        this.txBeanTable.remove(transaction);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DebugMonitor
    extends TimerTask {
        DebugMonitor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Enumeration enumeration = ContainerFactoryImpl.this.listContainers();
                if (null == enumeration) {
                    _logger.log(Level.SEVERE, "MONITORING:: No containers available to report monitoring stats");
                    return;
                }
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        return;
                    }
                    BaseContainer baseContainer = (BaseContainer)enumeration.nextElement();
                    if (baseContainer instanceof EntityContainer) {
                        _logger.log(Level.SEVERE, "MONITORING::" + ((EntityContainer)baseContainer).getMonitorAttributeValues());
                        continue;
                    }
                    if (baseContainer instanceof StatefulSessionContainer) {
                        _logger.log(Level.SEVERE, "MONITORING::" + ((StatefulSessionContainer)baseContainer).getMonitorAttributeValues());
                        continue;
                    }
                    if (baseContainer instanceof StatelessSessionContainer) {
                        _logger.log(Level.SEVERE, "MONITORING::" + ((StatelessSessionContainer)baseContainer).getMonitorAttributeValues());
                        continue;
                    }
                    if (!(baseContainer instanceof MessageBeanContainer)) continue;
                    _logger.log(Level.SEVERE, "MONITORING::" + ((MessageBeanContainer)baseContainer).getMonitorAttributeValues());
                }
            }
            catch (Throwable throwable) {
                _logger.log(Level.SEVERE, "Exception thrown", throwable);
                return;
            }
        }
    }
}

