/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.GeneratorException;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.DeploymentContext;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.rmi.rmic.IndentingWriter;

public abstract class Generator {
    protected static final boolean debug = false;
    private static Logger _logger = null;
    protected String ejbClassSymbol;

    public abstract String getGeneratedClass();

    public abstract void generate(OutputStream var1) throws GeneratorException, IOException;

    protected String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    protected String getBaseName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected String printType(Class clazz) {
        if (clazz.isArray()) {
            return this.printType(clazz.getComponentType()) + "[]";
        }
        return Generator.getCanonicalName(clazz);
    }

    private static String getCanonicalName(Class clazz) {
        if (clazz.isPrimitive()) {
            return clazz.getName();
        }
        if (clazz.getDeclaringClass() == null) {
            return clazz.getName();
        }
        String string = Generator.getCanonicalName(clazz.getDeclaringClass());
        return string + "." + clazz.getName().substring(string.length() + 1);
    }

    protected Method[] removeDups(Method[] methodArray) {
        Vector<Method> vector = new Vector<Method>();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            boolean bl = false;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Class<?>[] classArray;
                Class<?>[] classArray2;
                Method method2 = (Method)enumeration.nextElement();
                if (!method.getName().equals(method2.getName()) || (classArray2 = method.getParameterTypes()).length != (classArray = method2.getParameterTypes()).length) continue;
                boolean bl2 = true;
                int n2 = 0;
                while (n2 < classArray.length) {
                    if (classArray2[n2] != classArray[n2]) {
                        bl2 = false;
                        break;
                    }
                    ++n2;
                }
                if (!bl2) continue;
                bl = true;
                if (!method2.getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) break;
                vector.remove(method2);
                vector.add(method);
                break;
            }
            if (!bl) {
                vector.add(method);
            }
            ++n;
        }
        return vector.toArray(new Method[vector.size()]);
    }

    protected boolean isEJBIntfMethod(Class clazz, Method method) {
        boolean bl = false;
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method2 = methodArray[n];
            if (this.methodCompare(method, method2)) {
                bl = true;
                String string = clazz.getName();
                Class<?> clazz2 = method.getDeclaringClass();
                if (clazz2.getName().equals(string)) break;
                Object[] objectArray = new String[]{method2.toString(), method.toString()};
                _logger.log(Level.WARNING, "ejb.illegal_ejb_interface_override", objectArray);
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean methodCompare(Method method, Method method2) {
        Class<?>[] classArray;
        if (!method.getName().equals(method2.getName())) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        int n = 0;
        while (n < classArray2.length) {
            if (classArray2[n] != classArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected String[] printStaticMethodInit(IndentingWriter indentingWriter, Class clazz, Method[] methodArray) throws IOException {
        if (methodArray == null || methodArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[methodArray.length];
        int n = 0;
        while (n < methodArray.length) {
            String string;
            stringArray[n] = string = this.getUniqueMethodVar(stringArray, "__Method__" + methodArray[n].getName(), 0);
            indentingWriter.pln("private static java.lang.reflect.Method " + string + ";");
            ++n;
        }
        indentingWriter.plnI("static {");
        indentingWriter.plnI("try {");
        indentingWriter.pln("java.lang.Class[] cl;");
        int n2 = 0;
        while (n2 < methodArray.length) {
            Class<?>[] classArray = methodArray[n2].getParameterTypes();
            indentingWriter.pln("cl = new java.lang.Class[" + classArray.length + "];");
            int n3 = 0;
            while (n3 < classArray.length) {
                indentingWriter.pln("cl[" + n3 + "] = " + this.printType(classArray[n3]) + ".class;");
                ++n3;
            }
            indentingWriter.pln(stringArray[n2] + " = " + clazz.getName() + ".class.getMethod(\"" + methodArray[n2].getName() + "\", cl);");
            ++n2;
        }
        indentingWriter.pOln("} catch(NoSuchMethodException e) {}");
        indentingWriter.pOln("}");
        return stringArray;
    }

    private String getUniqueMethodVar(String[] stringArray, String string, int n) {
        boolean bl = false;
        String string2 = string;
        if (n > 0) {
            string2 = string + n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            if (string3 != null && string3.equals(string2)) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            return this.getUniqueMethodVar(stringArray, string, ++n);
        }
        return string2;
    }

    protected String getUniqueClassName(DeploymentContext deploymentContext, String string, String string2, Vector vector) {
        String string3 = null;
        boolean bl = false;
        int n = 0;
        while (!bl) {
            String string4;
            String string5 = string2;
            if (n > 0) {
                string5 = string2 + n;
            }
            if (!vector.contains(string4 = deploymentContext.getFileName(string3 = string + string5))) {
                bl = true;
                continue;
            }
            ++n;
        }
        return string3;
    }

    protected String getTxAttribute(EjbDescriptor ejbDescriptor, Method method) {
        if (ejbDescriptor instanceof EjbSessionDescriptor && ((EjbSessionDescriptor)ejbDescriptor).getTransactionType().equals("Bean")) {
            return "TX_BEAN_MANAGED";
        }
        String string = null;
        MethodDescriptor methodDescriptor = new MethodDescriptor(method);
        methodDescriptor.setEjbClassSymbol(this.ejbClassSymbol);
        ContainerTransaction containerTransaction = ejbDescriptor.getContainerTransactionFor(methodDescriptor);
        if (containerTransaction != null) {
            String string2 = containerTransaction.getTransactionAttribute();
            if (string2.equals(ContainerTransaction.NOT_SUPPORTED)) {
                string = "TX_NOT_SUPPORTED";
            } else if (string2.equals(ContainerTransaction.SUPPORTS)) {
                string = "TX_SUPPORTS";
            } else if (string2.equals(ContainerTransaction.REQUIRED)) {
                string = "TX_REQUIRED";
            } else if (string2.equals(ContainerTransaction.REQUIRES_NEW)) {
                string = "TX_REQUIRES_NEW";
            } else if (string2.equals(ContainerTransaction.MANDATORY)) {
                string = "TX_MANDATORY";
            } else if (string2.equals(ContainerTransaction.NEVER)) {
                string = "TX_NEVER";
            }
        }
        if (string == null) {
            throw new RuntimeException("Transaction Attribute not found for method " + method);
        }
        return string;
    }

    protected String getSecurityAttribute(EjbDescriptor ejbDescriptor, Method method) {
        Object object;
        Object object2;
        MethodDescriptor methodDescriptor = new MethodDescriptor(method);
        methodDescriptor.setEjbClassSymbol(this.ejbClassSymbol);
        Set set = ejbDescriptor.getUncheckedMethodDescriptors();
        if (set != null) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (MethodDescriptor)object2.next();
                if (!methodDescriptor.equals(object)) continue;
                return "SEC_UNCHECKED";
            }
        }
        if ((object2 = ejbDescriptor.getExcludedMethodDescriptors()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                MethodDescriptor methodDescriptor2 = (MethodDescriptor)object.next();
                if (!methodDescriptor.equals(methodDescriptor2)) continue;
                return "SEC_EXCLUDED";
            }
        }
        return "SEC_CHECKED";
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    }
}

