/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.orbutil;

import com.sun.corba.ee.internal.corba.ORB;
import com.sun.corba.ee.internal.orbutil.Element;
import com.sun.corba.ee.internal.orbutil.ORBUtility;

public final class TransientObjectManager {
    private ORB orb;
    private int maxSize = 128;
    private Element[] elementArray = new Element[this.maxSize];
    private Element freeList;

    void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public TransientObjectManager() {
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        int n = this.maxSize - 2;
        while (n >= 0) {
            this.elementArray[n] = new Element(n, this.elementArray[n + 1]);
            --n;
        }
        this.freeList = this.elementArray[0];
    }

    public void setOrb(ORB oRB) {
        this.orb = oRB;
    }

    public synchronized byte[] storeServant(Object object, Object object2) {
        if (this.freeList == null) {
            this.doubleSize();
        }
        Element element = this.freeList;
        this.freeList = (Element)this.freeList.servant;
        byte[] byArray = element.getKey(object, object2);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("storeServant returns key for element " + element);
        }
        return byArray;
    }

    public synchronized Object lookupServant(byte[] byArray) {
        int n = ORBUtility.bytesToInt(byArray, 0);
        int n2 = ORBUtility.bytesToInt(byArray, 4);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("lookupServant called with index=" + n + ", counter=" + n2);
        }
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            if (this.orb.transientObjectManagerDebugFlag) {
                this.dprint("\tcounter is valid");
            }
            return this.elementArray[n].servant;
        }
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("\tcounter is invalid");
        }
        return null;
    }

    public synchronized Object lookupServantData(byte[] byArray) {
        int n = ORBUtility.bytesToInt(byArray, 0);
        int n2 = ORBUtility.bytesToInt(byArray, 4);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("lookupServantData called with index=" + n + ", counter=" + n2);
        }
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            if (this.orb.transientObjectManagerDebugFlag) {
                this.dprint("\tcounter is valid");
            }
            return this.elementArray[n].servantData;
        }
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("\tcounter is invalid");
        }
        return null;
    }

    public synchronized void deleteServant(byte[] byArray) {
        int n = ORBUtility.bytesToInt(byArray, 0);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("deleting servant at index=" + n);
        }
        this.elementArray[n].delete(this.freeList);
        this.freeList = this.elementArray[n];
    }

    public synchronized byte[] getKey(Object object) {
        int n = 0;
        while (n < this.maxSize) {
            if (this.elementArray[n].valid && this.elementArray[n].servant == object) {
                return this.elementArray[n].toBytes();
            }
            ++n;
        }
        return null;
    }

    private void doubleSize() {
        Element[] elementArray = this.elementArray;
        int n = this.maxSize;
        this.maxSize *= 2;
        this.elementArray = new Element[this.maxSize];
        int n2 = 0;
        while (n2 < n) {
            this.elementArray[n2] = elementArray[n2];
            ++n2;
        }
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        int n3 = this.maxSize - 2;
        while (n3 >= n) {
            this.elementArray[n3] = new Element(n3, this.elementArray[n3 + 1]);
            --n3;
        }
        this.freeList = this.elementArray[n];
    }
}

