/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.ActivationIDL.Repository;
import com.sun.corba.ee.ActivationIDL.RepositoryHelper;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.internal.Activation.CommandHandler;
import com.sun.corba.ee.internal.Activation.GetServerID;
import com.sun.corba.ee.internal.Activation.Help;
import com.sun.corba.ee.internal.Activation.ListActiveServers;
import com.sun.corba.ee.internal.Activation.ListAliases;
import com.sun.corba.ee.internal.Activation.ListORBs;
import com.sun.corba.ee.internal.Activation.ListServers;
import com.sun.corba.ee.internal.Activation.LocateServer;
import com.sun.corba.ee.internal.Activation.LocateServerForORB;
import com.sun.corba.ee.internal.Activation.Quit;
import com.sun.corba.ee.internal.Activation.RegisterServer;
import com.sun.corba.ee.internal.Activation.ShutdownServer;
import com.sun.corba.ee.internal.Activation.StartServer;
import com.sun.corba.ee.internal.Activation.UnRegisterServer;
import com.sun.corba.ee.internal.orbutil.CorbaResourceUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import org.omg.CORBA.ORB;

public class ServerTool {
    static final String helpCommand = "help";
    static final String toolName = "servertool";
    static final String commandArg = "-cmd";
    private static final boolean debug = false;
    ORB orb = null;
    static Vector handlers = new Vector();
    static int maxNameLen;

    static int getServerIdForAlias(ORB oRB, String string) throws ServerNotRegistered {
        try {
            Repository repository = RepositoryHelper.narrow(oRB.resolve_initial_references("ServerRepository"));
            int n = repository.getServerID(string);
            return repository.getServerID(string);
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.FINE, "", exception);
            throw new ServerNotRegistered();
        }
    }

    void run(String[] stringArray) {
        block8: {
            String[] stringArray2 = null;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(commandArg)) {
                    int n2 = stringArray.length - n - 1;
                    stringArray2 = new String[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        stringArray2[n3] = stringArray[++n];
                        ++n3;
                    }
                    break;
                }
                ++n;
            }
            try {
                Properties properties = System.getProperties();
                properties.put("org.omg.CORBA.ORBClass", "com.sun.corba.ee.internal.iiop.ORB");
                this.orb = ORB.init(stringArray, properties);
                if (stringArray2 != null) {
                    this.executeCommand(stringArray2);
                    break block8;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.println(CorbaResourceUtil.getText("servertool.banner"));
                while (true) {
                    if ((stringArray2 = this.readCommand(bufferedReader)) != null) {
                        this.executeCommand(stringArray2);
                        continue;
                    }
                    this.printAvailableCommands();
                }
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.WARNING, CorbaResourceUtil.getText("servertool.usage", toolName), exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        ServerTool serverTool = new ServerTool();
        serverTool.run(stringArray);
    }

    String[] readCommand(BufferedReader bufferedReader) {
        System.out.print("servertool > ");
        try {
            StringTokenizer stringTokenizer;
            int n = 0;
            String[] stringArray = null;
            String string = bufferedReader.readLine();
            if (string != null && (stringTokenizer = new StringTokenizer(string)).countTokens() != 0) {
                stringArray = new String[stringTokenizer.countTokens()];
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer.nextToken();
                }
            }
            return stringArray;
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, CorbaResourceUtil.getText("servertool.usage", toolName), exception);
            return null;
        }
    }

    void printAvailableCommands() {
        System.out.println(CorbaResourceUtil.getText("servertool.shorthelp"));
        int n = 0;
        while (n < handlers.size()) {
            CommandHandler commandHandler = (CommandHandler)handlers.elementAt(n);
            System.out.print("\t" + commandHandler.getCommandName());
            int n2 = commandHandler.getCommandName().length();
            while (n2 < maxNameLen) {
                System.out.print(" ");
                ++n2;
            }
            System.out.print(" - ");
            commandHandler.printCommandHelp(System.out, true);
            ++n;
        }
        System.out.println();
    }

    void executeCommand(String[] stringArray) {
        if (stringArray[0].equals(helpCommand)) {
            if (stringArray.length == 1) {
                this.printAvailableCommands();
            } else {
                int n = 0;
                while (n < handlers.size()) {
                    CommandHandler commandHandler = (CommandHandler)handlers.elementAt(n);
                    if (commandHandler.getCommandName().equals(stringArray[1])) {
                        commandHandler.printCommandHelp(System.out, false);
                    }
                    ++n;
                }
            }
            return;
        }
        int n = 0;
        while (n < handlers.size()) {
            CommandHandler commandHandler = (CommandHandler)handlers.elementAt(n);
            if (commandHandler.getCommandName().equals(stringArray[0])) {
                String[] stringArray2 = new String[stringArray.length - 1];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray2[n2] = stringArray[n2 + 1];
                    ++n2;
                }
                try {
                    System.out.println();
                    boolean bl = commandHandler.processCommand(stringArray2, this.orb, System.out);
                    if (bl) {
                        commandHandler.printCommandHelp(System.out, false);
                    }
                    System.out.println();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            ++n;
        }
        this.printAvailableCommands();
    }

    static {
        handlers.addElement(new RegisterServer());
        handlers.addElement(new UnRegisterServer());
        handlers.addElement(new GetServerID());
        handlers.addElement(new ListServers());
        handlers.addElement(new ListAliases());
        handlers.addElement(new ListActiveServers());
        handlers.addElement(new LocateServer());
        handlers.addElement(new LocateServerForORB());
        handlers.addElement(new ListORBs());
        handlers.addElement(new ShutdownServer());
        handlers.addElement(new StartServer());
        handlers.addElement(new Help());
        handlers.addElement(new Quit());
        maxNameLen = 0;
        int n = 0;
        while (n < handlers.size()) {
            CommandHandler commandHandler = (CommandHandler)handlers.elementAt(n);
            int n2 = commandHandler.getCommandName().length();
            if (n2 > maxNameLen) {
                maxNameLen = n2;
            }
            ++n;
        }
    }
}

