/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.filter;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.cache.CacheHelper;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.appserv.web.cache.CacheManagerListener;
import com.sun.appserv.web.cache.filter.CachingResponseWrapper;
import com.sun.appserv.web.cache.filter.HttpCacheEntry;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CachingFilter
implements Filter,
CacheManagerListener {
    String filterName;
    String servletName;
    String urlPattern;
    CacheManager manager;
    CacheHelper helper;
    Cache cache;
    boolean isEnabled = false;
    private static Logger _logger = null;
    private static boolean _isTraceEnabled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterName = filterConfig.getFilterName();
        this.servletName = filterConfig.getInitParameter("servletName");
        this.urlPattern = filterConfig.getInitParameter("URLPattern");
        ServletContext servletContext = filterConfig.getServletContext();
        this.manager = (CacheManager)servletContext.getAttribute("com.sun.appserv.web.CacheManager");
        if (this.manager != null && this.manager.isEnabled()) {
            this.cache = this.manager.getDefaultCache();
            this.helper = this.manager.getCacheHelperByFilterName(this.filterName);
            this.manager.addCacheManagerListener(this);
            this.isEnabled = true;
        }
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _isTraceEnabled = _logger.isLoggable(Level.FINE);
        }
        if (_isTraceEnabled) {
            _logger.fine("CachingFilter " + this.filterName + " ready; isEnabled = " + this.isEnabled + " manager = " + this.manager);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String string;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        httpServletRequest.setAttribute("com.sun.ias.web.cachingFilterName", (Object)this.filterName);
        httpServletRequest.setAttribute("com.sun.appserv.web.cachedServletName", (Object)this.servletName);
        httpServletRequest.setAttribute("com.sun.appserv.web.cachedURLPattern", (Object)this.urlPattern);
        if (this.isEnabled && this.helper.isCacheable(httpServletRequest) && (string = this.helper.getCacheKey(httpServletRequest)) != null) {
            int n = this.cache.getIndex(string);
            if (_isTraceEnabled) {
                _logger.fine("CachingFilter " + httpServletRequest.getServletPath() + " request is cacheable; key " + string + " index = " + n);
            }
            HttpCacheEntry httpCacheEntry = null;
            boolean bl = false;
            boolean bl2 = true;
            if (!this.helper.isRefreshNeeded(httpServletRequest)) {
                do {
                    if ((httpCacheEntry = (HttpCacheEntry)this.cache.get(string)) == null || !httpCacheEntry.isValid()) continue;
                    bl = true;
                    break;
                } while (bl2 = this.cache.waitRefresh(n));
            } else if (_isTraceEnabled) {
                _logger.fine("CachingFilter " + httpServletRequest.getServletPath() + " request needs a refresh; key " + string);
            }
            if (bl) {
                if (_isTraceEnabled) {
                    _logger.fine("CachingFilter " + httpServletRequest.getServletPath() + " serving response from the cache " + string);
                }
                this.sendCachedResponse(httpCacheEntry, httpServletResponse);
            } else {
                CachingResponseWrapper cachingResponseWrapper = new CachingResponseWrapper(httpServletResponse);
                try {
                    filterChain.doFilter(servletRequest, (ServletResponse)cachingResponseWrapper);
                }
                catch (ServletException servletException) {
                    cachingResponseWrapper.clear();
                    throw servletException;
                }
                catch (IOException iOException) {
                    cachingResponseWrapper.clear();
                    throw iOException;
                }
                if (!cachingResponseWrapper.isError()) {
                    int n2 = this.helper.getTimeout(httpServletRequest);
                    httpCacheEntry = cachingResponseWrapper.cacheResponse();
                    if (n2 == -2) {
                        Long l = cachingResponseWrapper.getExpiresDateHeader();
                        if (l == null) {
                            n2 = this.manager.getDefaultTimeout();
                            httpCacheEntry.computeExpireTime(n2);
                        } else {
                            long l2 = l;
                            httpCacheEntry.setExpireTime(l2);
                        }
                    } else {
                        httpCacheEntry.computeExpireTime(n2);
                    }
                    HttpCacheEntry httpCacheEntry2 = (HttpCacheEntry)this.cache.put(string, httpCacheEntry, httpCacheEntry.getSize());
                    this.cache.notifyRefresh(n);
                    this.writeBody(httpCacheEntry, httpServletResponse);
                } else {
                    HttpCacheEntry httpCacheEntry3 = (HttpCacheEntry)this.cache.remove(string);
                }
                cachingResponseWrapper.clear();
            }
        } else {
            if (_isTraceEnabled) {
                _logger.fine("CachingFilter " + httpServletRequest.getServletPath() + " pass thru; isEnabled = " + this.isEnabled);
            }
            httpServletRequest.removeAttribute("com.sun.ias.web.cachingFilterName");
            httpServletRequest.removeAttribute("com.sun.appserv.web.cachedServletName");
            httpServletRequest.removeAttribute("com.sun.appserv.web.cachedURLPattern");
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void sendCachedResponse(HttpCacheEntry httpCacheEntry, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        Object object2;
        if (httpCacheEntry.statusCode != -1) {
            httpServletResponse.setStatus(httpCacheEntry.statusCode);
        }
        Iterator iterator = httpCacheEntry.responseHeaders.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (ArrayList)httpCacheEntry.responseHeaders.get(object2);
            int n = 0;
            while (n < ((ArrayList)object).size()) {
                httpServletResponse.addHeader((String)object2, (String)((ArrayList)object).get(n));
                ++n;
            }
        }
        object2 = httpCacheEntry.dateHeaders.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            ArrayList arrayList = (ArrayList)httpCacheEntry.dateHeaders.get(object);
            int n = 0;
            while (n < arrayList.size()) {
                httpServletResponse.addDateHeader((String)object, ((Long)arrayList.get(n)).longValue());
                ++n;
            }
        }
        int n = 0;
        while (n < httpCacheEntry.cookies.size()) {
            httpServletResponse.addCookie((Cookie)httpCacheEntry.cookies.get(n));
            ++n;
        }
        if (httpCacheEntry.contentLength != -1) {
            httpServletResponse.setContentLength(httpCacheEntry.contentLength);
        }
        if (httpCacheEntry.contentType != null) {
            httpServletResponse.setContentType(httpCacheEntry.contentType);
        }
        if (httpCacheEntry.locale != null) {
            httpServletResponse.setLocale(httpCacheEntry.locale);
        }
        this.writeBody(httpCacheEntry, httpServletResponse);
    }

    private void writeBody(HttpCacheEntry httpCacheEntry, HttpServletResponse httpServletResponse) throws IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.write(httpCacheEntry.bytes);
    }

    public void cacheManagerEnabled() {
        if (_isTraceEnabled) {
            _logger.fine("CachingFilter " + this.filterName + " received cacheManager enabled event.");
        }
        this.isEnabled = true;
    }

    public void cacheManagerDisabled() {
        if (_isTraceEnabled) {
            _logger.fine("CachingFilter " + this.filterName + " received cacheManager disabled event.");
        }
        this.isEnabled = false;
    }

    public void destroy() {
    }
}

