/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import com.sun.appserv.BytecodePreprocessor;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreprocessorUtil {
    private static boolean _preprocessorEnabled = false;
    private static BytecodePreprocessor[] _preprocessor;
    private static Logger _logger;

    public static boolean init(String[] stringArray) {
        if (stringArray != null) {
            PreprocessorUtil.setupPreprocessor(stringArray);
        }
        return _preprocessorEnabled;
    }

    public static byte[] processClass(String string, byte[] byArray) {
        byte[] byArray2 = byArray;
        if (_preprocessorEnabled && _preprocessor != null) {
            int n = 0;
            while (n < _preprocessor.length) {
                byArray = _preprocessor[n].preprocess(string, byArray);
                _logger.fine("[PreprocessorUtil.processClass] Preprocessor " + n + " Processed Class: " + string);
                if (byArray != null) {
                    byArray2 = byArray;
                } else {
                    _logger.log(Level.SEVERE, "core.preprocessor_preprocess_failed", new String[]{string, _preprocessor[n].getClass().getName()});
                    if (n == 0) {
                        _logger.log(Level.SEVERE, "core.preprocessor_resetting_original", string);
                    } else {
                        _logger.log(Level.SEVERE, "core.preprocessor_resetting_last_good");
                    }
                }
                ++n;
            }
        }
        return byArray2;
    }

    private static synchronized void setupPreprocessor(String[] stringArray) {
        if (_preprocessor != null) {
            return;
        }
        try {
            _preprocessor = new BytecodePreprocessor[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n].trim();
                Class<?> clazz = Class.forName(string);
                if (clazz != null) {
                    PreprocessorUtil._preprocessor[n] = (BytecodePreprocessor)clazz.newInstance();
                    if (_preprocessor[n] instanceof BytecodePreprocessor) {
                        PreprocessorUtil._preprocessor[n] = _preprocessor[n];
                        _preprocessorEnabled = true;
                    } else {
                        _logger.log(Level.SEVERE, "core.preprocessor_invalid_type", string);
                        _logger.log(Level.SEVERE, "core.preprocessor_disabled");
                        _preprocessorEnabled = false;
                    }
                }
                if (_preprocessor[n] != null) {
                    if (!_preprocessor[n].initialize(new Hashtable())) {
                        _logger.log(Level.SEVERE, "core.preprocessor_failed_init", string);
                        _logger.log(Level.SEVERE, "core.preprocessor_disabled");
                        _preprocessorEnabled = false;
                    }
                } else {
                    _logger.log(Level.SEVERE, "core.preprocessor_failed_init", string);
                    _logger.log(Level.SEVERE, "core.preprocessor_disabled");
                    _preprocessorEnabled = false;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "core.preprocessor_setup_ex", throwable.toString());
            _logger.log(Level.SEVERE, "core.preprocessor_disabled");
            _preprocessorEnabled = false;
            return;
        }
    }

    public static boolean isPreprocessorEnabled() {
        return _preprocessorEnabled;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
    }
}

