/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.naming;

import com.sun.appserv.naming.LoadBalancingPolicy;
import com.sun.jndi.cosnaming.IiopUrl;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.omg.CORBA.ORB;

public class RoundRobinPolicy
extends LoadBalancingPolicy {
    private static final String NO_OF_ORB_CONNECTION_PROPERTY = "com.sun.appserv.iiop.orbconnections";
    int numberOfORBs = 1;
    private Hashtable precreatedORBStore = new Hashtable();
    private Hashtable dynamicORBStore = new Hashtable();
    private Object storesLock = new Object();

    private void init() {
        String string = System.getProperty(NO_OF_ORB_CONNECTION_PROPERTY);
        if (string != null) {
            this.numberOfORBs = Integer.parseInt(string);
        }
    }

    public RoundRobinPolicy(String[] stringArray) {
        this.init();
        String[] stringArray2 = null;
        if (stringArray != null && stringArray.length > 0) {
            stringArray2 = this.getAddressPortList(stringArray);
        } else {
            String string = System.getProperty("java.naming.provider.url");
            if (string != null) {
                try {
                    IiopUrl iiopUrl = new IiopUrl(string);
                    stringArray2 = this.getAddressPortList(iiopUrl);
                }
                catch (MalformedURLException malformedURLException) {
                    LoadBalancingPolicy._logger.log(Level.WARNING, "Bad provider URL String: " + string);
                }
            } else {
                String string2;
                String string3 = System.getProperty("org.omg.CORBA.ORBInitialHost");
                if (string3 != null && (string2 = System.getProperty("org.omg.CORBA.ORBInitialPort")) != null) {
                    stringArray2 = this.getAddressPortList(string3, string2);
                }
            }
        }
        if (stringArray2 != null) {
            this.growORBStore(this.precreatedORBStore, stringArray2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORB getORB(Hashtable hashtable) {
        Object object;
        ORB oRB = null;
        String[] stringArray = null;
        String string = (String)hashtable.get("java.naming.provider.url");
        if (string != null) {
            try {
                object = new IiopUrl(string);
                stringArray = this.getAddressPortList((IiopUrl)object);
            }
            catch (MalformedURLException malformedURLException) {
                LoadBalancingPolicy._logger.log(Level.WARNING, "Bad provider URL String: " + string);
            }
        } else {
            String string2;
            String string3 = (String)hashtable.get("org.omg.CORBA.ORBInitialHost");
            if (string3 != null && (string2 = (String)hashtable.get("org.omg.CORBA.ORBInitialPort")) != null) {
                stringArray = this.getAddressPortList(string3, string2);
            }
        }
        object = null;
        if (stringArray == null) {
            object = this.getLeastAccessedElement(this.precreatedORBStore, null);
        } else {
            Object object2 = this.storesLock;
            synchronized (object2) {
                LoadBalancingPolicy.ORBDataElement oRBDataElement;
                String[] stringArray2;
                int n = 0;
                while (n < stringArray.length) {
                    if (!this.precreatedORBStore.containsKey(this.makeStorageKey(stringArray[n])) && !this.dynamicORBStore.containsKey(this.makeStorageKey(stringArray[n]))) {
                        stringArray2 = new String[]{stringArray[n]};
                        this.growORBStore(this.dynamicORBStore, stringArray2);
                        oRBDataElement = (LoadBalancingPolicy.ORBDataElement)this.dynamicORBStore.get(this.makeStorageKey(stringArray[n]));
                        if (oRBDataElement != null) {
                            return oRBDataElement.getORB();
                        }
                    }
                    ++n;
                }
                stringArray2 = this.getLeastAccessedElement(this.precreatedORBStore, stringArray);
                oRBDataElement = this.getLeastAccessedElement(this.dynamicORBStore, stringArray);
                object = stringArray2 != null && oRBDataElement != null ? (stringArray2.getAccessCount() <= oRBDataElement.getAccessCount() ? stringArray2 : oRBDataElement) : (oRBDataElement == null ? stringArray2 : oRBDataElement);
            }
        }
        if (object != null) {
            int n = ((LoadBalancingPolicy.ORBDataElement)object).getNextORBIndex();
            oRB = ((LoadBalancingPolicy.ORBDataElement)object).getORB();
        }
        return oRB;
    }

    private String makeStorageKey(String string) {
        return string.trim().toLowerCase();
    }

    private void growORBStore(Hashtable hashtable, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            try {
                String[] stringArray2 = stringArray[n].split(":");
                String string = stringArray2[0].trim();
                String string2 = stringArray2[1].trim();
                ORB[] oRBArray = new ORB[this.numberOfORBs];
                int n2 = 0;
                while (n2 < this.numberOfORBs) {
                    oRBArray[n2] = this.createORB(string, string2, string + "_" + string2 + "_" + n2);
                    ++n2;
                }
                LoadBalancingPolicy.ORBDataElement oRBDataElement = new LoadBalancingPolicy.ORBDataElement(oRBArray, "ORB with nameservice at " + stringArray[n]);
                hashtable.put(this.makeStorageKey(stringArray[n]), oRBDataElement);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    private LoadBalancingPolicy.ORBDataElement getLeastAccessedElement(Hashtable hashtable, String[] stringArray) {
        if (hashtable == null) {
            return null;
        }
        LoadBalancingPolicy.ORBDataElement oRBDataElement = null;
        if (stringArray == null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                LoadBalancingPolicy.ORBDataElement oRBDataElement2 = (LoadBalancingPolicy.ORBDataElement)hashtable.get(string);
                if (oRBDataElement != null && oRBDataElement2.getAccessCount() >= oRBDataElement.getAccessCount()) continue;
                oRBDataElement = oRBDataElement2;
            }
        } else {
            int n = 0;
            while (n < stringArray.length) {
                LoadBalancingPolicy.ORBDataElement oRBDataElement3 = (LoadBalancingPolicy.ORBDataElement)hashtable.get(this.makeStorageKey(stringArray[n]));
                if (oRBDataElement3 != null && (oRBDataElement == null || oRBDataElement3.getAccessCount() < oRBDataElement.getAccessCount())) {
                    oRBDataElement = oRBDataElement3;
                }
                ++n;
            }
        }
        return oRBDataElement;
    }

    private String[] getAddressPortList(String[] stringArray) {
        IiopUrl iiopUrl;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            try {
                iiopUrl = new IiopUrl("iiop://" + stringArray[n]);
                String[] stringArray2 = this.getAddressPortList(iiopUrl);
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    vector.addElement(stringArray2[n2]);
                    ++n2;
                }
            }
            catch (MalformedURLException malformedURLException) {
                LoadBalancingPolicy._logger.log(Level.WARNING, "Bad host:port entry: " + stringArray[n]);
            }
            ++n;
        }
        iiopUrl = new String[vector.size()];
        int n3 = 0;
        while (n3 < ((String[])iiopUrl).length) {
            iiopUrl[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return iiopUrl;
    }

    private String[] getAddressPortList(IiopUrl iiopUrl) {
        IiopUrl.Address address = (IiopUrl.Address)iiopUrl.getAddresses().elementAt(0);
        String string = address.host;
        int n = address.port;
        String string2 = Integer.toString(n);
        return this.getAddressPortList(string, string2);
    }

    private String[] getAddressPortList(String string, String string2) {
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            String[] stringArray = new String[inetAddressArray.length];
            int n = 0;
            while (n < inetAddressArray.length) {
                stringArray[n] = inetAddressArray[n].getHostAddress() + ":" + string2;
                ++n;
            }
            return stringArray;
        }
        catch (UnknownHostException unknownHostException) {
            LoadBalancingPolicy._logger.log(Level.WARNING, "Uknown host: " + string);
            return null;
        }
    }
}

