/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.admin.event.AdminEventListenerException;
import com.iplanet.ias.admin.event.AdminEventListenerRegistry;
import com.iplanet.ias.admin.event.ModuleDeployEvent;
import com.iplanet.ias.admin.event.ModuleDeployEventListener;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.instance.ConnectorModulesManager;
import com.iplanet.ias.server.AbstractLoader;
import com.iplanet.ias.server.AbstractManager;
import com.iplanet.ias.server.ConnectorModuleLoader;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

class StandAloneConnectorModulesManager
extends AbstractManager
implements ModuleDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager("com.iplanet.ias.server");

    StandAloneConnectorModulesManager(ConnectorModulesManager connectorModulesManager, ClassLoader classLoader) {
        super(classLoader, connectorModulesManager);
        AdminEventListenerRegistry.addModuleDeployEventListener(this);
    }

    protected AbstractLoader getLoader(String string) {
        return new ConnectorModuleLoader(string, this.parentClassLoader, (ConnectorModulesManager)this.configManager);
    }

    private boolean moduleDeployed(String string) throws AdminEventListenerException {
        boolean bl;
        block6: {
            bl = false;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "In connector moduleDeployed event,name=" + string);
            }
            try {
                if (!this.configManager.isEnabled(string)) break block6;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Loading enabled moduleName: " + string);
                }
                AbstractLoader abstractLoader = this.getLoader(string);
                _logger.log(Level.FINEST, "After get loader");
                if (abstractLoader.load()) {
                    this.id2loader.put(string, abstractLoader);
                    bl = true;
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Successfully loaded moduleName: " + string);
                    }
                    break block6;
                }
                _logger.log(Level.WARNING, "core.error_while_loading_connector_module " + string);
                String string2 = localStrings.getString("connector.error_while_loading_connector_module", string);
                throw new AdminEventListenerException(string2);
            }
            catch (ConfigException configException) {
                _logger.log(Level.WARNING, "core.error_while_loading_connector_module", configException);
                bl = false;
                String string3 = localStrings.getString("connector.error_while_loading_connector_module", string);
                throw new AdminEventListenerException(string3);
            }
        }
        return bl;
    }

    private boolean moduleUndeployed(String string) {
        ConnectorModuleLoader connectorModuleLoader;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In connector moduleUndeployed event,name=" + string);
        }
        if ((connectorModuleLoader = (ConnectorModuleLoader)this.id2loader.remove(string)) == null) {
            return false;
        }
        return connectorModuleLoader.unload();
    }

    public synchronized void moduleDeployed(ModuleDeployEvent moduleDeployEvent) throws AdminEventListenerException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneConnectorModulesManager moduleDeployed");
            _logger.log(Level.FINEST, "ModuleType=" + moduleDeployEvent.getModuleType());
        }
        if (moduleDeployEvent.getModuleType().equals("connector")) {
            String string = moduleDeployEvent.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "modID=" + string);
            }
            try {
                this.configManager.refreshConfigContext(moduleDeployEvent.getConfigContext());
                boolean bl = this.moduleDeployed(string);
                if (!bl) {
                    String string2 = localStrings.getString("connector.connector_deployed_failed", string);
                    throw new AdminEventListenerException(string2);
                }
            }
            catch (ConfigException configException) {
                throw new AdminEventListenerException(configException.getMessage());
            }
        }
    }

    public synchronized void moduleUndeployed(ModuleDeployEvent moduleDeployEvent) throws AdminEventListenerException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneConnectorModulesManager moduleUndeployed");
        }
        try {
            if (moduleDeployEvent.getModuleType().equals("connector")) {
                boolean bl;
                String string = moduleDeployEvent.getModuleName();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "UnDeploying module: " + string);
                }
                if (!(bl = this.moduleUndeployed(string))) {
                    String string2 = localStrings.getString("connector.connector_undeployed_failed", string);
                    throw new AdminEventListenerException(string2);
                }
                this.configManager.refreshConfigContext(moduleDeployEvent.getConfigContext());
            }
        }
        catch (ConfigException configException) {
            throw new AdminEventListenerException(configException.getMessage());
        }
    }

    public synchronized void moduleRedeployed(ModuleDeployEvent moduleDeployEvent) throws AdminEventListenerException {
        if (moduleDeployEvent.getModuleType().equals("connector")) {
            String string = moduleDeployEvent.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "ReDeploying module: " + string);
            }
            this.moduleUndeployed(moduleDeployEvent);
            this.moduleDeployed(moduleDeployEvent);
        }
    }

    public synchronized void moduleEnabled(ModuleDeployEvent moduleDeployEvent) throws AdminEventListenerException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneConnectorModulesManager moduleEnabled");
        }
        if (moduleDeployEvent.getModuleType().equals("connector")) {
            String string = moduleDeployEvent.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Module : " + string + " enabled...");
            }
            this.moduleDeployed(moduleDeployEvent);
        }
    }

    public synchronized void moduleDisabled(ModuleDeployEvent moduleDeployEvent) throws AdminEventListenerException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneConnectorModulesManager moduleDisabled");
        }
        if (moduleDeployEvent.getModuleType().equals("connector")) {
            String string = moduleDeployEvent.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Module : " + string + " disabled...");
            }
            this.moduleUndeployed(moduleDeployEvent);
        }
    }
}

