/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.connectors.deployment.IASDeploymentException;
import com.iplanet.ias.connectors.deployment.IASMCFFactory;
import com.iplanet.ias.connectors.tools.security.PrincipalsTable;
import com.iplanet.ias.instance.ConnectorModulesManager;
import com.iplanet.ias.server.AbstractLoader;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.IASConnectionManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;

class ConnectorModuleLoader
extends AbstractLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");

    ConnectorModuleLoader(String string, ClassLoader classLoader, ConnectorModulesManager connectorModulesManager) {
        super(string, classLoader, connectorModulesManager);
    }

    boolean load() {
        try {
            IASMCFFactory iASMCFFactory = IASMCFFactory.getMCFFactory();
            _logger.log(Level.FINEST, "--->Before load mcf");
            ClassLoader classLoader = null;
            iASMCFFactory.loadOneMCF(this.configManager.getLocation(this.id), this.id, classLoader);
            String string = iASMCFFactory.getJndiName(this.id);
            ManagedConnectionFactory managedConnectionFactory = iASMCFFactory.getManagedConnectionFactory(string);
            PrincipalsTable principalsTable = iASMCFFactory.getSecurityTableByJndiName(string);
            principalsTable.setManagedConnectionFactory(managedConnectionFactory);
            IASConnectionManagerImpl iASConnectionManagerImpl = (IASConnectionManagerImpl)Switch.getSwitch().getConnectionManager();
            iASConnectionManagerImpl.addPrincipalsMapping(iASMCFFactory, string);
            _logger.log(Level.FINEST, "<---After load mcf");
        }
        catch (ConfigException configException) {
            _logger.log(Level.WARNING, "loader.configexception", configException);
            return false;
        }
        catch (IASDeploymentException iASDeploymentException) {
            _logger.log(Level.WARNING, "loader.exception", iASDeploymentException);
            return false;
        }
        return true;
    }

    boolean unload() {
        try {
            IASMCFFactory iASMCFFactory = IASMCFFactory.getMCFFactory();
            IASConnectionManagerImpl iASConnectionManagerImpl = (IASConnectionManagerImpl)Switch.getSwitch().getConnectionManager();
            String string = iASMCFFactory.getJndiName(this.id);
            iASConnectionManagerImpl.removePrincipalsMapping(string);
            ManagedConnectionFactory managedConnectionFactory = iASMCFFactory.getManagedConnectionFactory(string);
            iASConnectionManagerImpl.removePools(managedConnectionFactory);
            _logger.log(Level.FINEST, "--->Before unload mcf");
            iASMCFFactory.unloadOneMCF(this.configManager.getLocation(this.id), this.id);
            _logger.log(Level.FINEST, "<---After unload mcf");
        }
        catch (IASDeploymentException iASDeploymentException) {
            _logger.log(Level.WARNING, "loader.exception", iASDeploymentException);
            return false;
        }
        catch (ConfigException configException) {
            _logger.log(Level.WARNING, "loader.configexception", configException);
            return false;
        }
        return true;
    }
}

