/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.admin.event.AdminEventListenerException;
import com.iplanet.ias.admin.event.AdminEventListenerRegistry;
import com.iplanet.ias.admin.event.ApplicationDeployEvent;
import com.iplanet.ias.admin.event.ApplicationDeployEventListener;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.backend.DeployableObjectType;
import com.iplanet.ias.deployment.backend.Deployer;
import com.iplanet.ias.deployment.backend.DeployerFactory;
import com.iplanet.ias.deployment.backend.DeploymentCommand;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.instance.AppsManager;
import com.iplanet.ias.server.AbstractLoader;
import com.iplanet.ias.server.AbstractManager;
import com.iplanet.ias.server.ApplicationLoader;
import com.iplanet.ias.server.MonitorableEntry;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

class ApplicationManager
extends AbstractManager
implements ApplicationDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$server$ApplicationManager == null ? (class$com$iplanet$ias$server$ApplicationManager = ApplicationManager.class$("com.iplanet.ias.server.ApplicationManager")) : class$com$iplanet$ias$server$ApplicationManager);
    static /* synthetic */ Class class$com$iplanet$ias$server$ApplicationManager;

    ApplicationManager(AppsManager appsManager, ClassLoader classLoader) {
        super(classLoader, appsManager);
        AdminEventListenerRegistry.addApplicationDeployEventListener(this);
    }

    protected AbstractLoader getLoader(String string) {
        return new ApplicationLoader(string, this.parentClassLoader, (AppsManager)this.configManager);
    }

    boolean applicationDeployed(String string) {
        return this.applicationDeployed(string, true);
    }

    boolean applicationDeployed(String string, boolean bl) {
        boolean bl2;
        block6: {
            bl2 = false;
            try {
                if (this.configManager.isEnabled(string)) {
                    _logger.log(Level.FINEST, "[ApplicationManager] Application is enabled: " + string);
                    AbstractLoader abstractLoader = this.getLoader(string);
                    if (abstractLoader.load()) {
                        this.id2loader.put(string, abstractLoader);
                        if (bl) {
                            this.addToReloadMonitor(string);
                        }
                        bl2 = true;
                    } else {
                        _logger.log(Level.WARNING, "core.application_not_loaded", string);
                    }
                    break block6;
                }
                _logger.log(Level.INFO, "core.application_disabled", string);
            }
            catch (ConfigException configException) {
                _logger.log(Level.WARNING, "core.error_while_loading_app", configException);
            }
        }
        return bl2;
    }

    boolean applicationUndeployed(String string) {
        return this.applicationUndeployed(string, true);
    }

    boolean applicationUndeployed(String string, boolean bl) {
        AbstractLoader abstractLoader;
        if (bl) {
            this.removeFromReloadMonitor(string);
        }
        if ((abstractLoader = (AbstractLoader)this.id2loader.remove(string)) == null) {
            return true;
        }
        Application application = abstractLoader.getApplication();
        RoleMapper.removeRoleMapper(application.getRoleMapper().getName());
        boolean bl2 = abstractLoader.unload();
        if (bl2) {
            if (application.getEjbComponentCount() > 0) {
                _logger.log(Level.INFO, "core.application_unloaded_ejb", string);
            }
        } else {
            _logger.log(Level.INFO, "core.application_not_unloaded", string);
        }
        return bl2;
    }

    private void holdRequest() {
    }

    private void holdRequest(String string) {
    }

    public synchronized boolean reload(MonitorableEntry monitorableEntry) {
        boolean bl = false;
        String string = monitorableEntry.getId();
        bl = this.applicationUndeployed(string, false);
        try {
            DeploymentRequest deploymentRequest = new DeploymentRequest(this.configManager.getInstanceEnvironment(), DeployableObjectType.APP, DeploymentCommand.DEPLOY);
            deploymentRequest.setFileSource(monitorableEntry.getMonitoredFile().getParentFile());
            deploymentRequest.setName(string);
            deploymentRequest.setForced(true);
            deploymentRequest.iAmNotAnAdminServer();
            Deployer deployer = DeployerFactory.getDeployer(deploymentRequest);
            deployer.doRequest();
            deployer.cleanup();
        }
        catch (IASDeploymentException iASDeploymentException) {
            _logger.log(Level.WARNING, "core.error_while_redeploying_app", iASDeploymentException);
            bl = false;
        }
        if (bl) {
            bl = this.applicationDeployed(string, false);
        }
        return bl;
    }

    public synchronized void applicationDeployed(ApplicationDeployEvent applicationDeployEvent) throws AdminEventListenerException {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + applicationDeployEvent.toString());
            }
            this.configManager.refreshConfigContext(applicationDeployEvent.getConfigContext());
            String string = applicationDeployEvent.getApplicationName();
            boolean bl = this.applicationDeployed(string);
            if (!bl) {
                String string2 = localStrings.getString("applicationmgr.application_deployed_failed", string);
                throw new AdminEventListenerException(string2);
            }
        }
        catch (ConfigException configException) {
            throw new AdminEventListenerException(configException.getMessage());
        }
    }

    public synchronized void applicationUndeployed(ApplicationDeployEvent applicationDeployEvent) throws AdminEventListenerException {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + applicationDeployEvent.toString());
            }
            this.configManager.refreshConfigContext(applicationDeployEvent.getOldConfigContext());
            String string = applicationDeployEvent.getApplicationName();
            boolean bl = this.applicationUndeployed(string);
            if (!bl) {
                String string2 = localStrings.getString("applicationmgr.application_undeployed_failed", string);
                throw new AdminEventListenerException(string2);
            }
        }
        catch (ConfigException configException) {
            throw new AdminEventListenerException(configException.getMessage());
        }
    }

    public synchronized void applicationRedeployed(ApplicationDeployEvent applicationDeployEvent) throws AdminEventListenerException {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + applicationDeployEvent.toString());
            }
            this.configManager.refreshConfigContext(applicationDeployEvent.getConfigContext());
            String string = applicationDeployEvent.getApplicationName();
            boolean bl = this.applicationUndeployed(string);
            if (bl) {
                bl = this.applicationDeployed(string);
            }
            if (!bl) {
                String string2 = localStrings.getString("applicationmgr.application_redeployed_failed", string);
                throw new AdminEventListenerException(string2);
            }
        }
        catch (ConfigException configException) {
            throw new AdminEventListenerException(configException.getMessage());
        }
    }

    public synchronized void applicationEnabled(ApplicationDeployEvent applicationDeployEvent) throws AdminEventListenerException {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + applicationDeployEvent.toString());
            }
            this.configManager.refreshConfigContext(applicationDeployEvent.getConfigContext());
            String string = applicationDeployEvent.getApplicationName();
            boolean bl = this.applicationDeployed(string);
            if (!bl) {
                String string2 = localStrings.getString("applicationmgr.application_enabled_failed", string);
                throw new AdminEventListenerException(string2);
            }
        }
        catch (ConfigException configException) {
            throw new AdminEventListenerException(configException.getMessage());
        }
    }

    public synchronized void applicationDisabled(ApplicationDeployEvent applicationDeployEvent) throws AdminEventListenerException {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + applicationDeployEvent.toString());
            }
            this.configManager.refreshConfigContext(applicationDeployEvent.getConfigContext());
            String string = applicationDeployEvent.getApplicationName();
            boolean bl = this.applicationUndeployed(string);
            if (!bl) {
                String string2 = localStrings.getString("applicationmgr.application_disabled_failed", string);
                throw new AdminEventListenerException(string2);
            }
        }
        catch (ConfigException configException) {
            throw new AdminEventListenerException(configException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

