/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.auth.realm.certificate;

import com.iplanet.ias.security.auth.realm.IASRealm;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.AuthenticationInfoImpl;
import com.sun.enterprise.security.auth.AuthenticationStatusImpl;
import com.sun.enterprise.security.auth.LocalCredentialsImpl;
import com.sun.enterprise.security.auth.Privilege;
import com.sun.enterprise.security.auth.PrivilegeImpl;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import sun.security.x509.X500Name;

public class CertificateRealm
extends IASRealm {
    public static final String AUTH_TYPE = "certificate";
    public static final String PARAM_GROUPS = "assign-groups";
    private static final String GROUPS_SEP = ",";
    private Vector defaultGroups = null;
    private Privilege[] groupsAsPrivileges = null;

    protected void init(Properties properties) {
        this.defaultGroups = new Vector();
        String string = properties.getProperty(PARAM_GROUPS);
        if (string != null) {
            IASRealm._logger.fine("CertificateRealm : groups: " + string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, GROUPS_SEP);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.defaultGroups.add(string2);
            }
            int n = this.defaultGroups.size();
            this.groupsAsPrivileges = new Privilege[n];
            int n2 = 0;
            while (n2 < n) {
                this.groupsAsPrivileges[n2] = new PrivilegeImpl((String)this.defaultGroups.get(n2));
                ++n2;
            }
        } else {
            this.groupsAsPrivileges = new Privilege[0];
        }
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getGroupNames(String string) throws NoSuchUserException, InvalidOperationException {
        return this.defaultGroups.elements();
    }

    public String getJAASContext() {
        IASRealm._logger.warning("certrealm.nojaas");
        return null;
    }

    public void authenticate(Subject subject, X500Name x500Name) {
        String string = x500Name.getName();
        IASRealm._logger.finest("Certificate realm setting up security context for: " + string);
        String string2 = Realm.getDefaultRealm();
        AuthenticationInfoImpl authenticationInfoImpl = new AuthenticationInfoImpl(string, string2, true);
        authenticationInfoImpl.setAttribute("Groups", this.groupsAsPrivileges);
        AuthenticationStatusImpl authenticationStatusImpl = new AuthenticationStatusImpl(string, AUTH_TYPE, string2, 0);
        LocalCredentialsImpl localCredentialsImpl = new LocalCredentialsImpl();
        localCredentialsImpl.setAuthenticationStatus(authenticationStatusImpl);
        localCredentialsImpl.addAuthenticationInfo(authenticationInfoImpl);
        SecurityContext securityContext = new SecurityContext(string, localCredentialsImpl, subject);
        SecurityContext.setCurrent(securityContext);
    }
}

