/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.jms;

import com.iplanet.ias.config.serverbeans.JmsResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.jms.IASJmsConfig;
import com.iplanet.ias.server.ResourceDeployer;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.repository.IASJ2EEResourceFactoryImpl;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmsResourceDeployer
implements ResourceDeployer {
    private static StringManager _sm = StringManager.getManager(class$com$iplanet$ias$jms$JmsResourceDeployer == null ? (class$com$iplanet$ias$jms$JmsResourceDeployer = JmsResourceDeployer.class$("com.iplanet.ias.jms.JmsResourceDeployer")) : class$com$iplanet$ias$jms$JmsResourceDeployer);
    private IASJmsConfig jmsConfig_;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    static /* synthetic */ Class class$com$iplanet$ias$jms$JmsResourceDeployer;

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void deployResource(Object object) throws Exception {
        if (!((JmsResource)object).isEnabled()) {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{((JmsResource)object).getJndiName(), "jms-resource"});
            return;
        }
        J2EEResource j2EEResource = IASJ2EEResourceFactoryImpl.toJMSJ2EEResource((JmsResource)object);
        int n = j2EEResource.getType();
        if (n == 2) {
            this.createConnectionFactory((JmsCnxFactoryResource)j2EEResource);
            return;
        }
        if (n == 1) {
            this.createDestination((JmsDestinationResource)j2EEResource);
            return;
        }
        String string = _sm.getStringWithDefault("jms.resource_badtype", "Unexpected resource type " + n + " for " + j2EEResource.getName(), new Object[]{new Integer(n), j2EEResource.getName()});
        throw new Exception(string);
    }

    public synchronized void undeployResource(Object object) throws Exception {
        J2EEResource j2EEResource = IASJ2EEResourceFactoryImpl.toJMSJ2EEResource((JmsResource)object);
        int n = j2EEResource.getType();
        if (n == 2) {
            this.deleteConnectionFactory((JmsCnxFactoryResource)j2EEResource);
        } else if (n == 1) {
            this.deleteDestination((JmsDestinationResource)j2EEResource);
        } else {
            String string = _sm.getStringWithDefault("jms.resource_badtype", "Unexpected resource type " + n + " for " + j2EEResource.getName(), new Object[]{new Integer(n), j2EEResource.getName()});
            throw new Exception(string);
        }
    }

    public synchronized void redeployResource(Object object) throws Exception {
        this.deployResource(object);
    }

    public synchronized void enableResource(Object object) throws Exception {
        this.deployResource(object);
    }

    public synchronized void disableResource(Object object) throws Exception {
        this.undeployResource(object);
    }

    public Object getResource(String string, Resources resources) throws Exception {
        if (string == null || string.equals("")) {
            String string2 = _sm.getStringWithDefault("jms.resource_noname", "Resource name not specified: " + string);
            throw new Exception(string2);
        }
        JmsResource jmsResource = resources.getJmsResourceByJndiName(string);
        if (jmsResource == null) {
            String string3 = _sm.getStringWithDefault("jms.resource_notfound", "Resource " + string + " not found", new Object[]{string});
            throw new Exception(string3);
        }
        return jmsResource;
    }

    private void createConnectionFactory(JmsCnxFactoryResource jmsCnxFactoryResource) throws Exception {
        IASJmsConfig iASJmsConfig = this.getJmsConfig();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = jmsCnxFactoryResource.getProperties().iterator();
        while (iterator.hasNext()) {
            ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
            String string = resourceProperty.getName();
            Object object = resourceProperty.getValue();
            if (string == null || string.equals("")) {
                String string2 = _sm.getStringWithDefault("jms.resource_badpropname", "Bad property name " + string + " for " + jmsCnxFactoryResource.getName(), new Object[]{jmsCnxFactoryResource.getName()});
                throw new Exception(string2);
            }
            if (object == null) {
                String string3 = _sm.getStringWithDefault("jms.resource_badpropvalue", "Bad property value " + object + " for " + jmsCnxFactoryResource.getName(), new Object[]{jmsCnxFactoryResource.getName()});
                throw new Exception(string3);
            }
            hashMap.put(string, object);
        }
        iASJmsConfig.createConnectionFactory(jmsCnxFactoryResource.getName(), jmsCnxFactoryResource.getIsQueue(), hashMap);
    }

    private void deleteConnectionFactory(JmsCnxFactoryResource jmsCnxFactoryResource) throws Exception {
        IASJmsConfig iASJmsConfig = this.getJmsConfig();
        iASJmsConfig.deleteConnectionFactory(jmsCnxFactoryResource.getName());
    }

    private void createDestination(JmsDestinationResource jmsDestinationResource) throws Exception {
        IASJmsConfig iASJmsConfig = this.getJmsConfig();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = jmsDestinationResource.getProperties().iterator();
        while (iterator.hasNext()) {
            ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
            String string = resourceProperty.getName();
            Object object = resourceProperty.getValue();
            if (string == null || string.equals("")) {
                String string2 = _sm.getStringWithDefault("jms.resource_badpropname", "Bad property name " + string + " for " + jmsDestinationResource.getName(), new Object[]{jmsDestinationResource.getName()});
                throw new Exception(string2);
            }
            if (object == null) {
                String string3 = _sm.getStringWithDefault("jms.resource_badpropvalue", "Bad property value " + object + " for " + jmsDestinationResource.getName(), new Object[]{jmsDestinationResource.getName()});
                throw new Exception(string3);
            }
            hashMap.put(string, object);
        }
        iASJmsConfig.createDestination(jmsDestinationResource.getName(), jmsDestinationResource.getIsQueue(), hashMap);
    }

    private void deleteDestination(JmsDestinationResource jmsDestinationResource) throws Exception {
        IASJmsConfig iASJmsConfig = this.getJmsConfig();
        iASJmsConfig.deleteDestination(jmsDestinationResource.getName());
    }

    private IASJmsConfig getJmsConfig() throws Exception {
        if (this.jmsConfig_ == null) {
            this.jmsConfig_ = new IASJmsConfig(1);
        }
        return this.jmsConfig_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

