/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.ejb.codegen;

import com.iplanet.ias.ejb.codegen.Compiler;
import com.iplanet.ias.ejb.codegen.JavaCompilerException;
import com.iplanet.ias.ejb.codegen.ProcessExecutorException;
import com.iplanet.ias.util.OS;
import com.iplanet.ias.util.io.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import sun.rmi.rmic.Main;

class RMICompiler
extends Compiler {
    private File rmicExe;
    private File javaExe;
    private Set generatedFilenames = null;
    private String classpath = null;
    private static int timeout = -1;

    RMICompiler(List list, List list2) throws JavaCompilerException {
        super(list, list2);
    }

    void setClasspath(String string) {
        this.classpath = string;
    }

    protected void internal_compile() throws JavaCompilerException, ProcessExecutorException {
        try {
            if (this.nativeExternalCompile()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.nativeCompile();
    }

    private boolean nativeExternalCompile() throws ProcessExecutorException {
        if (this.classpath == null || this.javaExe == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.javaExe.getPath());
        arrayList.add("-classpath");
        arrayList.add(this.classpath);
        arrayList.add("sun.rmi.rmic.Main");
        arrayList.addAll(this.options);
        this.addJavaFiles(arrayList);
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        this.runProcess(stringArray, RMICompiler.getRmicTimeout() * this.files.size());
        this.logCompilerName("rmic in external JVM");
        return true;
    }

    private void nativeCompile() throws JavaCompilerException {
        this.options.addAll(this.files);
        String[] stringArray = new String[this.options.size()];
        stringArray = this.options.toArray(stringArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Main main = new Main(byteArrayOutputStream, "rmic");
        boolean bl = main.compile(stringArray);
        String string = byteArrayOutputStream.toString();
        this.parseGeneratedFilenames(string);
        if (!bl) {
            throw new JavaCompilerException("rmi_compiler.error", "RMI compiler returned an error: {0}", string);
        }
        this.logCompilerName("native rmic (sun.rmi.rmic.Main)");
    }

    protected void internal_init() {
        String string;
        String string2;
        this.rmicExe = null;
        this.javaExe = null;
        if (this.installRoot == null) {
            return;
        }
        if (OS.isWindows()) {
            string2 = "rmic.exe";
            string = "java.exe";
        } else {
            string2 = "rmic";
            string = "java";
        }
        this.rmicExe = new File(this.installRoot + "/jdk/bin/" + string2);
        this.rmicExe = this.rmicExe.exists() ? FileUtils.safeGetCanonicalFile(this.rmicExe) : null;
        this.javaExe = new File(this.installRoot + "/jdk/bin/" + string);
        this.javaExe = this.javaExe.exists() ? FileUtils.safeGetCanonicalFile(this.javaExe) : null;
    }

    private static int getRmicTimeout() {
        if (timeout < 0) {
            timeout = Compiler.getTimeout("com.sun.aas.deployment.Rmic.TimeoutMS", 40000, 5000, 300000);
        }
        return timeout;
    }

    private void parseGeneratedFilenames(String string) {
        this.generatedFilenames = new HashSet();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("[generated") || !stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            this.generatedFilenames.add(string3);
            Compiler.logger.log(Level.FINER, "[RMIC] Generated: " + string3);
        }
    }

    Set getGeneratedFilenames() {
        return this.generatedFilenames;
    }
}

