/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.AppDeployer;
import com.iplanet.ias.deployment.backend.AppReDeployer;
import com.iplanet.ias.deployment.backend.AppUnDeployer;
import com.iplanet.ias.deployment.backend.ConnectorModuleDeployer;
import com.iplanet.ias.deployment.backend.Deployer;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.EjbModuleDeployer;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.backend.WebModuleDeployer;
import com.iplanet.ias.util.i18n.StringManager;

public class DeployerFactory {
    private static StringManager localStrings;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$DeployerFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DeployerFactory() {
    }

    public static Deployer getDeployer(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        if (!$assertionsDisabled && deploymentRequest == null) {
            throw new AssertionError();
        }
        deploymentRequest.verify();
        if (deploymentRequest.isApplication()) {
            return DeployerFactory.getAppDeployer(deploymentRequest);
        }
        if (deploymentRequest.isEjbModule()) {
            return new EjbModuleDeployer(deploymentRequest);
        }
        if (deploymentRequest.isWebModule()) {
            return new WebModuleDeployer(deploymentRequest);
        }
        if (deploymentRequest.isConnectorModule()) {
            return new ConnectorModuleDeployer(deploymentRequest);
        }
        String string = localStrings.getString("enterprise.deployment.backend.deployment_not_supported");
        throw new IASDeploymentException(string);
    }

    public static Deployer getAppDeployer(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        if (deploymentRequest.isDeploy()) {
            return new AppDeployer(deploymentRequest);
        }
        if (deploymentRequest.isReDeploy()) {
            return new AppReDeployer(deploymentRequest);
        }
        if (deploymentRequest.isUnDeploy()) {
            return new AppUnDeployer(deploymentRequest);
        }
        String string = localStrings.getString("enterprise.deployment.backend.unknown_deployment_request_type");
        throw new IASDeploymentException(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$backend$DeployerFactory == null ? (class$com$iplanet$ias$deployment$backend$DeployerFactory = DeployerFactory.class$("com.iplanet.ias.deployment.backend.DeployerFactory")) : class$com$iplanet$ias$deployment$backend$DeployerFactory).desiredAssertionStatus();
        localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$DeployerFactory == null ? (class$com$iplanet$ias$deployment$backend$DeployerFactory = DeployerFactory.class$("com.iplanet.ias.deployment.backend.DeployerFactory")) : class$com$iplanet$ias$deployment$backend$DeployerFactory);
    }
}

