/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.connection;

import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.connection.ConnectionException;
import com.iplanet.ias.cis.connection.ConnectionInputStream;
import com.iplanet.ias.cis.connection.NotSupportedException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NonBlockingConnectionInputStream
extends ConnectionInputStream {
    private Channel channel;
    private final boolean isMarked = false;
    private boolean validStream = true;

    public NonBlockingConnectionInputStream(Channel channel) throws ConnectionException {
        this.channel = channel;
    }

    private void isNotValidStream() throws IOException {
        if (!this.validStream) {
            throw new IOException("Stream already closed");
        }
    }

    public int available() throws IOException {
        this.isNotValidStream();
        return 0;
    }

    public void close() throws IOException {
        this.isNotValidStream();
        this.validStream = false;
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        this.isNotValidStream();
        byte[] byArray = new byte[1];
        int n = 0;
        try {
            n = this.channel.recv(byArray, 0, 1, 0);
        }
        catch (ChannelException channelException) {
            throw new IOException("Data not read fully");
        }
        if (n == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.isNotValidStream();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            return this.channel.recv(byArray, n, n2, 0);
        }
        catch (ChannelException channelException) {
            throw new IOException("Data not read fully");
        }
    }

    public void reset() throws IOException {
        this.isNotValidStream();
        throw new IOException("mark/reset not supported");
    }

    public long skip(long l) throws IOException {
        this.isNotValidStream();
        return l;
    }

    public int read(ByteBuffer byteBuffer, int n) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public int read(byte[] byArray, int n) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public int read(byte[] byArray, int n, int n2, int n3) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public boolean readBoolean() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    private int load(int n, int n2) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public char readChar() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public short readShort() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public int readInt() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public long readLong() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public float readFloat() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public double readDouble() throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }
}

