/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.connection;

import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.connection.ConnectionOutputStream;
import com.iplanet.ias.cis.connection.NotSupportedException;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractConnectionOutputStream
extends ConnectionOutputStream {
    protected Channel channel = null;
    protected boolean isValid = false;

    public AbstractConnectionOutputStream(Channel channel) throws ChannelException {
        this.channel = channel;
        this.isValid = true;
    }

    public void close() throws IOException {
        if (!this.isValid) {
            throw new IOException("Stream already closed");
        }
        this.flush();
        this.isValid = false;
    }

    public void flush() throws IOException {
    }

    public void write(byte[] byArray) throws IOException {
        if (!this.isValid) {
            throw new IOException("Can't write to closed stream");
        }
        try {
            this.channel.sendFully(byArray, 0, byArray.length);
        }
        catch (ChannelException channelException) {
            throw new IOException(channelException.getMessage());
        }
    }

    public void write(ByteBuffer byteBuffer) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isValid) {
            throw new IOException("Can't write to closed stream");
        }
        try {
            this.channel.sendFully(byArray, n, n2);
        }
        catch (ChannelException channelException) {
            throw new IOException(channelException.getMessage());
        }
    }

    public abstract int writeAsync(byte[] var1) throws IOException, NotSupportedException;

    public abstract int writeAsync(byte[] var1, int var2, int var3) throws IOException, NotSupportedException;

    public void write(int n) throws IOException {
        if (!this.isValid) {
            throw new IOException("Can't write to closed stream");
        }
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        try {
            this.channel.sendFully(byArray, 0, 1);
        }
        catch (ChannelException channelException) {
            throw new IOException("Data not sent fully");
        }
    }

    public void writeBoolean(boolean bl) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public void writeInt(int n) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public void writeLong(long l) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public void writeChar(char c) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public void writeByte(byte by) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public void writeShort(short s) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public void writeDouble(double d) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }

    public void writeFloat(float f) throws IOException, NotSupportedException {
        throw new NotSupportedException();
    }
}

