/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.Acl;
import com.iplanet.ias.config.serverbeans.HttpListener;
import com.iplanet.ias.config.serverbeans.Mime;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.VirtualServer;
import com.iplanet.ias.config.serverbeans.VirtualServerClass;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VirtualServerTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            VirtualServerClass[] virtualServerClassArray = server.getHttpService().getVirtualServerClass();
            int n = 0;
            while (n < virtualServerClassArray.length) {
                VirtualServer[] virtualServerArray = virtualServerClassArray[n].getVirtualServer();
                int n2 = 0;
                while (n2 < virtualServerArray.length) {
                    File file;
                    int n3;
                    Object object;
                    try {
                        int n4 = Integer.parseInt(virtualServerArray[n2].getId().substring(0, 1));
                        if (n4 <= 9) {
                            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidServerID", "Virtual Server ID cannot start with a number"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String string = virtualServerArray[n2].getMime();
                    if (string != null && !this.isMimeAvailable(string, configContext)) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".noMime", "Mime type " + virtualServerArray[n2].getMime() + " not available for virtual server " + virtualServerClassArray[n].getId(), new Object[]{virtualServerArray[n2].getMime(), virtualServerClassArray[n].getId()}));
                    }
                    if ((string = virtualServerArray[n2].getAcls()) != null) {
                        if (string.equals("")) {
                            result.failed(this.smh.getLocalString(this.getClass().getName() + ".nullACL", "ACL cannot be null String for virtual server " + virtualServerArray[n].getId(), new Object[]{virtualServerArray[n].getId()}));
                        }
                        object = this.tokens(string);
                        n3 = 0;
                        while (n3 < ((Vector)object).size()) {
                            if (!this.isAclAvailable((String)((Vector)object).get(n3), configContext)) {
                                result.failed(this.smh.getLocalString(this.getClass().getName() + ".noACL", "Acl not available for virtual server " + virtualServerArray[n].getId(), new Object[]{virtualServerArray[n].getId()}));
                            }
                            ++n3;
                        }
                    }
                    if ((string = virtualServerArray[n2].getHttpListeners()) != null) {
                        if (string.equals("")) {
                            result.failed(this.smh.getLocalString(this.getClass().getName() + ".nullListener", "Http Listeners cannot be null string for virtual server " + virtualServerArray[n].getId(), new Object[]{virtualServerArray[n].getId()}));
                        }
                        object = this.tokens(string);
                        n3 = 0;
                        while (n3 < ((Vector)object).size()) {
                            if (!this.isHttpListenerAvailable((String)((Vector)object).get(n), configContext)) {
                                result.failed(this.smh.getLocalString(this.getClass().getName() + ".noListener", "Http Listener not available for virtual server " + virtualServerArray[n].getId(), new Object[]{virtualServerArray[n].getId()}));
                            }
                            ++n3;
                        }
                    }
                    if ((object = virtualServerArray[n2].getConfigFile()) != null && !((String)object).equals("obj.conf") && !(file = new File((String)object)).exists()) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".noConfig", "Config File " + (String)object + " does not exists for virtual server " + virtualServerClassArray[n].getId(), new Object[]{object, virtualServerClassArray[n].getId()}));
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result = new Result();
        Object object = configContextEvent.getObject();
        ConfigContext configContext = configContextEvent.getConfigContext();
        String string = configContextEvent.getBeanName();
        result.passed("Passed ***");
        if (string != null) {
            String string2 = configContextEvent.getName();
            result = this.testSave(string2, (String)object, configContext);
            return result;
        }
        VirtualServer virtualServer = (VirtualServer)object;
        String string3 = virtualServer.getId();
        if (!StaticTest.checkObjectName(string3, result)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidID", "Virtual Server ID Invalid"));
            return result;
        }
        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validObj", "Valid Object Name"));
        boolean bl = false;
        int n = 0;
        while (n < 10) {
            if (virtualServer.getId().startsWith(String.valueOf(n))) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidID1", "ID cannot start with a number"));
        }
        if (!this.isMimeAvailable(virtualServer.getMime(), configContext)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".noMimeID", "Mime id not available"));
        }
        return result;
    }

    public Result testSave(String string, String string2, ConfigContext configContext) {
        int n;
        Serializable serializable;
        Result result = new Result();
        result.passed("passed ****");
        if (string.equals(ServerTags.CONFIG_FILE) && string2 != null && !((File)(serializable = new File(string2))).exists()) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".noConfigFile", "Config File Does not exist"));
        }
        if (string.equals(ServerTags.LOG_FILE) && string2 != null && !((File)(serializable = new File(string2))).exists()) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".noLogFile", "Log File does not exist"));
        }
        if (string.equals(ServerTags.ACLS) && string2 != null) {
            serializable = this.tokens(string2);
            n = 0;
            while (n < ((Vector)serializable).size()) {
                if (!this.isAclAvailable((String)((Vector)serializable).get(n), configContext)) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".noACL1", "Acl not available"));
                    return result;
                }
                ++n;
            }
        }
        if (string.equals(ServerTags.HTTP_LISTENERS) && string2 != null) {
            serializable = this.tokens(string2);
            n = 0;
            while (n < ((Vector)serializable).size()) {
                if (!this.isHttpListenerAvailable((String)((Vector)serializable).get(n), configContext)) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".noHTTPListener", "Http Listener not available"));
                    return result;
                }
                ++n;
            }
        }
        return result;
    }

    public boolean isMimeAvailable(String string, ConfigContext configContext) {
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Mime[] mimeArray = server.getHttpService().getMime();
            int n = 0;
            while (n < mimeArray.length) {
                if (string.equals(mimeArray[n].getId())) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
        }
        return false;
    }

    public boolean isAclAvailable(String string, ConfigContext configContext) {
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Acl[] aclArray = server.getHttpService().getAcl();
            int n = 0;
            while (n < aclArray.length) {
                if (string.equals(aclArray[n].getId())) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
        }
        return false;
    }

    public boolean isHttpListenerAvailable(String string, ConfigContext configContext) {
        try {
            Server server = (Server)configContext.getRootConfigBean();
            HttpListener[] httpListenerArray = server.getHttpService().getHttpListener();
            int n = 0;
            while (n < httpListenerArray.length) {
                if (string.equals(httpListenerArray[n].getId())) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
        }
        return false;
    }

    public Vector tokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }
}

