/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.EjbContainer;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EjbContainerTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    static int ejbSteadyQty = 0;
    static int ejbMaxCacheSize = 0;
    static int ejbResizeQty = 0;

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            String string;
            Server server = (Server)configContext.getRootConfigBean();
            EjbContainer ejbContainer = server.getEjbContainer();
            try {
                string = ejbContainer.getSteadyPoolSize();
                if (Integer.parseInt(string) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolNegative", "Steady Pool size cannot be a negative number"));
                } else {
                    result.passed("*** passed *****");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolInvalid", "Steady Pool Size : invalid number"));
            }
            try {
                string = ejbContainer.getMaxPoolSize();
                if (Integer.parseInt(string) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolNegative", "Max Pool Size cannot be a negative number"));
                } else {
                    result.passed("**** Passed *****");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolInvalid", "Max. Pool Size : invalid number "));
            }
            try {
                string = ejbContainer.getPoolIdleTimeoutInSeconds();
                if (Integer.parseInt(string) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutNegative", "Pool Idle Timeout cannot be negative number"));
                } else {
                    result.passed("**** Passed ****");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutInvalid", "Pool Idle timeout : invalid number"));
            }
            try {
                string = ejbContainer.getPoolResizeQuantity();
                if (Integer.parseInt(string) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyNegative", "Pool resize quantity cannot be negative number"));
                } else {
                    result.passed("**** Passed ****");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyInvalid", "Pool Resize Quantity : invalid number "));
            }
            try {
                string = ejbContainer.getMaxCacheSize();
                if (Integer.parseInt(string) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxCacheNegative", "Max Cache Size cannot be negative number"));
                } else {
                    result.passed("**** Passed ****");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxCacheInvalid", "Max Cache Size  : invalid number "));
            }
            try {
                string = ejbContainer.getCacheResizeQuantity();
                if (Integer.parseInt(string) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheResizeNegative", "Cache Resize Qty cannot be negative number"));
                } else {
                    result.passed("**** Passed ****");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheResizeInvalid", "Cache Resize Qty : invalid number "));
            }
            try {
                string = ejbContainer.getCacheIdleTimeoutInSeconds();
                if (Integer.parseInt(string) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheIdleTimeoutNegative", "Cache Idle Timeout cannot be negative number"));
                } else {
                    result.passed("**** Passed ****");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheIdleTimeoutInvalid", "Cache Idle Timeout  : invalid number "));
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Object object = configContextEvent.getObject();
        ConfigContext configContext = configContextEvent.getConfigContext();
        Result result = new Result();
        result.passed("Passed ** ");
        String string = configContextEvent.getBeanName();
        if (string != null) {
            String string2 = configContextEvent.getName();
            if (string2 != null && object != null) {
                result = this.validateAttribute(string2, (String)object);
            }
            return result;
        }
        return result;
    }

    public Result validateAttribute(String string, String string2) {
        int n;
        Result result = new Result();
        boolean bl = false;
        result.passed("Passed **");
        if (string.equals(ServerTags.STEADY_POOL_SIZE)) {
            n = Integer.parseInt(string2);
            try {
                if (n < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolNegative", "Steady Pool size cannot be a negative number"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                    ejbSteadyQty = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolInvalid", "Steady Pool Size : invalid number"));
                bl = true;
            }
        }
        if (string.equals(ServerTags.MAX_POOL_SIZE)) {
            n = Integer.parseInt(string2);
            try {
                if (n < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolNegative", "Max Pool Size cannot be a negative number"));
                    bl = true;
                } else if (n < ejbSteadyQty) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolMaxPoolError", "Steady Pool Size should be less than or equal to Maximum Pool Size"));
                    bl = true;
                } else if (n < ejbResizeQty) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizePoolMaxPoolError", "Pool Resize Qty should be less than or equal to Maximum Pool Size"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolInvalid", "Max. Pool Size : invalid number "));
                bl = true;
            }
        }
        if (string.equals(ServerTags.POOL_RESIZE_QUANTITY)) {
            n = Integer.parseInt(string2);
            try {
                if (n < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyNegative", "Pool resize quantity cannot be negative number"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                    ejbResizeQty = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyInvalid", "Pool Resize Quantity : invalid number "));
                bl = true;
            }
        }
        if (string.equals(ServerTags.POOL_IDLE_TIMEOUT_IN_SECONDS)) {
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutNegative", "Pool Idle Timeout cannot be negative number"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutInvalid", "Pool Idle timeout : invalid number"));
                bl = true;
            }
        }
        if (string.equals(ServerTags.MAX_CACHE_SIZE)) {
            int n2 = Integer.parseInt(string2);
            try {
                if (n2 < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxCacheNegative", "Max Cache Size cannot be negative number"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                    ejbMaxCacheSize = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxCacheInvalid", "Max Cache Size  : invalid number "));
                bl = true;
            }
        }
        if (string.equals(ServerTags.CACHE_RESIZE_QUANTITY)) {
            int n3 = Integer.parseInt(string2);
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheResizeNegative", "Cache Resize Qty cannot be negative number"));
                    bl = true;
                } else if (n3 > ejbMaxCacheSize) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheResizeMaxCacheError", "Cache Resize Quantity should be less than or equal to Maximum Cache Size"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheResizeInvalid", "Cache Resize Qty : invalid number "));
                bl = true;
            }
        }
        if (string.equals(ServerTags.REMOVAL_TIMEOUT_IN_SECONDS)) {
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".removalTimeNegative", "Removal Timeout cannot be negative number"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".removalTimeInvalid", "Removal Timeout : invalid number"));
                bl = true;
            }
        }
        if (string.equals(ServerTags.CACHE_IDLE_TIMEOUT_IN_SECONDS)) {
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheIdleTimeoutNegative", "Cache Idle Timeout cannot be negative number"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheIdleTimeoutInvalid", "Cache Idle Timeout  : invalid number "));
                bl = true;
            }
        }
        if (bl) {
            result.setStatus(1);
        }
        return result;
    }
}

