/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier;

import com.iplanet.ias.admin.verifier.ServerMgr;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.sun.enterprise.tools.verifier.ResultMgr;
import com.sun.enterprise.tools.verifier.ResultsReport;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerXMLVerifier {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    public boolean debug = false;
    public String outputFileStr = null;
    public static final int FAIL = 0;
    public static final int WARN = 1;
    public static final int ALL = 2;
    private static int reportLevel = 2;
    public ResultMgr resultMgr = null;
    private ResultsReport resultReport = null;
    public String xmlFileName;
    public ConfigContext configContext = null;
    public LocalStringManagerImpl smh;
    public static ServerMgr serverMgr;

    public ServerXMLVerifier() {
        try {
            this.resultMgr = new ResultMgr();
            this.resultReport = new ResultsReport();
            StringManagerHelper.setLocalStringsManager(Class.forName(this.getClass().getName()));
            this.smh = StringManagerHelper.getLocalStringsManager();
        }
        catch (ClassNotFoundException classNotFoundException) {
            _logger.log(Level.FINE, "serverxmlverifier.error_getting_localstringsmanager", classNotFoundException);
        }
        this.init();
    }

    public boolean verify() {
        boolean bl = false;
        try {
            this.configContext = ConfigFactory.createConfigContext(this.xmlFileName);
            this.configContext.refresh();
            if (serverMgr == null) {
                serverMgr = new ServerMgr(true);
            }
            serverMgr.check(this.configContext);
            bl = true;
        }
        catch (ConfigException configException) {
            _logger.log(Level.FINE, "serverxmlverifier.error_creating_object", configException);
            bl = false;
        }
        return bl;
    }

    public boolean isPassed(String string) throws ConfigException {
        boolean bl = false;
        this.configContext = ConfigFactory.createConfigContext(string);
        this.configContext.refresh();
        if (serverMgr == null) {
            serverMgr = new ServerMgr(this.debug);
        }
        bl = serverMgr.testStatus(this.configContext);
        return bl;
    }

    public void init() {
        File file = new File("lib/TestNamesMBean.xml");
        if (file.exists()) {
            _logger.log(Level.INFO, "serverxmlverifier.looking_file", file.getAbsolutePath());
        }
    }

    public static void main(String[] stringArray) {
        ServerXMLVerifier serverXMLVerifier = new ServerXMLVerifier();
        serverXMLVerifier.parseArgs(stringArray);
    }

    protected void parseArgs(String[] stringArray) {
        if (stringArray.length < 1) {
            this.usage();
        } else {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (string.startsWith("-")) {
                    try {
                        switch (string.charAt(1)) {
                            case 'v': {
                                this.debug = true;
                                this.debug(this.smh.getLocalString(this.getClass().getName() + ".verboseFlag", "Setting verbose flag to TRUE."));
                                break;
                            }
                            case 'h': {
                                this.debug(this.smh.getLocalString(this.getClass().getName() + ".helpMessage", "Displaying help message."));
                                this.usage();
                                break;
                            }
                            case 'o': {
                                this.debug(this.smh.getLocalString(this.getClass().getName() + ".outputFileName", "Retrieving results output filename."));
                                char[] cArray = new char[string.length() - 2];
                                string.getChars(2, string.length(), cArray, 0);
                                this.outputFileStr = new String(cArray);
                                this.debug("Using this output file = " + this.outputFileStr);
                                ServerMgr.setFile(this.outputFileStr);
                                this.resultReport.setUserSpecifiedOutputFile(true);
                                break;
                            }
                            default: {
                                this.usage();
                                break;
                            }
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        this.debug(stringIndexOutOfBoundsException);
                        this.usage();
                    }
                } else if (this.xmlFileName == null) {
                    this.xmlFileName = new File(string).getAbsolutePath();
                    this.debug(this.smh.getLocalString(this.getClass().getName() + ".xmlFileName", "XML filename: {0}", new Object[]{this.xmlFileName}));
                } else {
                    this.debug(this.smh.getLocalString(this.getClass().getName() + "invalidArg", "invalid argument \"{0}\"", new Object[]{string}));
                    this.usage();
                    return;
                }
                ++n;
            }
            if (this.xmlFileName == null) {
                this.usage();
                return;
            }
            this.verify();
        }
    }

    public void usage() {
        System.err.println("\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine1", "usage: server-verifier [optional_params] <server-xml-filename>") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine2", "where :") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine3", "  [optional_params]: Must be: ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine4", "     -v : verbose debug turned on ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine5", "    -o<output file> : test results written to this file (.xml file preferred)") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine6", "                      (Overrides default file - Results.xml)") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine6a", "                      which is created in system defined <tmp> directory") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine17", "<server-xml-filename>: Jar file to perform static verification on ") + "\n\n");
    }

    public void debug(String string) {
        if (this.debug) {
            _logger.log(Level.INFO, string);
        }
    }

    public void debug(Exception exception) {
        if (this.debug) {
            _logger.log(Level.INFO, "serverxmlverifier.error_check", exception);
        }
    }
}

