/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.AdminBase;
import com.iplanet.ias.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.iplanet.ias.admin.server.core.mbean.meta.MBeanEasyConfig;
import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.util.i18n.StringManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ConfigMBeanBase
extends AdminBase {
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String MSG_BASE_GET_ATTRIBUTE = "mbean.config.base_get_attribute";
    private static final String MSG_BASE_SET_ATTRIBUTE = "mbean.config.base_set_attribute";
    private static final String MSG_BASE_GOT_ATTRIBUTE = "mbean.config.base_got_attribute";
    private static final String MSG_BASE_GET_PROPERTY = "mbean.config.base_get_property";
    private static final String MSG_BASE_SET_PROPERTY = "mbean.config.base_set_property";
    private static final String MSG_BASE_GET_DEF_ATTR_VALUE = "mbean.config.get_def_attr_value";
    private static final String MSG_GET_CONFBEANBYXPATH = "mbean.config.get_confbeanbyxpath";
    public static final char ATTRIBUTE_CHAR = '@';
    public static final char ALLOWS_EMPTY_CHAR = '@';
    public static final String ATTRIBUTE = "@";
    public static final String E_ATTRIBUTE = "@@";
    public static final String PROPERTY = ServerTags.ELEMENT_PROPERTY + "/" + "@";
    public static final String E_PROPERTY = ServerTags.ELEMENT_PROPERTY + "/" + "@@";
    public static final String ELEMENT_CONTENT = "";
    public static final String PSEUDO_ATTR_DESCRIPTION = ServerTags.DESCRIPTION;
    private ConfigContext m_configContext;
    private String m_BasePath;
    private Hashtable m_Attrs;
    private MBeanInfo m_MBeanInfo;
    private String m_ServerInstanceName;
    private ConfigMBeanNamingInfo m_MBeanNamingInfo;
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$mbean$config$ConfigMBeanBase == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$ConfigMBeanBase = ConfigMBeanBase.class$("com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase")) : class$com$iplanet$ias$admin$server$core$mbean$config$ConfigMBeanBase);
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$mbean$config$ConfigMBeanBase;

    public void initialize(ConfigMBeanNamingInfo configMBeanNamingInfo) throws MBeanConfigException {
        ConfigContext configContext;
        String string = configMBeanNamingInfo.getServerInstanceName();
        try {
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
            String string2 = instanceEnvironment.getBackupConfigFilePath();
            configContext = ConfigFactory.createConfigContext(string2);
        }
        catch (ConfigException configException) {
            String string3 = localStrings.getString("admin.server.core.mbean.config.error_locating_server_node", configException.getMessage());
            throw new MBeanConfigException(string3);
        }
        this.m_ServerInstanceName = string;
        this.m_configContext = configContext;
        this.m_MBeanNamingInfo = configMBeanNamingInfo;
        this.m_BasePath = configMBeanNamingInfo.getXPath();
    }

    public void initialize(String string, String[] stringArray) throws MBeanConfigException {
        ConfigMBeanNamingInfo configMBeanNamingInfo;
        try {
            configMBeanNamingInfo = new ConfigMBeanNamingInfo(string, stringArray);
        }
        catch (MBeanConfigException mBeanConfigException) {
            throw mBeanConfigException;
        }
        catch (Exception exception) {
            throw new MBeanConfigException(exception.getMessage());
        }
        this.initialize(configMBeanNamingInfo);
    }

    public void initialize(String string) throws MBeanConfigException {
        ConfigMBeanNamingInfo configMBeanNamingInfo;
        try {
            configMBeanNamingInfo = new ConfigMBeanNamingInfo(string);
        }
        catch (MBeanConfigException mBeanConfigException) {
            throw mBeanConfigException;
        }
        catch (Exception exception) {
            throw new MBeanConfigException(exception.getMessage());
        }
        this.initialize(configMBeanNamingInfo);
    }

    public void initialize(ObjectName objectName) throws MBeanConfigException {
        ConfigMBeanNamingInfo configMBeanNamingInfo;
        try {
            configMBeanNamingInfo = new ConfigMBeanNamingInfo(objectName);
        }
        catch (MBeanConfigException mBeanConfigException) {
            throw mBeanConfigException;
        }
        catch (Exception exception) {
            throw new MBeanConfigException(exception.getMessage());
        }
        this.initialize(configMBeanNamingInfo);
    }

    public void setDescriptions(String[][] stringArray, String[] stringArray2, String[] stringArray3) throws MBeanConfigException {
        this.m_Attrs = this.createAttrsDescriptors(stringArray);
        MBeanEasyConfig mBeanEasyConfig = new MBeanEasyConfig(this.getClass(), stringArray2, stringArray3, null);
        this.m_MBeanInfo = mBeanEasyConfig.getMBeanInfo();
    }

    public ConfigContext getConfigContext() {
        return this.m_configContext;
    }

    public String getServerInstanceName() {
        return this.m_ServerInstanceName;
    }

    public ConfigMBeanNamingInfo getConfigMBeanNamingInfo() {
        return this.m_MBeanNamingInfo;
    }

    public String getBasePath() {
        return this.m_BasePath;
    }

    public ConfigBean getBaseConfigBean() {
        try {
            return this.getConfigBeanByXPath(this.m_BasePath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.m_MBeanInfo;
    }

    public ConfigBean getConfigBean(String string) {
        AttrDescriptor attrDescriptor = this.getDescriptor(string);
        try {
            return attrDescriptor.getConfigBean();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ConfigBean getConfigBeanByXPath(String string) throws ConfigException {
        sLogger.log(Level.FINEST, MSG_GET_CONFBEANBYXPATH, string);
        return ConfigBeansFactory.getConfigBeanByXPath(this.m_configContext, string);
    }

    public Object getAttribute(String string) throws MBeanException, AttributeNotFoundException {
        sLogger.log(Level.FINEST, MSG_BASE_GET_ATTRIBUTE, string);
        MBeanAttributeInfo mBeanAttributeInfo = this.getAttrInfo(string);
        boolean bl = string.startsWith("property.");
        if (mBeanAttributeInfo == null && !bl) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.attribute_not_defined", string);
            throw new AttributeNotFoundException(string2);
        }
        if (mBeanAttributeInfo != null && !mBeanAttributeInfo.isReadable()) {
            String string3 = localStrings.getString("admin.server.core.mbean.config.attribute_not_readable", string);
            throw new AttributeNotFoundException(string3);
        }
        try {
            if (bl) {
                return this.getPropertyElementValue(string.substring("property.".length()));
            }
            AttrDescriptor attrDescriptor = this.getDescriptor(string);
            ConfigBean configBean = this.getConfigBean(string);
            String string4 = null;
            if (attrDescriptor.isElement()) {
                String string5 = localStrings.getString("admin.server.core.mbean.config.getattribute_not_implemented_for_xml");
                throw new MBeanException((Exception)((Object)new MBeanConfigException(string5)));
            }
            string4 = configBean.getAttributeValue(attrDescriptor.getAttributeName());
            sLogger.log(Level.FINEST, MSG_BASE_GOT_ATTRIBUTE, new Object[]{string, string4, MBeanEasyConfig.convertStringValueToProperType(string4, mBeanAttributeInfo.getType())});
            return MBeanEasyConfig.convertStringValueToProperType(string4, mBeanAttributeInfo.getType());
        }
        catch (MBeanConfigException mBeanConfigException) {
            String string6 = localStrings.getString("admin.server.core.mbean.config.getattribute_attribute_exception", string, mBeanConfigException.getMessage());
            throw new MBeanException((Exception)((Object)new MBeanConfigException(string6)));
        }
    }

    public Object getPropertyElementValue(String string) throws MBeanException, AttributeNotFoundException {
        ElementProperty elementProperty;
        Object object;
        sLogger.log(Level.FINEST, MSG_BASE_GET_PROPERTY, string);
        ConfigBean configBean = this.getBaseConfigBean();
        Class<?> clazz = configBean.getClass();
        try {
            object = clazz.getDeclaredMethod("getElementPropertyByName", Class.forName("java.lang.String"));
            elementProperty = (ElementProperty)((Method)object).invoke((Object)configBean, string);
        }
        catch (Exception exception) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.getattribute.undefined_properties_in_base_element", string);
            throw new MBeanException((Exception)((Object)new MBeanConfigException(string2)));
        }
        if (elementProperty == null) {
            object = localStrings.getString("admin.server.core.mbean.config.getattribute_properties_not_found_in_base_element", string);
            throw new MBeanException((Exception)((Object)new MBeanConfigException((String)object)));
        }
        return elementProperty.getValue();
    }

    public void setPropertyElementValue(Attribute attribute, boolean bl) throws MBeanException, AttributeNotFoundException {
        ElementProperty elementProperty;
        Method method;
        String string = attribute.getName();
        String string2 = (String)attribute.getValue();
        sLogger.log(Level.FINEST, MSG_BASE_SET_PROPERTY, new Object[]{string, string2});
        ConfigBean configBean = this.getBaseConfigBean();
        Class<?> clazz = configBean.getClass();
        try {
            method = clazz.getDeclaredMethod("getElementPropertyByName", Class.forName("java.lang.String"));
            elementProperty = (ElementProperty)method.invoke((Object)configBean, string);
        }
        catch (Exception exception) {
            String string3 = localStrings.getString("admin.server.core.mbean.config.setattribute_undefined_properties_in_base_element", string);
            throw new MBeanException((Exception)((Object)new MBeanConfigException(string3)));
        }
        if (elementProperty == null && string2 != null && (bl || !string2.equals(ELEMENT_CONTENT))) {
            elementProperty = new ElementProperty();
            elementProperty.setName(string);
            elementProperty.setValue(string2);
            try {
                method = clazz.getDeclaredMethod("addElementProperty", elementProperty.getClass());
                method.invoke((Object)configBean, elementProperty);
            }
            catch (Exception exception) {
                String string4 = localStrings.getString("admin.server.core.mbean.config.setproperty_invoke_error", string);
                throw new MBeanException((Exception)((Object)new MBeanConfigException(string4)));
            }
        } else if (string2 == null || !bl && string2.equals(ELEMENT_CONTENT)) {
            try {
                method = clazz.getDeclaredMethod("removeElementProperty", elementProperty.getClass());
                method.invoke((Object)configBean, elementProperty);
            }
            catch (Exception exception) {
                String string5 = localStrings.getString("admin.server.core.mbean.config.setproperty_could_not_remove_propery", string);
                throw new MBeanException((Exception)((Object)new MBeanConfigException(string5)));
            }
        } else {
            elementProperty.setValue(string2);
        }
        try {
            this.m_configContext.flush();
        }
        catch (ConfigException configException) {
            throw new MBeanException((Exception)((Object)new MBeanConfigException(configException.getMessage())));
        }
    }

    public Object getDefaultAttributeValue(String string) throws AttributeNotFoundException, MBeanConfigException {
        sLogger.log(Level.FINEST, MSG_BASE_GET_DEF_ATTR_VALUE, string);
        MBeanAttributeInfo mBeanAttributeInfo = this.getAttrInfo(string);
        if (mBeanAttributeInfo == null) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.getdefaultattribute_undefined_attribute", string);
            throw new AttributeNotFoundException(string2);
        }
        AttrDescriptor attrDescriptor = this.getDescriptor(string);
        String string3 = attrDescriptor.getDefaultValue();
        return MBeanEasyConfig.convertStringValueToProperType(string3, mBeanAttributeInfo.getType());
    }

    public void setAttribute(Attribute attribute) throws MBeanException, AttributeNotFoundException {
        String string = attribute.getName();
        Object object = attribute.getValue();
        sLogger.log(Level.FINEST, MSG_BASE_SET_ATTRIBUTE, new Object[]{string, object});
        MBeanAttributeInfo mBeanAttributeInfo = this.getAttrInfo(string);
        boolean bl = string.startsWith("property.");
        if (mBeanAttributeInfo == null && !bl) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.setattribute_undefined_attribute", string);
            throw new AttributeNotFoundException(string2);
        }
        if (mBeanAttributeInfo != null && !mBeanAttributeInfo.isWritable()) {
            String string3 = localStrings.getString("admin.server.core.mbean.config.setattribute_attribute_not_writable", string);
            throw new MBeanException((Exception)((Object)new MBeanConfigException(string3)));
        }
        try {
            if (bl) {
                AttrDescriptor attrDescriptor;
                boolean bl2 = true;
                if (mBeanAttributeInfo != null && (attrDescriptor = this.getDescriptor(string)) != null) {
                    bl2 = attrDescriptor.isEmptyValueAllowed();
                }
                this.setPropertyElementValue(new Attribute(string.substring("property.".length()), object), bl2);
                return;
            }
            AttrDescriptor attrDescriptor = this.getDescriptor(string);
            ConfigBean configBean = this.getConfigBean(string);
            if (attrDescriptor.isElement()) {
                String string4 = localStrings.getString("admin.server.core.mbean.config.getattribute_not_implemented_for_xml");
                throw new MBeanException((Exception)((Object)new MBeanConfigException(string4)));
            }
            if (object == null || object.equals(ELEMENT_CONTENT) && !attrDescriptor.isEmptyValueAllowed()) {
                configBean.setAttributeValue(attrDescriptor.getAttributeName(), null);
            } else {
                configBean.setAttributeValue(attrDescriptor.getAttributeName(), object.toString());
            }
            this.m_configContext.flush();
        }
        catch (ConfigException configException) {
            String string5 = localStrings.getString("admin.server.core.mbean.config.setAttribute_exception_for_externalname_basexpath", string, this.m_BasePath, configException.getMessage());
            throw new MBeanException((Exception)((Object)new MBeanConfigException(string5)));
        }
    }

    public AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2;
            if (stringArray[n].length() == 0) {
                stringArray2 = this.getAllAttributeNames();
                if (stringArray2 != null) {
                    attributeList.addAll(this.getAttributes(stringArray2));
                }
            } else if (stringArray[n].equals("property.")) {
                stringArray2 = this.getAllPropertyNames(true);
                if (stringArray2 != null) {
                    attributeList.addAll(this.getAttributes(stringArray2));
                }
            } else {
                try {
                    stringArray2 = this.getAttribute(stringArray[n]);
                    attributeList.add(new Attribute(stringArray[n], stringArray2));
                }
                catch (MBeanException mBeanException) {
                    attributeList.add(new Attribute(stringArray[n], null));
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    attributeList.add(new Attribute(stringArray[n], null));
                }
                catch (NullPointerException nullPointerException) {
                    attributeList.add(new Attribute(stringArray[n], null));
                }
            }
            ++n;
        }
        return attributeList;
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList();
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            try {
                Attribute attribute = (Attribute)iterator.next();
                this.setAttribute(attribute);
                attributeList2.add(attribute);
            }
            catch (MBeanException mBeanException) {
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return attributeList2;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        return null;
    }

    private Hashtable createAttrsDescriptors(String[][] stringArray) throws MBeanConfigException {
        Hashtable<String, AttrDescriptor> hashtable = new Hashtable<String, AttrDescriptor>();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                hashtable.put(stringArray[n][0], new AttrDescriptor(stringArray[n][1]));
                ++n;
            }
        }
        return hashtable;
    }

    private AttrDescriptor getDescriptor(String string) {
        return (AttrDescriptor)this.m_Attrs.get(string);
    }

    public static String convertName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        boolean bl2 = false;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (Character.isLowerCase(c)) {
                bl2 = true;
                break;
            }
            c = stringCharacterIterator.next();
        }
        c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '-' || c == '_') {
                bl = true;
            } else {
                if (bl) {
                    c = Character.toUpperCase(c);
                } else if (!bl2) {
                    c = Character.toLowerCase(c);
                }
                stringBuffer.append(c);
                bl = false;
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    private MBeanAttributeInfo getAttrInfo(String string) {
        if (string == null || this.m_MBeanInfo == null) {
            return null;
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.m_MBeanInfo.getAttributes();
        if (mBeanAttributeInfoArray != null) {
            int n = 0;
            while (n < mBeanAttributeInfoArray.length) {
                String string2 = mBeanAttributeInfoArray[n].getName();
                if (string.equals(mBeanAttributeInfoArray[n].getName())) {
                    return mBeanAttributeInfoArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    private String[] getAllAttributeNames() {
        if (this.m_Attrs == null) {
            return null;
        }
        Enumeration enumeration = this.m_Attrs.keys();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getAllPropertyNames(boolean bl) {
        ConfigBean configBean = this.getBaseConfigBean();
        Class<?> clazz = configBean.getClass();
        try {
            Method method = clazz.getDeclaredMethod("getElementProperty", null);
            ElementProperty[] elementPropertyArray = (ElementProperty[])method.invoke((Object)configBean, null);
            String[] stringArray = new String[elementPropertyArray.length];
            int n = 0;
            while (n < elementPropertyArray.length) {
                stringArray[n] = bl ? "property." + elementPropertyArray[n].getName() : elementPropertyArray[n].getName();
                ++n;
            }
            return stringArray;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    static Object[] MergeAttributesWithAnotherMbean(String[][] stringArray, String[] stringArray2, String[][] stringArray3, String[] stringArray4, String string, String string2) {
        int n = 0;
        if (stringArray != null) {
            n += stringArray.length;
        }
        if (stringArray3 != null) {
            n += stringArray3.length;
        }
        String[][] stringArrayArray = new String[n][];
        String[] stringArray5 = new String[n];
        int n2 = 0;
        if (stringArray != null) {
            n2 = 0;
            while (n2 < stringArray.length) {
                stringArrayArray[n2] = (String[])stringArray[n2].clone();
                stringArray5[n2] = stringArray2[n2];
                ++n2;
            }
        }
        if (stringArray3 != null) {
            int n3 = 0;
            while (n3 < stringArray3.length) {
                String[] stringArray6 = (String[])stringArray3[n3].clone();
                stringArray5[n2 + n3] = stringArray4[n3];
                if (string2 != null) {
                    stringArray6[0] = string2 + stringArray6[0];
                    stringArray5[n2 + n3] = string2 + stringArray4[n3].trim();
                }
                stringArray6[1] = string + "/" + stringArray6[1];
                stringArrayArray[n2 + n3] = stringArray6;
                ++n3;
            }
        }
        return new Object[]{stringArrayArray, stringArray5};
    }

    private static Class getConfigBeanClass(String string) {
        String string2 = ConfigBeansFactory.getConfigBeanNameByXPath(string);
        try {
            Class<?> clazz = Class.forName("com.iplanet.ias.config.serverbeans." + string2);
            return clazz;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AttrDescriptor {
        public String m_xPath = "";
        public String m_attributeName;
        public boolean m_bAllowsEmptyValue = false;

        public AttrDescriptor(String string) throws MBeanConfigException {
            try {
                int n = string.lastIndexOf("/");
                if (string.charAt(n + 1) == '@') {
                    if (string.charAt(n + 2) == '@') {
                        this.m_attributeName = string.substring(n + 3);
                        this.m_bAllowsEmptyValue = true;
                    } else {
                        this.m_attributeName = string.substring(n + 2);
                    }
                    if (n > 0) {
                        this.m_xPath = string.substring(0, n);
                    }
                } else {
                    this.m_attributeName = null;
                }
            }
            catch (Throwable throwable) {
                String string2 = localStrings.getString("admin.server.core.mbean.config.attrdescriptor_constructor_exception", string, throwable.getMessage());
                throw new MBeanConfigException(string2);
            }
        }

        public String getAttributeName() {
            return this.m_attributeName;
        }

        public String getXPath() {
            if (ConfigMBeanBase.this.m_BasePath == null || ConfigMBeanBase.this.m_BasePath.length() == 0 || this.m_xPath.indexOf("/") == 0) {
                return this.m_xPath;
            }
            if (this.m_xPath.length() == 0) {
                return ConfigMBeanBase.this.m_BasePath;
            }
            return ConfigMBeanBase.this.m_BasePath + "/" + this.m_xPath;
        }

        public boolean isEmptyValueAllowed() {
            return this.m_bAllowsEmptyValue;
        }

        public ConfigBean getConfigBean() throws Exception {
            return ConfigMBeanBase.this.getConfigBeanByXPath(this.getXPath());
        }

        public String getDefaultValue() {
            Class clazz = ConfigMBeanBase.getConfigBeanClass(this.getXPath());
            try {
                Method method = clazz.getMethod("getDefaultAttributeValue", Class.forName("java.lang.String"));
                return (String)method.invoke(null, this.m_attributeName);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean isElement() {
            return this.m_attributeName == null;
        }
    }
}

