/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.ConnectionFactory;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.api.persistence.support.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.RuntimeVersion;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.ConnectionFactoryImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.SQLPersistenceManagerFactory;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class PersistenceManagerFactoryImpl
implements PersistenceManagerFactory {
    private String URL = null;
    private String userName = null;
    private String password = null;
    private String driverName = null;
    private ConnectionFactory connectionFactory = null;
    private Object dataSource = null;
    private String connectionFactoryName = null;
    private int connectionMaxPool = 0;
    private int connectionMinPool = 0;
    private int connectionMsInterval = 0;
    private int connectionLoginTimeout = 0;
    private int connectionMsWait = 0;
    private int txIsolation = -1;
    private PrintWriter connectionLogWriter;
    private boolean optimistic = true;
    private boolean retainValues = true;
    private boolean nontransactionalRead = true;
    private boolean ignoreCache = false;
    private int queryTimeout = 0;
    private int updateTimeout = 0;
    private int maxPool = 0;
    private int minPool = 0;
    private boolean supersedeDeletedInstance = true;
    private static final int NOT_SET = 0;
    private static final int SET_AS_CONNECTIONFACTORY = 1;
    private static final int SET_AS_DATASOURCE = 2;
    private int providedConnectionFactory = 0;
    private transient SQLPersistenceManagerFactory pmFactory = null;
    private static final ResourceBundle messages = I18NHelper.loadBundle(class$com$sun$jdo$spi$persistence$support$sqlstore$impl$PersistenceManagerFactoryImpl == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$impl$PersistenceManagerFactoryImpl = PersistenceManagerFactoryImpl.class$("com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerFactoryImpl")) : class$com$sun$jdo$spi$persistence$support$sqlstore$impl$PersistenceManagerFactoryImpl);
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$impl$PersistenceManagerFactoryImpl;

    public PersistenceManagerFactoryImpl() {
        EJBHelper.setPersistenceManagerFactoryDefaults(this);
    }

    public PersistenceManagerFactoryImpl(String string, String string2, String string3, String string4) {
        EJBHelper.setPersistenceManagerFactoryDefaults(this);
        this.URL = string;
        this.userName = string2;
        this.password = string3;
        this.driverName = string4;
    }

    public void setConnectionUserName(String string) {
        this.assertNotConfigured();
        this.userName = string;
    }

    public String getConnectionUserName() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getUserName();
        }
        return this.userName;
    }

    public void setConnectionPassword(String string) {
        this.assertNotConfigured();
        this.password = string;
    }

    public void setConnectionURL(String string) {
        this.assertNotConfigured();
        this.URL = string;
    }

    public String getConnectionURL() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getURL();
        }
        return this.URL;
    }

    public void setConnectionDriverName(String string) {
        this.assertNotConfigured();
        this.driverName = string;
    }

    public String getConnectionDriverName() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getDriverName();
        }
        return this.driverName;
    }

    public void setConnectionFactory(Object object) {
        this.assertNotConfigured();
        if (object == null) {
            this.connectionFactory = null;
            this.dataSource = null;
            this.providedConnectionFactory = 0;
        } else if (EJBHelper.isManaged() || object instanceof DataSource) {
            this.dataSource = object;
            this.providedConnectionFactory = 2;
        } else if (object instanceof ConnectionFactory) {
            this.connectionFactory = (ConnectionFactory)object;
            this.providedConnectionFactory = 1;
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.wrongtype"));
        }
    }

    public Object getConnectionFactory() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        return this.connectionFactory;
    }

    public void setConnectionFactoryName(String string) {
        this.assertNotConfigured();
        this.connectionFactoryName = string;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionMaxPool(int n) {
        this.assertNotConfigured();
        this.connectionMaxPool = n;
    }

    public int getConnectionMaxPool() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getMaxPool();
        }
        return this.connectionMaxPool;
    }

    public void setConnectionMinPool(int n) {
        this.assertNotConfigured();
        this.connectionMinPool = n;
    }

    public int getConnectionMinPool() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getMinPool();
        }
        return this.connectionMinPool;
    }

    public void setConnectionMsWait(int n) {
        this.assertNotConfigured();
        this.connectionMsWait = n;
    }

    public int getConnectionMsWait() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getMsWait();
        }
        return this.connectionMsWait;
    }

    public int getMaxPool() {
        return this.maxPool;
    }

    public void setMaxPool(int n) {
        this.assertNotConfigured();
        this.maxPool = this.maxPool;
    }

    public int getMinPool() {
        return this.minPool;
    }

    public void setMinPool(int n) {
        this.assertNotConfigured();
        this.minPool = this.minPool;
    }

    public void setConnectionMsInterval(int n) {
        this.assertNotConfigured();
        this.connectionMsInterval = n;
    }

    public int getConnectionMsInterval() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getMsInterval();
        }
        return this.connectionMsInterval;
    }

    public void setConnectionLoginTimeout(int n) {
        this.assertNotConfigured();
        this.connectionLoginTimeout = n;
    }

    public int getConnectionLoginTimeout() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getLoginTimeout();
        }
        return this.connectionLoginTimeout;
    }

    public void setConnectionLogWriter(PrintWriter printWriter) {
        this.assertNotConfigured();
        this.connectionLogWriter = printWriter;
    }

    public PrintWriter getConnectionLogWriter() {
        return this.connectionLogWriter;
    }

    public void setQueryTimeout(int n) {
        this.assertNotConfigured();
        this.queryTimeout = n;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setUpdateTimeout(int n) {
        this.assertNotConfigured();
        this.updateTimeout = n;
    }

    public int getUpdateTimeout() {
        return this.updateTimeout;
    }

    public void setConnectionTransactionIsolation(int n) {
        this.assertNotConfigured();
        this.txIsolation = n;
    }

    public int getConnectionTransactionIsolation() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getTransactionIsolation();
        }
        return this.txIsolation;
    }

    public void setOptimistic(String string) {
        this.setOptimistic(Boolean.getBoolean(string));
    }

    public void setOptimistic(boolean bl) {
        this.assertNotConfigured();
        this.optimistic = bl;
        if (bl) {
            this.nontransactionalRead = bl;
        }
    }

    public boolean getOptimistic() {
        return this.optimistic;
    }

    public void setRetainValues(String string) {
        this.setRetainValues(Boolean.getBoolean(string));
    }

    public void setRetainValues(boolean bl) {
        this.assertNotConfigured();
        this.retainValues = bl;
        if (bl) {
            this.nontransactionalRead = bl;
        }
    }

    public boolean getRetainValues() {
        return this.retainValues;
    }

    public void setNontransactionalRead(String string) {
        this.setNontransactionalRead(Boolean.getBoolean(string));
    }

    public void setNontransactionalRead(boolean bl) {
        this.assertNotConfigured();
        this.nontransactionalRead = bl;
        if (!bl) {
            this.retainValues = bl;
            this.optimistic = bl;
        }
    }

    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public void setIgnoreCache(String string) {
        this.setIgnoreCache(Boolean.getBoolean(string));
    }

    public void setIgnoreCache(boolean bl) {
        this.assertNotConfigured();
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public Properties getProperties() {
        if (this.pmFactory != null) {
            return this.pmFactory.getProperties();
        }
        return RuntimeVersion.getVendorProperties("/com/sun/jdo/spi/persistence/support/sqlstore/sys.properties");
    }

    public PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(null, null);
    }

    public boolean getSupersedeDeletedInstance() {
        return this.supersedeDeletedInstance;
    }

    public void setSupersedeDeletedInstance(boolean bl) {
        this.assertNotConfigured();
        this.supersedeDeletedInstance = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceManager getPersistenceManager(String string, String string2) {
        PersistenceManagerFactoryImpl persistenceManagerFactoryImpl = this;
        synchronized (persistenceManagerFactoryImpl) {
            if (this.pmFactory == null) {
                block15: {
                    if (this.providedConnectionFactory == 0) {
                        if (this.connectionFactoryName == null) {
                            this.assertConnectionWait();
                            this.connectionFactory = new ConnectionFactoryImpl();
                            this.connectionFactory.setURL(this.URL);
                            this.connectionFactory.setUserName(this.userName);
                            this.connectionFactory.setPassword(this.password);
                            this.connectionFactory.setDriverName(this.driverName);
                            this.connectionFactory.setMinPool(this.connectionMinPool);
                            this.connectionFactory.setMaxPool(this.connectionMaxPool);
                            this.connectionFactory.setMsWait(this.connectionMsWait);
                            this.connectionFactory.setMsInterval(this.connectionMsInterval);
                            this.connectionFactory.setLogWriter(this.connectionLogWriter);
                            this.connectionFactory.setLoginTimeout(this.connectionLoginTimeout);
                            if (this.txIsolation > 0) {
                                this.connectionFactory.setTransactionIsolation(this.txIsolation);
                            }
                        } else {
                            try {
                                InitialContext initialContext = (InitialContext)Class.forName("javax.naming.InitialContext").newInstance();
                                Object object = initialContext.lookup(this.connectionFactoryName);
                                if (EJBHelper.isManaged() || object instanceof DataSource) {
                                    this.dataSource = object;
                                    break block15;
                                }
                                if (object instanceof ConnectionFactory) {
                                    this.connectionFactory = (ConnectionFactory)object;
                                    break block15;
                                }
                                throw new JDOUserException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.wrongtype"));
                            }
                            catch (JDOException jDOException) {
                                throw jDOException;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new JDOUserException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.initialcontext"));
                            }
                            catch (Exception exception) {
                                throw new JDOUserException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.lookup"), exception);
                            }
                        }
                    }
                }
                this.pmFactory = new SQLPersistenceManagerFactory(this);
                this.pmFactory = (SQLPersistenceManagerFactory)EJBHelper.replaceInternalPersistenceManagerFactory(this.pmFactory);
            }
        }
        if (string != null && this.connectionFactory != null) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.notsupported"));
        }
        return this.pmFactory.getPersistenceManager(string, string2);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PersistenceManagerFactoryImpl)) {
            return false;
        }
        PersistenceManagerFactoryImpl persistenceManagerFactoryImpl = (PersistenceManagerFactoryImpl)object;
        if (persistenceManagerFactoryImpl.providedConnectionFactory == this.providedConnectionFactory) {
            if (persistenceManagerFactoryImpl.providedConnectionFactory == 1) {
                return persistenceManagerFactoryImpl.connectionFactory.equals(this.connectionFactory);
            }
            if (persistenceManagerFactoryImpl.providedConnectionFactory == 2) {
                return persistenceManagerFactoryImpl.dataSource.equals(this.dataSource);
            }
            if (persistenceManagerFactoryImpl.connectionFactoryName != null) {
                return persistenceManagerFactoryImpl.connectionFactoryName.equals(this.connectionFactoryName);
            }
            return persistenceManagerFactoryImpl.URL.equals(this.URL) && persistenceManagerFactoryImpl.userName.equals(this.userName) && persistenceManagerFactoryImpl.password.equals(this.password) && persistenceManagerFactoryImpl.driverName.equals(this.driverName);
        }
        return false;
    }

    public int hashCode() {
        if (this.providedConnectionFactory == 1) {
            return this.connectionFactory.hashCode();
        }
        if (this.providedConnectionFactory == 2) {
            return this.dataSource.hashCode();
        }
        if (this.connectionFactoryName != null) {
            return this.connectionFactoryName.hashCode();
        }
        return this.URL.hashCode() + this.userName.hashCode() + this.password.hashCode() + this.driverName.hashCode();
    }

    private void assertNotConfigured() {
        if (this.pmFactory != null) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.configured"));
        }
    }

    private void assertConnectionWait() {
        if (this.connectionMsWait < 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "connection.connectionmanager.mswaitvalue"));
        }
        if (this.connectionMsInterval < 0 || this.connectionMsInterval > this.connectionMsWait || this.connectionMsWait > 0 && this.connectionMsInterval == 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "connection.connectionmanager.msintervalvalue"));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

